/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class shift_right
extends EditAction {
    public void actionPerformed(ActionEvent evt) {
        View view = shift_right.getView(evt);
        Buffer buffer = view.getBuffer();
        buffer.beginCompoundEdit();
        try {
            JEditTextArea textArea = view.getTextArea();
            if (!textArea.isEditable()) {
                view.getToolkit().beep();
                return;
            }
            try {
                int tabSize = buffer.getTabSize();
                boolean noTabs = "yes".equals(buffer.getProperty("noTabs"));
                Element map = buffer.getDefaultRootElement();
                int start = textArea.getSelectionStartLine();
                int end2 = textArea.getSelectionEndLine();
                int i = start;
                while (i <= end2) {
                    Element lineElement = map.getElement(i);
                    int lineStart = lineElement.getStartOffset();
                    String line = buffer.getText(lineStart, lineElement.getEndOffset() - lineStart - 1);
                    int whiteSpace = MiscUtilities.getLeadingWhiteSpace(line);
                    int whiteSpaceWidth = MiscUtilities.getLeadingWhiteSpaceWidth(line, tabSize) + tabSize;
                    buffer.remove(lineStart, whiteSpace);
                    buffer.insertString(lineStart, MiscUtilities.createWhiteSpace(whiteSpaceWidth, noTabs ? 0 : tabSize), null);
                    ++i;
                }
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
            }
        }
        finally {
            buffer.endCompoundEdit();
        }
    }
}

