/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class indent_on_tab
extends EditAction {
    public void actionPerformed(ActionEvent evt) {
        int selEnd;
        View view = indent_on_tab.getView(evt);
        Buffer buffer = view.getBuffer();
        JEditTextArea textArea = view.getTextArea();
        if (Abbrevs.getExpandOnInput()) {
            Abbrevs.expandAbbrev(view, false);
        }
        Mode mode = buffer.getMode();
        int selStart = textArea.getSelectionStart();
        if (selStart == (selEnd = textArea.getSelectionEnd()) && "on".equals(buffer.getProperty("indentOnTab")) && mode.indentLine(buffer, view, textArea.getSelectionStartLine(), false)) {
            return;
        }
        if ("yes".equals(buffer.getProperty("noTabs"))) {
            Element map = buffer.getDefaultRootElement();
            Element lineElement = map.getElement(textArea.getSelectionStartLine());
            try {
                String line = buffer.getText(lineElement.getStartOffset(), selStart - lineElement.getStartOffset());
                textArea.setSelectedText(this.createSoftTab(line, buffer.getTabSize()));
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
            }
        } else {
            textArea.setSelectedText("\t");
        }
    }

    private String createSoftTab(String line, int tabSize) {
        int pos = 0;
        int i = 0;
        while (i < line.length()) {
            switch (line.charAt(pos)) {
                case '\t': {
                    pos = 0;
                    break;
                }
                default: {
                    if (++pos < tabSize) break;
                    pos = 0;
                }
            }
            ++i;
        }
        return MiscUtilities.createWhiteSpace(tabSize - pos, 0);
    }
}

