/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.gui.BufferTabs;
import org.gjt.sp.jedit.gui.CurrentDirectoryMenu;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.EnhancedMenuItem;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.SearchDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.MacrosChanged;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class View
extends JFrame
implements EBComponent {
    View prev;
    View next;
    private Buffer buffer;
    private boolean closed;
    private JMenu buffers;
    private JMenu recent;
    private JMenu currentDirectory;
    private JMenu clearMarker;
    private JMenu gotoMarker;
    private JMenu macros;
    private JMenu plugins;
    private JMenu help;
    private Box toolBars;
    private JToolBar toolBar;
    private HistoryTextField quicksearch;
    private JComboBox funcList;
    private JButton cb_format;
    private EnhancedButton ignoreCase;
    private EnhancedButton regexp;
    private EnhancedButton multifile;
    private BufferTabs bufferTabs;
    private JSplitPane splitPane;
    public JEditTextArea textArea;
    private int waitCount;
    private boolean showFullPath;

    public void pushStatus(String str) {
        ((StatusBar)this.textArea.getStatus()).pushStatus(str);
    }

    public void popStatus() {
        ((StatusBar)this.textArea.getStatus()).popStatus();
    }

    public final Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        Mode mode;
        if (this.buffer == buffer) {
            return;
        }
        buffer.loadIfNecessary(this);
        Buffer oldBuffer = this.buffer;
        if (oldBuffer != null) {
            this.saveCaretInfo();
            mode = oldBuffer.getMode();
            if (mode != null) {
                mode.leaveView(this);
            }
        }
        this.buffer = buffer;
        this.unsplit();
        this.textArea.setDocument(buffer);
        ((StatusBar)this.textArea.getStatus()).repaint();
        this.loadCaretInfo();
        this.updateMarkerMenus();
        this.updateTitle();
        mode = buffer.getMode();
        if (mode != null) {
            mode.enterView(this);
        }
        if (oldBuffer != null) {
            EditBus.send(new ViewUpdate(this, ViewUpdate.BUFFER_CHANGED));
        }
        if (this.bufferTabs != null) {
            this.bufferTabs.selectBufferTab(buffer);
        }
        this.updateBuffersMenu();
        this.focusOnTextArea();
    }

    public final void focusOnTextArea() {
        this.textArea.requestFocus();
    }

    public final HistoryTextField getQuickSearch() {
        if (this.quicksearch.isShowing()) {
            return this.quicksearch;
        }
        return null;
    }

    public final JComboBox getFuncList() {
        return this.funcList;
    }

    public final JEditTextArea getTextArea() {
        return this.textArea;
    }

    public void split(int orientation) {
        if (this.splitPane == null) {
            this.saveCaretInfo();
            JEditTextArea oldTextArea = this.textArea;
            this.textArea = this.createTextArea();
            JComponent oldParent = (JComponent)oldTextArea.getParent();
            this.splitPane = new JSplitPane(orientation, oldTextArea, this.textArea);
            this.splitPane.setBorder(null);
            this.initTextArea(this.textArea, oldTextArea);
            this.loadCaretInfo();
            if (this.bufferTabs != null) {
                this.bufferTabs.update();
            } else {
                oldParent.add(this.splitPane);
                oldParent.revalidate();
            }
        } else {
            this.splitPane.setOrientation(orientation);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                View.this.splitPane.setDividerLocation(0.5);
                View.this.focusOnTextArea();
            }
        });
    }

    public void unsplit() {
        if (this.splitPane != null) {
            boolean left = this.splitPane.getLeftComponent() == this.textArea;
            JEditTextArea oldTextArea = (JEditTextArea)(left ? this.splitPane.getRightComponent() : this.splitPane.getLeftComponent());
            JEditTextArea newTextArea = this.textArea;
            JComponent parent = (JComponent)this.splitPane.getParent();
            System.out.println(parent.getClass().getName());
            parent.remove(this.splitPane);
            this.splitPane = null;
            if (this.bufferTabs != null) {
                this.bufferTabs.update();
            } else {
                parent.add(newTextArea);
                parent.revalidate();
            }
            EditBus.send(new ViewUpdate(this, oldTextArea, ViewUpdate.TEXTAREA_DESTROYED));
        }
        this.focusOnTextArea();
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public JEditTextArea[] getTextAreas() {
        if (this.splitPane == null) {
            JEditTextArea[] ta = new JEditTextArea[]{this.textArea};
            return ta;
        }
        JEditTextArea[] ta = new JEditTextArea[]{(JEditTextArea)this.splitPane.getLeftComponent(), (JEditTextArea)this.splitPane.getRightComponent()};
        return ta;
    }

    public void addToolBar(Component toolBar) {
        this.toolBars.add(toolBar);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component toolBar) {
        this.toolBars.remove(toolBar);
        this.getRootPane().revalidate();
    }

    public void saveCaretInfo() {
        this.buffer.putProperty("Buffer__selStart", new Integer(this.textArea.getSelectionStart()));
        this.buffer.putProperty("Buffer__selEnd", new Integer(this.textArea.getSelectionEnd()));
        this.buffer.putProperty("Buffer__rect", new Boolean(this.textArea.isSelectionRectangular()));
        this.buffer.putProperty("Buffer__scrollVert", new Integer(this.textArea.getFirstLine()));
        this.buffer.putProperty("Buffer__scrollHoriz", new Integer(this.textArea.getHorizontalOffset()));
        this.buffer.putProperty("Buffer__overwrite", new Boolean(this.textArea.isOverwriteEnabled()));
    }

    public void loadCaretInfo() {
        Integer start = (Integer)this.buffer.getProperty("Buffer__selStart");
        Integer end2 = (Integer)this.buffer.getProperty("Buffer__selEnd");
        Boolean rectSel = (Boolean)this.buffer.getProperty("Buffer__rect");
        Integer firstLine = (Integer)this.buffer.getProperty("Buffer__scrollVert");
        Integer horizontalOffset = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
        Boolean overwrite2 = (Boolean)this.buffer.getProperty("Buffer__overwrite");
        if (start != null && end2 != null && firstLine != null && horizontalOffset != null) {
            this.textArea.select(Math.min(start, this.buffer.getLength()), Math.min(end2, this.buffer.getLength()));
            this.textArea.setFirstLine(firstLine);
            this.textArea.setHorizontalOffset(horizontalOffset);
        }
        if (rectSel != null && overwrite2 != null) {
            this.textArea.setSelectionRectangular(rectSel);
            this.textArea.setOverwriteEnabled(overwrite2);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            JEditTextArea[] textAreas = this.getTextAreas();
            int i = 0;
            while (i < textAreas.length) {
                JEditTextArea textArea = textAreas[i];
                textArea.getPainter().setCursor(cursor);
                ++i;
            }
        }
    }

    public void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            cursor = Cursor.getPredefinedCursor(2);
            JEditTextArea[] textAreas = this.getTextAreas();
            int i = 0;
            while (i < textAreas.length) {
                JEditTextArea textArea = textAreas[i];
                textArea.getPainter().setCursor(cursor);
                ++i;
            }
        }
    }

    public final View getNext() {
        return this.next;
    }

    public final View getPrev() {
        return this.prev;
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof MacrosChanged) {
            this.updateMacrosMenu();
        } else if (msg instanceof SearchSettingsChanged) {
            if (this.toolBar != null) {
                this.ignoreCase.repaint();
                this.regexp.repaint();
                this.multifile.repaint();
            }
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        }
    }

    public JMenu getMenu(String name) {
        if (name.equals("buffers")) {
            return this.buffers;
        }
        if (name.equals("recent-files")) {
            return this.recent;
        }
        if (name.equals("current-directory")) {
            return this.currentDirectory;
        }
        if (name.equals("clear-marker")) {
            return this.clearMarker;
        }
        if (name.equals("goto-marker")) {
            return this.gotoMarker;
        }
        if (name.equals("macros")) {
            return this.macros;
        }
        if (name.equals("plugins")) {
            return this.plugins;
        }
        if (name.equals("help-menu")) {
            return this.help;
        }
        return null;
    }

    View(View view, Buffer buffer) {
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.buffers = GUIUtilities.loadMenu(this, "buffers");
        this.recent = GUIUtilities.loadMenu(this, "recent-files");
        this.currentDirectory = new CurrentDirectoryMenu(this);
        this.clearMarker = GUIUtilities.loadMenu(this, "clear-marker");
        this.gotoMarker = GUIUtilities.loadMenu(this, "goto-marker");
        this.macros = GUIUtilities.loadMenu(this, "macros");
        this.help = GUIUtilities.loadMenu(this, "help-menu");
        this.plugins = GUIUtilities.loadMenu(this, "plugins");
        this.updateMacrosMenu();
        this.updateHelpMenu();
        this.updatePluginsMenu();
        EditBus.addToBus(this);
        this.setJMenuBar(GUIUtilities.loadMenuBar(this, "view.mbar"));
        this.toolBars = new Box(1);
        this.quicksearch = new HistoryTextField("find");
        Dimension dim = this.quicksearch.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.quicksearch.setMaximumSize(dim);
        this.quicksearch.addActionListener(new ActionHandler());
        this.quicksearch.addKeyListener(new KeyHandler());
        this.textArea = this.createTextArea();
        if (view == null) {
            this.propertiesChanged();
        } else {
            this.loadPropertiesFromView(view);
        }
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
        this.getContentPane().add("North", this.toolBars);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
    }

    void close() {
        this.closed = true;
        GUIUtilities.saveGeometry(this, "view");
        this.saveCaretInfo();
        EditBus.removeFromBus(this);
        this.dispose();
        JEditTextArea[] textAreas = this.getTextAreas();
        int i = 0;
        while (i < textAreas.length) {
            EditBus.send(new ViewUpdate(this, textAreas[i], ViewUpdate.TEXTAREA_DESTROYED));
            ++i;
        }
    }

    private void propertiesChanged() {
        this.loadToolBar();
        this.initBufferTabs();
        this.showFullPath = "on".equals(jEdit.getProperty("view.showFullPath"));
        if (this.buffer != null) {
            this.updateTitle();
        }
        JEditTextArea[] textAreas = this.getTextAreas();
        int i = 0;
        while (i < textAreas.length) {
            this.initTextArea(textAreas[i]);
            ++i;
        }
        this.loadStyles();
        this.updateRecentMenu();
    }

    private void initTextArea(JEditTextArea textArea) {
        int style;
        int size;
        TextAreaPainter painter = textArea.getPainter();
        String family = jEdit.getProperty("view.font");
        try {
            size = Integer.parseInt(jEdit.getProperty("view.fontsize"));
        }
        catch (NumberFormatException nf) {
            size = 14;
        }
        try {
            style = Integer.parseInt(jEdit.getProperty("view.fontstyle"));
        }
        catch (NumberFormatException nf) {
            style = 0;
        }
        Font font = new Font(family, style, size);
        painter.setFont(font);
        painter.setLineHighlightEnabled("on".equals(jEdit.getProperty("view.lineHighlight")));
        painter.setLineHighlightColor(GUIUtilities.parseColor(jEdit.getProperty("view.lineHighlightColor")));
        painter.setBracketHighlightEnabled("on".equals(jEdit.getProperty("view.bracketHighlight")));
        painter.setBracketHighlightColor(GUIUtilities.parseColor(jEdit.getProperty("view.bracketHighlightColor")));
        painter.setEOLMarkersPainted("on".equals(jEdit.getProperty("view.eolMarkers")));
        painter.setInvalidLinesPainted("on".equals(jEdit.getProperty("view.paintInvalid")));
        painter.setEOLMarkerColor(GUIUtilities.parseColor(jEdit.getProperty("view.eolMarkerColor")));
        painter.setCaretColor(GUIUtilities.parseColor(jEdit.getProperty("view.caretColor")));
        painter.setSelectionColor(GUIUtilities.parseColor(jEdit.getProperty("view.selectionColor")));
        painter.setBackground(GUIUtilities.parseColor(jEdit.getProperty("view.bgColor")));
        painter.setForeground(GUIUtilities.parseColor(jEdit.getProperty("view.fgColor")));
        painter.setBlockCaretEnabled("on".equals(jEdit.getProperty("view.blockCaret")));
        Gutter gutter = textArea.getGutter();
        try {
            int width = Integer.parseInt(jEdit.getProperty("view.gutter.width"));
            gutter.setGutterWidth(width);
        }
        catch (NumberFormatException width) {
            // empty catch block
        }
        gutter.setCollapsed("yes".equals(jEdit.getProperty("view.gutter.collapsed")));
        gutter.setLineNumberingEnabled(!"no".equals(jEdit.getProperty("view.gutter.lineNumbers")));
        try {
            int interval = Integer.parseInt(jEdit.getProperty("view.gutter.highlightInterval"));
            gutter.setHighlightInterval(interval);
        }
        catch (NumberFormatException interval) {
            // empty catch block
        }
        gutter.setBackground(GUIUtilities.parseColor(jEdit.getProperty("view.gutter.bgColor")));
        gutter.setForeground(GUIUtilities.parseColor(jEdit.getProperty("view.gutter.fgColor")));
        gutter.setHighlightedForeground(GUIUtilities.parseColor(jEdit.getProperty("view.gutter.highlightColor")));
        String alignment = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(alignment)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        try {
            int width = Integer.parseInt(jEdit.getProperty("view.gutter.borderWidth"));
            gutter.setBorder(width, GUIUtilities.parseColor(jEdit.getProperty("view.gutter.borderColor")));
        }
        catch (NumberFormatException width) {
            // empty catch block
        }
        try {
            String fontname = jEdit.getProperty("view.gutter.font");
            int fontsize = Integer.parseInt(jEdit.getProperty("view.gutter.fontsize"));
            int fontstyle = Integer.parseInt(jEdit.getProperty("view.gutter.fontstyle"));
            gutter.setFont(new Font(fontname, fontstyle, fontsize));
        }
        catch (NumberFormatException fontname) {
            // empty catch block
        }
        textArea.setCaretBlinkEnabled("on".equals(jEdit.getProperty("view.caretBlink")));
        textArea.putClientProperty("InputHandler.homeEnd", new Boolean("yes".equals(jEdit.getProperty("view.homeEnd"))));
        try {
            textArea.setElectricScroll(Integer.parseInt(jEdit.getProperty("view.electricBorders")));
        }
        catch (NumberFormatException nf) {
            textArea.setElectricScroll(0);
        }
    }

    private void loadStyles() {
        try {
            SyntaxStyle[] styles = new SyntaxStyle[11];
            styles[1] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.comment1"));
            styles[2] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.comment2"));
            styles[6] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.keyword1"));
            styles[7] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.keyword2"));
            styles[8] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.keyword3"));
            styles[5] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.label"));
            styles[3] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.literal1"));
            styles[4] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.literal2"));
            styles[9] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.operator"));
            styles[10] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.invalid"));
            JEditTextArea[] textAreas = this.getTextAreas();
            int i = 0;
            while (i < textAreas.length) {
                JEditTextArea textArea = textAreas[i];
                textArea.getPainter().setStyles(styles);
                ++i;
            }
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
    }

    private void loadPropertiesFromView(View view) {
        this.loadToolBar();
        this.initBufferTabs();
        this.showFullPath = view.showFullPath;
        JEditTextArea[] textAreas = this.getTextAreas();
        int i = 0;
        while (i < textAreas.length) {
            this.initTextArea(textAreas[i], view.textArea);
            ++i;
        }
        this.updateRecentMenu();
    }

    private void initTextArea(JEditTextArea textArea, JEditTextArea copy2) {
        TextAreaPainter painter = copy2.getPainter();
        TextAreaPainter myPainter = textArea.getPainter();
        myPainter.setFont(painter.getFont());
        myPainter.setLineHighlightEnabled(painter.isLineHighlightEnabled());
        myPainter.setLineHighlightColor(painter.getLineHighlightColor());
        myPainter.setBracketHighlightEnabled(painter.isBracketHighlightEnabled());
        myPainter.setBracketHighlightColor(painter.getBracketHighlightColor());
        myPainter.setEOLMarkersPainted(painter.getEOLMarkersPainted());
        myPainter.setInvalidLinesPainted(painter.getInvalidLinesPainted());
        myPainter.setEOLMarkerColor(painter.getEOLMarkerColor());
        myPainter.setCaretColor(painter.getCaretColor());
        myPainter.setSelectionColor(painter.getSelectionColor());
        myPainter.setBackground(painter.getBackground());
        myPainter.setForeground(painter.getForeground());
        myPainter.setBlockCaretEnabled(painter.isBlockCaretEnabled());
        myPainter.setStyles(painter.getStyles());
        Gutter myGutter = textArea.getGutter();
        Gutter gutter = copy2.getGutter();
        myGutter.setGutterWidth(gutter.getGutterWidth());
        myGutter.setCollapsed(gutter.isCollapsed());
        myGutter.setLineNumberingEnabled(gutter.isLineNumberingEnabled());
        myGutter.setHighlightInterval(gutter.getHighlightInterval());
        myGutter.setLineNumberAlignment(gutter.getLineNumberAlignment());
        myGutter.setFont(gutter.getFont());
        myGutter.setBorder(gutter.getBorder());
        myGutter.setBackground(gutter.getBackground());
        myGutter.setForeground(gutter.getForeground());
        myGutter.setHighlightedForeground(gutter.getHighlightedForeground());
        textArea.setCaretBlinkEnabled(copy2.isCaretBlinkEnabled());
        textArea.putClientProperty("InputHandler.homeEnd", copy2.getClientProperty("InputHandler.homeEnd"));
        textArea.setElectricScroll(copy2.getElectricScroll());
        myPainter.setStyles(painter.getStyles());
    }

    public void funcListAddActionListener() {
        this.funcList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String s = (String)cb.getSelectedItem();
                View.this.gotoFunction(s);
            }
        });
    }

    public void gotoFunction(String funcName) {
        try {
            int p2;
            String t;
            int start;
            Element line;
            funcName = funcName.trim();
            Element map = this.buffer.getDefaultRootElement();
            Segment lineSegment = new Segment();
            int i = 0;
            while (i < map.getElementCount()) {
                line = map.getElement(i);
                start = line.getStartOffset();
                this.buffer.getText(start, line.getEndOffset() - start - 1, lineSegment);
                t = lineSegment.toString();
                int p1 = t.indexOf("function");
                p2 = t.indexOf(" " + funcName + " ");
                int p4 = t.indexOf(" " + funcName + "(");
                if (!(p1 < 0 || p2 <= 0 && p4 <= 0 || p2 <= p1 && p4 <= p1)) {
                    this.getTextArea().setCaretPosition(line.getStartOffset());
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < map.getElementCount()) {
                line = map.getElement(i);
                start = line.getStartOffset();
                this.buffer.getText(start, line.getEndOffset() - start - 1, lineSegment);
                t = lineSegment.toString();
                int p3 = t.indexOf("var");
                p2 = t.indexOf(" " + funcName);
                if (p3 >= 0 && p2 > 0 && p2 > p3) {
                    this.getTextArea().setCaretPosition(line.getStartOffset());
                    return;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadToolBar() {
        if ("on".equals(jEdit.getProperty("view.showToolbar"))) {
            if (this.toolBar == null) {
                this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
                this.toolBar.addSeparator();
                this.toolBar.add(new JLabel("\u51fd\u6570\u5b9a\u4f4d\uff1a"));
                this.funcList = new JComboBox();
                DefaultComboBoxModel cbm = new DefaultComboBoxModel();
                this.funcList.setModel(cbm);
                this.funcListAddActionListener();
                this.toolBar.add(this.funcList);
                this.funcList.setToolTipText("\u70b9\u51fb\u4fdd\u5b58\uff0c\u672c\u51fd\u6570\u5217\u8868\u4f1a\u81ea\u52a8\u5237\u65b0");
                this.toolBar.addSeparator();
                this.cb_format = new JButton("\u4ee3\u7801\u7f8e\u5316");
                this.toolBar.add(this.cb_format);
                this.toolBar.addSeparator();
                this.toolBar.add(new JLabel(jEdit.getProperty("view.quicksearch")));
                Box box = new Box(1);
                box.add(Box.createVerticalGlue());
                box.add(this.quicksearch);
                box.add(Box.createVerticalGlue());
                this.toolBar.add(box);
                this.toolBar.addSeparator();
                this.ignoreCase = GUIUtilities.loadToolButton("ignore-case");
                this.toolBar.add(this.ignoreCase);
                this.regexp = GUIUtilities.loadToolButton("regexp");
                this.toolBar.add(this.regexp);
                this.multifile = GUIUtilities.loadToolButton("multifile-search");
                this.toolBar.add(this.multifile);
            }
            if (this.toolBar.getParent() == null) {
                this.addToolBar(this.toolBar);
            }
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
    }

    private JEditTextArea createTextArea() {
        JEditTextArea textArea = new JEditTextArea();
        textArea.add(JEditTextArea.LEFT_OF_SCROLLBAR, new StatusBar(textArea));
        textArea.setRightClickPopup(GUIUtilities.loadPopupMenu(this, "view.context"));
        textArea.getGutter().setContextMenu(GUIUtilities.loadPopupMenu(this, "gutter.context"));
        textArea.setInputHandler(jEdit.getInputHandler().copy());
        textArea.addCaretListener(new CaretHandler());
        textArea.addFocusListener(new FocusHandler());
        if (this.buffer != null) {
            textArea.setDocument(this.buffer);
        }
        EditBus.send(new ViewUpdate(this, textArea, ViewUpdate.TEXTAREA_CREATED));
        return textArea;
    }

    private void initBufferTabs() {
        Container parent = this.bufferTabs != null ? this.bufferTabs.getParent() : (this.splitPane != null ? this.splitPane.getParent() : this.textArea.getParent());
        if (parent == null) {
            parent = this.getContentPane();
        }
        JComponent comp = this.splitPane == null ? this.textArea : this.splitPane;
        if ("on".equals(jEdit.getProperty("view.showBufferTabs"))) {
            if (this.bufferTabs == null) {
                this.bufferTabs = new BufferTabs(this);
                parent.remove(comp);
                parent.add(this.bufferTabs);
            }
            this.bufferTabs.setTabPlacement(Integer.parseInt(jEdit.getProperty("view.bufferTabsPos")));
        } else if (this.bufferTabs != null) {
            parent.remove(this.bufferTabs);
            this.bufferTabs = null;
            parent.add(comp);
        } else if (comp.getParent() == null) {
            parent.add(comp);
        }
        this.getRootPane().revalidate();
        this.getRootPane().repaint();
    }

    private void updateTitle() {
        Object[] args = new Object[]{this.showFullPath && !this.buffer.isNewFile() ? this.buffer.getPath() : this.buffer.getName(), new Integer(this.buffer.isReadOnly() ? 1 : 0), new Integer(this.buffer.isDirty() ? 1 : 0), new Integer(this.buffer.isNewFile() ? 1 : 0)};
        this.setTitle("JEdit");
        JEditTextArea[] textAreas = this.getTextAreas();
        int i = 0;
        while (i < textAreas.length) {
            JEditTextArea textArea = textAreas[i];
            textArea.setEditable(!this.buffer.isReadOnly());
            ++i;
        }
    }

    private void updateBuffersMenu() {
        if (jEdit.getBufferCount() == 0) {
            return;
        }
        int i = this.buffers.getMenuComponentCount() - 1;
        while (i >= 0) {
            if (this.buffers.getMenuComponent(i) instanceof JSeparator) break;
            this.buffers.remove(i);
            --i;
        }
        Buffer[] bufferArray = jEdit.getBuffers();
        ButtonGroup grp = new ButtonGroup();
        int i2 = 0;
        while (i2 < bufferArray.length) {
            Buffer b = bufferArray[i2];
            String name = b.getPath();
            Object[] args = new Object[]{name, new Integer(b.isReadOnly() ? 1 : 0), new Integer(b.isDirty() ? 1 : 0), new Integer(b.isNewFile() ? 1 : 0)};
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(jEdit.getProperty("view.buffer-label", args));
            menuItem.addActionListener(jEdit.getAction("select-buffer"));
            grp.add(menuItem);
            menuItem.setActionCommand(name);
            if (this.buffer == b) {
                menuItem.getModel().setSelected(true);
            }
            this.buffers.add(menuItem);
            ++i2;
        }
    }

    private void updateRecentMenu() {
        if (this.recent.getMenuComponentCount() != 0) {
            this.recent.removeAll();
        }
        EditAction action = jEdit.getAction("open-path");
        String[] recentArray = jEdit.getRecent();
        if (recentArray.length == 0) {
            this.recent.add(GUIUtilities.loadMenuItem(this, "no-recent"));
            return;
        }
        int i = 0;
        while (i < recentArray.length) {
            String path = recentArray[i];
            EnhancedMenuItem menuItem = new EnhancedMenuItem(path, null, action, path);
            this.recent.add(menuItem);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateMarkerMenus() {
        if (this.clearMarker.getMenuComponentCount() != 0) {
            this.clearMarker.removeAll();
        }
        if (this.gotoMarker.getMenuComponentCount() != 0) {
            this.gotoMarker.removeAll();
        }
        clearMarkerAction = jEdit.getAction("clear-marker");
        gotoMarkerAction = jEdit.getAction("goto-marker");
        enume = this.buffer.getMarkers();
        if (enume.hasMoreElements()) ** GOTO lbl21
        this.clearMarker.add(GUIUtilities.loadMenuItem(this, "no-markers"));
        this.gotoMarker.add(GUIUtilities.loadMenuItem(this, "no-markers"));
        return;
lbl-1000:
        // 1 sources

        {
            name = ((Marker)enume.nextElement()).getName();
            menuItem = new EnhancedMenuItem(name, null, clearMarkerAction, name);
            this.clearMarker.add(menuItem);
            menuItem = new EnhancedMenuItem(name, null, gotoMarkerAction, name);
            this.gotoMarker.add(menuItem);
lbl21:
            // 2 sources

            ** while (enume.hasMoreElements())
        }
lbl22:
        // 1 sources

    }

    private void updateMacrosMenu() {
        int i = this.macros.getMenuComponentCount() - 1;
        while (i >= 0) {
            if (this.macros.getMenuComponent(i) instanceof JSeparator) break;
            this.macros.remove(i);
            --i;
        }
        int count = this.macros.getMenuComponentCount();
        Vector macroVector = Macros.getMacros();
        this.createMacrosMenu(this.macros, macroVector, 0);
        if (count == this.macros.getMenuComponentCount()) {
            this.macros.add(GUIUtilities.loadMenuItem(this, "no-macros"));
        }
    }

    private void createMacrosMenu(JMenu menu, Vector vector, int start) {
        EditAction action = jEdit.getAction("play-macro");
        int i = start;
        while (i < vector.size()) {
            Object obj = vector.elementAt(i);
            if (obj instanceof Macros.Macro) {
                Macros.Macro macro = (Macros.Macro)obj;
                String label = macro.label;
                String path = macro.path;
                EnhancedMenuItem menuItem = new EnhancedMenuItem(label, jEdit.getProperty(String.valueOf(macro.name) + ".shortcut"), action, path);
                menu.add(menuItem);
            } else if (obj instanceof Vector) {
                Vector subvector = (Vector)obj;
                String name = (String)subvector.elementAt(0);
                JMenu submenu = new JMenu(name);
                this.createMacrosMenu(submenu, subvector, 1);
                if (submenu.getMenuComponentCount() == 0) {
                    submenu.add(GUIUtilities.loadMenuItem(this, "no-macros"));
                }
                menu.add(submenu);
            }
            ++i;
        }
    }

    private void updatePluginsMenu() {
        if (this.plugins.getMenuComponentCount() != 0) {
            this.plugins.removeAll();
        }
        Vector pluginMenus = new Vector();
        Vector pluginMenuItems = new Vector();
        EditPlugin[] pluginArray = jEdit.getPlugins();
        int i = 0;
        while (i < pluginArray.length) {
            try {
                pluginArray[i].createMenuItems(this, pluginMenus, pluginMenuItems);
            }
            catch (Throwable t) {
                Log.log(9, this, "Error creating menu items for plugin");
                Log.log(9, this, t);
            }
            ++i;
        }
        if (pluginMenus.isEmpty() && pluginMenuItems.isEmpty()) {
            this.plugins.add(GUIUtilities.loadMenuItem(this, "no-plugins"));
            return;
        }
        MenuItemCompare comp = new MenuItemCompare();
        MiscUtilities.quicksort(pluginMenus, (MiscUtilities.Compare)comp);
        MiscUtilities.quicksort(pluginMenuItems, (MiscUtilities.Compare)comp);
        int i2 = 0;
        while (i2 < pluginMenus.size()) {
            this.plugins.add((JMenu)pluginMenus.elementAt(i2));
            ++i2;
        }
        if (!pluginMenus.isEmpty() && !pluginMenuItems.isEmpty()) {
            this.plugins.addSeparator();
        }
        i2 = 0;
        while (i2 < pluginMenuItems.size()) {
            this.plugins.add((JMenuItem)pluginMenuItems.elementAt(i2));
            ++i2;
        }
    }

    private void updateHelpMenu() {
        EditAction action = jEdit.getAction("help");
        EditPlugin[] plugins = jEdit.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            EditPlugin plugin = plugins[i];
            String name = plugin.getClass().getName();
            String label = jEdit.getProperty("plugin." + name + ".name");
            String docs = jEdit.getProperty("plugin." + name + ".docs");
            if (docs != null) {
                URL docsURL = plugin.getClass().getResource(docs);
                if (label != null && docsURL != null) {
                    this.help.add(new EnhancedMenuItem(label, null, action, docsURL.toString()));
                }
            }
            ++i;
        }
    }

    private void handleBufferUpdate(BufferUpdate msg) {
        Buffer _buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.CREATED) {
            this.updateBuffersMenu();
            if (this.bufferTabs != null) {
                this.bufferTabs.addBufferTab(_buffer);
            }
        } else if (msg.getWhat() == BufferUpdate.CLOSED) {
            if (_buffer == this.buffer) {
                Buffer newBuffer = _buffer.getPrev();
                if (newBuffer != null && !newBuffer.isClosed()) {
                    this.setBuffer(newBuffer);
                } else if (jEdit.getBufferCount() != 0) {
                    this.setBuffer(jEdit.getFirstBuffer());
                }
            }
            this.updateRecentMenu();
            this.updateBuffersMenu();
            if (this.bufferTabs != null) {
                this.bufferTabs.removeBufferTab(_buffer);
            }
        } else if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (_buffer == this.buffer) {
                this.updateTitle();
            }
            this.updateBuffersMenu();
            if (this.bufferTabs != null) {
                this.bufferTabs.updateBufferTab(_buffer);
            }
        } else if (msg.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (_buffer == this.buffer) {
                this.updateMarkerMenus();
            }
        } else if (msg.getWhat() == BufferUpdate.MODE_CHANGED && _buffer == this.buffer) {
            JEditTextArea[] textAreas = this.getTextAreas();
            int i = 0;
            while (i < textAreas.length) {
                JEditTextArea textArea = textAreas[i];
                textArea.getPainter().repaint();
                ++i;
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == View.this.quicksearch) {
                String text = View.this.quicksearch.getText();
                if (text != null && text.length() != 0) {
                    View.this.quicksearch.addCurrentToHistory();
                    View.this.quicksearch.setText(null);
                    SearchAndReplace.setSearchString(text);
                    SearchAndReplace.find(View.this);
                    View.this.focusOnTextArea();
                } else {
                    new SearchDialog(View.this, null);
                }
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            JEditTextArea textArea = (JEditTextArea)evt.getSource();
            ((StatusBar)textArea.getStatus()).repaint();
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            View.this.textArea = (JEditTextArea)evt.getSource();
        }

        public void focusLost(FocusEvent evt) {
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getSource() == View.this.quicksearch && evt.getKeyCode() == 27) {
                View.this.focusOnTextArea();
            }
        }
    }

    private static class MenuItemCompare
    implements MiscUtilities.Compare {
        private MenuItemCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((JMenuItem)obj1).getText().compareTo(((JMenuItem)obj2).getText());
        }
    }

    class StatusBar
    extends JComponent {
        Stack status = new Stack();
        JEditTextArea textArea;

        StatusBar(JEditTextArea textArea) {
            this.textArea = textArea;
            this.setDoubleBuffered(true);
            this.setFont(UIManager.getFont("Label.font"));
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
        }

        void pushStatus(String str) {
            this.status.push(str);
            this.repaint();
        }

        void popStatus() {
            if (this.status.isEmpty()) {
                return;
            }
            this.status.pop();
            this.repaint();
        }

        public void paint(Graphics g) {
            FontMetrics fm = g.getFontMetrics();
            int dot2 = this.textArea.getCaretPosition();
            int currLine = this.textArea.getCaretLine();
            int start = this.textArea.getLineStartOffset(currLine);
            int numLines = this.textArea.getLineCount();
            String str = this.status.isEmpty() ? "col " + (dot2 - start + 1) + " line " + (currLine + 1) + "/" + numLines + " " + (currLine + 1) * 100 / numLines + "%" : (String)this.status.peek();
            g.drawString(str, 0, (this.getHeight() + fm.getAscent()) / 2);
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 0);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            jEdit.closeView(View.this);
        }
    }
}

