/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class Sessions {
    public static Buffer loadSession(String session, boolean ignoreNotFound) {
        String filename = Sessions.createSessionFileName(session);
        Buffer buffer = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                Buffer _buffer = Sessions.readSessionCommand(line);
                if (_buffer == null) continue;
                buffer = _buffer;
            }
            in.close();
        }
        catch (FileNotFoundException fnf) {
            Log.log(5, Sessions.class, fnf);
            if (ignoreNotFound) {
                return null;
            }
            Object[] args = new String[]{filename};
            GUIUtilities.error(null, "filenotfound", args);
        }
        catch (IOException io) {
            Log.log(9, Sessions.class, io);
            Object[] args = new String[]{io.getMessage()};
            GUIUtilities.error(null, "ioerror", args);
        }
        return buffer;
    }

    public static void saveSession(View view, String session) {
        view.saveCaretInfo();
        String lineSep = System.getProperty("line.separator");
        String filename = Sessions.createSessionFileName(session);
        Buffer buffer = jEdit.getFirstBuffer();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            while (buffer != null) {
                Sessions.writeSessionCommand(view, buffer, out);
                out.write(lineSep);
                buffer = buffer.getNext();
            }
            out.close();
        }
        catch (IOException io) {
            Log.log(9, Sessions.class, io);
            Object[] args = new String[]{io.getMessage()};
            GUIUtilities.error(null, "ioerror", args);
        }
    }

    public static String createSessionFileName(String session) {
        String filename = MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "sessions", session);
        if (!filename.toLowerCase().endsWith(".session")) {
            filename = String.valueOf(filename) + ".session";
        }
        return filename;
    }

    private static Buffer readSessionCommand(String line) {
        String path = null;
        Integer selStart = null;
        Integer selEnd = null;
        Integer firstLine = null;
        Integer horizontalOffset = null;
        boolean current = false;
        StringTokenizer st = new StringTokenizer(line, "\t");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("path:")) {
                path = token.substring(5);
                continue;
            }
            if (token.startsWith("selStart:")) {
                selStart = new Integer(token.substring(9));
                continue;
            }
            if (token.startsWith("selEnd:")) {
                selEnd = new Integer(token.substring(7));
                continue;
            }
            if (token.startsWith("firstLine:")) {
                firstLine = new Integer(token.substring(10));
                continue;
            }
            if (token.startsWith("horizontalOffset:")) {
                horizontalOffset = new Integer(token.substring(17));
                continue;
            }
            if (!token.equals("current")) continue;
            current = true;
        }
        if (path == null) {
            return null;
        }
        Buffer buffer = jEdit.openFile(null, null, path, false, false);
        if (selStart != null && selEnd != null && firstLine != null && horizontalOffset != null) {
            buffer.putProperty("Buffer__selStart", selStart);
            buffer.putProperty("Buffer__selEnd", selEnd);
            buffer.putProperty("Buffer__scrollVert", firstLine);
            buffer.putProperty("Buffer__scrollHoriz", horizontalOffset);
        }
        return current ? buffer : null;
    }

    private static void writeSessionCommand(View view, Buffer buffer, Writer out) throws IOException {
        out.write("path:");
        out.write(buffer.getPath());
        Integer start = (Integer)buffer.getProperty("Buffer__selStart");
        Integer end2 = (Integer)buffer.getProperty("Buffer__selEnd");
        Integer firstLine = (Integer)buffer.getProperty("Buffer__scrollVert");
        Integer horizontalOffset = (Integer)buffer.getProperty("Buffer__scrollHoriz");
        if (start != null && end2 != null && firstLine != null && horizontalOffset != null) {
            out.write("\tselStart:");
            out.write(start.toString());
            out.write("\tselEnd:");
            out.write(end2.toString());
            out.write("\tfirstLine:");
            out.write(firstLine.toString());
            out.write("\thorizontalOffset:");
            out.write(horizontalOffset.toString());
        }
        if (view.getBuffer() == buffer) {
            out.write("\tcurrent");
        }
    }
}

