/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class MiscUtilities {
    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        int i = clsName.length - 6;
        while (i >= 0) {
            if (clsName[i] == '/') {
                clsName[i] = 46;
            }
            --i;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    public static String constructPath(String parent, String path) {
        if (path.startsWith(File.separator)) {
            return MiscUtilities.canonPath(path);
        }
        if (path.length() >= 3 && path.charAt(1) == ':') {
            return MiscUtilities.canonPath(path);
        }
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (parent.endsWith(File.separator)) {
            return MiscUtilities.canonPath(String.valueOf(parent) + path);
        }
        return MiscUtilities.canonPath(String.valueOf(parent) + File.separator + path);
    }

    public static String constructPath(String parent, String path1, String path2) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(parent, path1), path2);
    }

    public static int getLeadingWhiteSpace(String str) {
        int whitespace = 0;
        block3: while (whitespace < str.length()) {
            switch (str.charAt(whitespace)) {
                case '\t': 
                case ' ': {
                    ++whitespace;
                    break;
                }
                default: {
                    break block3;
                }
            }
        }
        return whitespace;
    }

    public static int getLeadingWhiteSpaceWidth(String str, int tabSize) {
        int whitespace = 0;
        int i = 0;
        block4: while (i < str.length()) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++whitespace;
                    break;
                }
                case '\t': {
                    whitespace += tabSize - whitespace % tabSize;
                    break;
                }
                default: {
                    break block4;
                }
            }
            ++i;
        }
        return whitespace;
    }

    public static String createWhiteSpace(int len, int tabSize) {
        StringBuffer buf = new StringBuffer();
        if (tabSize == 0) {
            while (len-- > 0) {
                buf.append(' ');
            }
        } else {
            int count = len / tabSize;
            while (count-- > 0) {
                buf.append('\t');
            }
            count = len % tabSize;
            while (count-- > 0) {
                buf.append(' ');
            }
        }
        return buf.toString();
    }

    public static boolean isURL(String str) {
        int colonIndex = str.indexOf(58);
        int spaceIndex = str.indexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = str.length();
        }
        return colonIndex > 1 && colonIndex < spaceIndex;
    }

    public static String globToRE(String glob) {
        StringBuffer buf = new StringBuffer();
        boolean backslash = false;
        boolean insideGroup = false;
        int i = 0;
        while (i < glob.length()) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
            } else {
                switch (c) {
                    case '\\': {
                        backslash = true;
                        break;
                    }
                    case '?': {
                        buf.append('.');
                        break;
                    }
                    case '.': {
                        buf.append("\\.");
                        break;
                    }
                    case '*': {
                        buf.append(".*");
                        break;
                    }
                    case '{': {
                        buf.append('(');
                        insideGroup = true;
                        break;
                    }
                    case ',': {
                        if (insideGroup) {
                            buf.append('|');
                            break;
                        }
                        buf.append(',');
                        break;
                    }
                    case '}': {
                        buf.append(')');
                        insideGroup = false;
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String escapesToChars(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            block0 : switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        break;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            break block0;
                        }
                        case 't': {
                            buf.append('\t');
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String charsToEscapes(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '[': {
                    buf.append("\\[");
                    break;
                }
                case ']': {
                    buf.append("\\]");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static void quicksort(Object[] obj, Compare compare) {
        if (obj.length == 0) {
            return;
        }
        MiscUtilities.quicksort(obj, 0, obj.length - 1, compare);
    }

    public static void quicksort(Vector vector, Compare compare) {
        if (vector.size() == 0) {
            return;
        }
        MiscUtilities.quicksort(vector, 0, vector.size() - 1, compare);
    }

    public static int compareVersions(String version1, String version2) {
        VersionCompare comparator = new VersionCompare();
        return comparator.compare(version1, version2);
    }

    public static String buildToVersion(String build) {
        if (build.length() != 11) {
            return "<unknown version: " + build + ">";
        }
        int major = Integer.parseInt(build.substring(0, 2));
        int minor = Integer.parseInt(build.substring(3, 5));
        int beta = Integer.parseInt(build.substring(6, 8));
        int bugfix = Integer.parseInt(build.substring(9, 11));
        return major + "." + minor + (beta == 99 && bugfix == 0 ? "final" : (beta == 99 ? "." + bugfix : "pre" + beta));
    }

    private MiscUtilities() {
    }

    private static String canonPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException io) {
            return path;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void quicksort(Object[] obj, int _start, int _end, Compare compare) {
        start = _start;
        end = _end;
        mid = obj[(_start + _end) / 2];
        if (_start <= _end) ** GOTO lbl18
        return;
        {
            ++start;
            do {
                if (start < _end && compare.compare(obj[start], mid) < 0) continue block0;
                while (end > _start && compare.compare(obj[end], mid) > 0) {
                    --end;
                }
                if (start > end) continue;
                o = obj[start];
                obj[start] = obj[end];
                obj[end] = o;
                ++start;
                --end;
lbl18:
                // 3 sources

            } while (start <= end);
        }
        if (_start < end) {
            MiscUtilities.quicksort(obj, _start, end, compare);
        }
        if (start < _end) {
            MiscUtilities.quicksort(obj, start, _end, compare);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void quicksort(Vector obj, int _start, int _end, Compare compare) {
        start = _start;
        end = _end;
        mid = obj.elementAt((_start + _end) / 2);
        if (_start <= _end) ** GOTO lbl18
        return;
        {
            ++start;
            do {
                if (start < _end && compare.compare(obj.elementAt(start), mid) < 0) continue block0;
                while (end > _start && compare.compare(obj.elementAt(end), mid) > 0) {
                    --end;
                }
                if (start > end) continue;
                o = obj.elementAt(start);
                obj.setElementAt(obj.elementAt(end), start);
                obj.setElementAt(o, end);
                ++start;
                --end;
lbl18:
                // 3 sources

            } while (start <= end);
        }
        if (_start < end) {
            MiscUtilities.quicksort(obj, _start, end, compare);
        }
        if (start < _end) {
            MiscUtilities.quicksort(obj, start, _end, compare);
        }
    }

    public static interface Compare {
        public int compare(Object var1, Object var2);
    }

    public static class StringCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            return obj1.toString().compareTo(obj2.toString());
        }
    }

    public static class StringICaseCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            return obj1.toString().toLowerCase().compareTo(obj2.toString().toLowerCase());
        }
    }

    public static class VersionCompare
    implements Compare {
        public int compare(Object obj1, Object obj2) {
            String v1 = obj1.toString();
            String v2 = obj2.toString();
            StringTokenizer vt1 = new StringTokenizer(v1, ".");
            StringTokenizer vt2 = new StringTokenizer(v2, ".");
            int comp = 0;
            while (vt1.hasMoreTokens() && vt2.hasMoreTokens()) {
                String vt1tok = vt1.nextToken();
                String vt2tok = vt2.nextToken();
                try {
                    int i1 = Integer.parseInt(vt1tok);
                    int i2 = Integer.parseInt(vt2tok);
                    comp = i1 < i2 ? -1 : (i1 > i2 ? 1 : 0);
                }
                catch (NumberFormatException e) {
                    comp = vt1tok.compareTo(vt2tok);
                }
                if (comp == 0) continue;
                return comp;
            }
            return vt1.hasMoreTokens() ? 1 : (vt2.hasMoreTokens() ? -1 : 0);
        }
    }
}

