/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class JARClassLoader
extends ClassLoader {
    private static Vector classLoaders = new Vector();
    private int index;
    private Vector pluginClasses = new Vector();
    private String fileName;
    private ZipFile zipFile;

    public JARClassLoader(String path) throws IOException {
        this.fileName = new File(path).getName();
        this.zipFile = new ZipFile(path);
        Enumeration<? extends ZipEntry> entires = this.zipFile.entries();
        while (entires.hasMoreElements()) {
            ZipEntry entry = entires.nextElement();
            String name = entry.getName();
            if (name.toLowerCase().endsWith(".props")) {
                jEdit.loadProps(this.zipFile.getInputStream(entry));
                continue;
            }
            if (!name.toLowerCase().endsWith(".class") || !name.endsWith("Plugin.class")) continue;
            this.pluginClasses.addElement(name);
        }
        this.index = classLoaders.size();
        classLoaders.addElement(this);
    }

    public Class loadClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        return this.loadClassFromZip(clazz, resolveIt, true);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            ZipEntry entry = this.zipFile.getEntry(name);
            if (entry == null) {
                return JARClassLoader.getSystemResourceAsStream(name);
            }
            return this.zipFile.getInputStream(entry);
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return null;
        }
    }

    public URL getResource(String name) {
        try {
            return new URL(this.getResourceAsPath(name));
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
            return null;
        }
    }

    public String getResourceAsPath(String name) {
        return "jeditresource:" + this.index + "/" + name;
    }

    public String getPath() {
        return this.zipFile.getName();
    }

    public static void initPlugins() {
        int i = 0;
        while (i < classLoaders.size()) {
            JARClassLoader classLoader = (JARClassLoader)classLoaders.elementAt(i);
            classLoader.loadAllPlugins();
            ++i;
        }
    }

    public static JARClassLoader getClassLoader(int index) {
        return (JARClassLoader)classLoaders.elementAt(index);
    }

    public static int getClassLoaderCount() {
        return classLoaders.size();
    }

    private void loadAllPlugins() {
        int i = 0;
        while (i < this.pluginClasses.size()) {
            String name = (String)this.pluginClasses.elementAt(i);
            try {
                this.loadPluginClass(name);
            }
            catch (Throwable t) {
                Log.log(9, this, "Error while starting plugin " + name);
                Log.log(9, this, t);
                jEdit.addBrokenPlugin(this.fileName, name);
            }
            ++i;
        }
    }

    private void loadPluginClass(String name) throws Exception {
        name = MiscUtilities.fileToClass(name);
        EditPlugin[] plugins = jEdit.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getClass().getName().equals(name)) {
                Log.log(7, this, "A plugin named " + name + " is already loaded");
                return;
            }
            ++i;
        }
        if (!this.checkDependencies(name)) {
            jEdit.addBrokenPlugin(this.fileName, name);
            return;
        }
        Class clazz = this.loadClass(name, true);
        int modifiers = clazz.getModifiers();
        if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers) && EditPlugin.class.isAssignableFrom(clazz)) {
            String version = jEdit.getProperty("plugin." + name + ".version");
            if (version == null) {
                Log.log(7, this, "Plugin " + name + " doesn't" + " have a 'version' property.");
                version = "";
            } else {
                version = " (version " + version + ")";
            }
            Log.log(5, this, "Starting plugin " + name + version);
            jEdit.addPlugin((EditPlugin)clazz.newInstance());
        }
    }

    private boolean checkDependencies(String name) {
        String dep;
        int i = 0;
        while ((dep = jEdit.getProperty("plugin." + name + ".depend." + i++)) != null) {
            int index = dep.indexOf(32);
            if (index == -1) {
                Log.log(9, this, String.valueOf(name) + " has an invalid" + " dependency: " + dep);
                return false;
            }
            String what = dep.substring(0, index);
            String arg = dep.substring(index + 1);
            if (what.equals("jdk")) {
                if (System.getProperty("java.version").compareTo(arg) >= 0) continue;
                Log.log(9, this, String.valueOf(name) + " requires" + " Java " + arg);
                return false;
            }
            if (what.equals("jedit")) {
                if (jEdit.getBuild().compareTo(arg) >= 0) continue;
                Log.log(9, this, String.valueOf(name) + " requires" + " jEdit " + MiscUtilities.buildToVersion(arg));
                return false;
            }
            if (what.equals("plugin")) {
                int index2 = arg.indexOf(32);
                if (index2 == -1) {
                    Log.log(9, this, String.valueOf(name) + " has an invalid dependency: " + dep + " (version is missing)");
                    return false;
                }
                String plugin = arg.substring(0, index2);
                String needVersion = arg.substring(index2 + 1);
                String currVersion = jEdit.getProperty("plugin." + plugin + ".version");
                if (currVersion == null) {
                    Log.log(9, this, "No version info found in plugin " + plugin + ". Plugin " + name + " needs" + " version " + needVersion);
                    return false;
                }
                if (MiscUtilities.compareVersions(currVersion, needVersion) >= 0) continue;
                Log.log(9, this, String.valueOf(name) + " requires" + " plugin " + plugin + " version " + needVersion);
                return false;
            }
            if (what.equals("class")) {
                try {
                    this.loadClass(arg, false);
                    continue;
                }
                catch (Exception e) {
                    Log.log(9, this, String.valueOf(name) + " requires class " + arg);
                    return false;
                }
            }
            if (what.equals("jext")) {
                Log.log(9, this, String.valueOf(name) + " is not a jEdit" + " plugin");
                continue;
            }
            Log.log(9, this, String.valueOf(name) + " has unknown" + " dependency: " + dep);
            return false;
        }
        return true;
    }

    private Class findOtherClass(String clazz, boolean resolveIt) throws ClassNotFoundException {
        int i = 0;
        while (i < classLoaders.size()) {
            JARClassLoader loader = (JARClassLoader)classLoaders.elementAt(i);
            Class cls = loader.loadClassFromZip(clazz, resolveIt, false);
            if (cls != null) {
                return cls;
            }
            ++i;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader != null) {
            return loader.loadClass(clazz);
        }
        return this.findSystemClass(clazz);
    }

    private Class loadClassFromZip(String clazz, boolean resolveIt, boolean doDepencies) throws ClassNotFoundException {
        ZipEntry entry;
        Class<?> cls;
        block8: {
            cls = this.findLoadedClass(clazz);
            if (cls != null) {
                if (resolveIt) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            String name = MiscUtilities.classToFile(clazz);
            entry = this.zipFile.getEntry(name);
            if (entry != null) break block8;
            if (doDepencies) {
                return this.findOtherClass(clazz, resolveIt);
            }
            return null;
        }
        try {
            InputStream in = this.zipFile.getInputStream(entry);
            int len = (int)entry.getSize();
            byte[] data = new byte[len];
            int success = 0;
            int offset = 0;
            while (success < len) {
                if ((success = in.read(data, offset += success, len -= success)) != -1) continue;
                Log.log(9, this, "Failed to load class " + clazz + " from " + this.zipFile.getName());
                throw new ClassNotFoundException(clazz);
            }
            cls = this.defineClass(clazz, data, 0, data.length);
            if (resolveIt) {
                this.resolveClass(cls);
            }
            return cls;
        }
        catch (IOException io) {
            Log.log(9, this, io);
            throw new ClassNotFoundException(clazz);
        }
    }
}

