/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.REException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.REFileFilter;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.MenuBarModel;
import org.gjt.sp.jedit.gui.MenuItemModel;
import org.gjt.sp.jedit.gui.MenuModel;
import org.gjt.sp.jedit.gui.ToolBarModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;

public class GUIUtilities {
    static JFileChooser chooser;
    private static Hashtable menus;

    static {
        menus = new Hashtable();
    }

    public static MenuBarModel loadMenuBarModel(String name) {
        MenuBarModel mbar = (MenuBarModel)menus.get(name);
        if (mbar == null) {
            mbar = new MenuBarModel(name);
            menus.put(name, mbar);
        }
        return mbar;
    }

    public static JMenuBar loadMenuBar(View view, String name) {
        return GUIUtilities.loadMenuBarModel(name).create(view);
    }

    public static MenuModel loadMenuModel(String name) {
        MenuModel menu = (MenuModel)menus.get(name);
        if (menu == null) {
            menu = new MenuModel(name);
            menus.put(name, menu);
        }
        return menu;
    }

    public static JMenu loadMenu(View view, String name) {
        return (JMenu)GUIUtilities.loadMenuModel(name).create(view);
    }

    public static JPopupMenu loadPopupMenu(View view, String name) {
        return GUIUtilities.loadMenuModel(name).createPopup(view);
    }

    public static MenuItemModel loadMenuItemModel(String name) {
        MenuItemModel menuitem = (MenuItemModel)menus.get(name);
        if (menuitem == null) {
            menuitem = new MenuItemModel(name);
            menus.put(name, menuitem);
        }
        return menuitem;
    }

    public static JMenuItem loadMenuItem(View view, String name) {
        return GUIUtilities.loadMenuItemModel(name).create(view);
    }

    public static ToolBarModel loadToolBarModel(String name) {
        ToolBarModel toolbar = (ToolBarModel)menus.get(name);
        if (toolbar == null) {
            toolbar = new ToolBarModel(name);
            menus.put(name, toolbar);
        }
        return toolbar;
    }

    public static JToolBar loadToolBar(String name) {
        return GUIUtilities.loadToolBarModel(name).create();
    }

    public static EnhancedButton loadToolButton(String name) {
        return GUIUtilities.loadMenuItemModel(name).createButton();
    }

    public static String prettifyMenuLabel(String label) {
        int index = label.indexOf(36);
        if (index != -1) {
            label = label.substring(0, index).concat(label.substring(index + 1));
        }
        if (label.endsWith("...")) {
            label = label.substring(0, label.length() - 3);
        }
        return label;
    }

    public static void message(Frame frame, String name, Object[] args) {
        JOptionPane.showMessageDialog(frame, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 1);
    }

    public static void error(Frame frame, String name, Object[] args) {
        JOptionPane.showMessageDialog(frame, jEdit.getProperty(name.concat(".message"), args), jEdit.getProperty(name.concat(".title"), args), 0);
    }

    public static String input(Frame frame, String name, Object def) {
        String retVal = (String)JOptionPane.showInputDialog(frame, jEdit.getProperty(name.concat(".message")), jEdit.getProperty(name.concat(".title")), 3, null, null, def);
        return retVal;
    }

    public static String inputProperty(Frame frame, String name, String def) {
        String retVal = (String)JOptionPane.showInputDialog(frame, jEdit.getProperty(name.concat(".message")), jEdit.getProperty(name.concat(".title")), 3, null, null, jEdit.getProperty(def));
        if (retVal != null) {
            jEdit.setProperty(def, retVal);
        }
        return retVal;
    }

    public static String showFileDialog(View view, String file, int type) {
        File _file = new File(file);
        JFileChooser chooser = GUIUtilities.getFileChooser(view);
        chooser.setCurrentDirectory(_file);
        chooser.rescanCurrentDirectory();
        if (_file.isDirectory()) {
            chooser.setSelectedFile(null);
        } else {
            chooser.setSelectedFile(_file);
        }
        chooser.setDialogType(type);
        chooser.setFileSelectionMode(0);
        int retVal = chooser.showDialog(view, null);
        if (retVal == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static Color parseColor(String name) {
        if (name == null) {
            return Color.black;
        }
        if (name.startsWith("#")) {
            try {
                return Color.decode(name);
            }
            catch (NumberFormatException nf) {
                return Color.black;
            }
        }
        if ("red".equals(name)) {
            return Color.red;
        }
        if ("green".equals(name)) {
            return Color.green;
        }
        if ("blue".equals(name)) {
            return Color.blue;
        }
        if ("yellow".equals(name)) {
            return Color.yellow;
        }
        if ("orange".equals(name)) {
            return Color.orange;
        }
        if ("white".equals(name)) {
            return Color.white;
        }
        if ("lightGray".equals(name)) {
            return Color.lightGray;
        }
        if ("gray".equals(name)) {
            return Color.gray;
        }
        if ("darkGray".equals(name)) {
            return Color.darkGray;
        }
        if ("black".equals(name)) {
            return Color.black;
        }
        if ("cyan".equals(name)) {
            return Color.cyan;
        }
        if ("magenta".equals(name)) {
            return Color.magenta;
        }
        if ("pink".equals(name)) {
            return Color.pink;
        }
        return Color.black;
    }

    public static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static SyntaxStyle parseStyle(String str) throws IllegalArgumentException {
        Color color = Color.black;
        boolean italic = false;
        boolean bold = false;
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("color:")) {
                color = GUIUtilities.parseColor(s.substring(6));
                continue;
            }
            if (s.startsWith("style:")) {
                int i = 6;
                while (i < s.length()) {
                    if (s.charAt(i) == 'i') {
                        italic = true;
                    } else if (s.charAt(i) == 'b') {
                        bold = true;
                    } else {
                        throw new IllegalArgumentException("Invalid style: " + s);
                    }
                    ++i;
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + s);
        }
        return new SyntaxStyle(color, italic, bold);
    }

    public static String getStyleString(SyntaxStyle style) {
        StringBuffer buf = new StringBuffer();
        buf.append("color:" + GUIUtilities.getColorHexString(style.getColor()));
        if (!style.isPlain()) {
            buf.append(" style:" + (style.isItalic() ? "i" : "") + (style.isBold() ? "b" : ""));
        }
        return buf.toString();
    }

    public static void loadGeometry(Window win, String name) {
        int y;
        int x;
        int height;
        int width;
        try {
            width = Integer.parseInt(jEdit.getProperty(String.valueOf(name) + ".width"));
            height = Integer.parseInt(jEdit.getProperty(String.valueOf(name) + ".height"));
        }
        catch (NumberFormatException nf) {
            Dimension size = win.getSize();
            width = size.width;
            height = size.height;
        }
        try {
            x = Integer.parseInt(jEdit.getProperty(String.valueOf(name) + ".x"));
            y = Integer.parseInt(jEdit.getProperty(String.valueOf(name) + ".y"));
        }
        catch (NumberFormatException nf) {
            Dimension screen = win.getToolkit().getScreenSize();
            x = (screen.width - width) / 2;
            y = (screen.height - height) / 2;
        }
        win.setLocation(x, y);
        win.setSize(width, height);
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            win.addWindowListener(new LinuxWorkaround(win, x, y, width, height));
        }
    }

    public static void saveGeometry(Window win, String name) {
        Point location = win.getLocation();
        Dimension size = win.getSize();
        jEdit.setProperty(String.valueOf(name) + ".x", String.valueOf(location.x));
        jEdit.setProperty(String.valueOf(name) + ".y", String.valueOf(location.y));
        jEdit.setProperty(String.valueOf(name) + ".width", String.valueOf(size.width));
        jEdit.setProperty(String.valueOf(name) + ".height", String.valueOf(size.height));
    }

    public static Image getEditorIcon() {
        return new ImageIcon(GUIUtilities.class.getResource("jedit_icon1.gif")).getImage();
    }

    public static Image getPluginIcon() {
        return new ImageIcon(GUIUtilities.class.getResource("jedit_icon2.gif")).getImage();
    }

    private GUIUtilities() {
    }

    private static JFileChooser getFileChooser(View view) {
        if (chooser == null) {
            String name;
            if (view != null) {
                view.showWaitCursor();
            }
            chooser = new JFileChooser();
            Mode[] modes = jEdit.getModes();
            int i = 0;
            while (i < modes.length) {
                Mode mode = modes[i];
                String label = (String)mode.getProperty("label");
                String glob = (String)mode.getProperty("filenameGlob");
                if (label != null && glob != null) {
                    try {
                        chooser.addChoosableFileFilter(new REFileFilter(label, MiscUtilities.globToRE(glob)));
                    }
                    catch (REException re) {
                        Log.log(9, GUIUtilities.class, "Invalid file filter: " + glob);
                        Log.log(9, GUIUtilities.class, re);
                    }
                }
                ++i;
            }
            i = 0;
            while ((name = jEdit.getProperty("filefilter." + i + ".name")) != null && name.length() != 0) {
                try {
                    chooser.addChoosableFileFilter(new REFileFilter(name, MiscUtilities.globToRE(jEdit.getProperty("filefilter." + i + ".re"))));
                }
                catch (REException re) {
                    Log.log(9, GUIUtilities.class, "Invalid file filter: " + i);
                    Log.log(9, GUIUtilities.class, re);
                }
                ++i;
            }
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
            if (view != null) {
                view.hideWaitCursor();
            }
        }
        return chooser;
    }

    static class LinuxWorkaround
    extends WindowAdapter {
        Window win;
        int x;
        int y;
        int width;
        int height;

        LinuxWorkaround(Window win, int x, int y, int width, int height) {
            this.win = win;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void windowOpened(WindowEvent evt) {
            this.win.setLocation(this.x, this.y);
            this.win.setSize(this.width, this.height);
            this.win.removeWindowListener(this);
        }
    }
}

