/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Sessions;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class EditServer
extends Thread {
    private String portFile;
    private ServerSocket socket;
    private int authKey;

    EditServer(String portFile) {
        super("jEdit server [" + portFile + "]");
        this.portFile = portFile;
        try {
            this.socket = new ServerSocket(0);
            this.authKey = Math.abs(new Random().nextInt());
            FileWriter out = new FileWriter(portFile);
            out.write(String.valueOf(this.socket.getLocalPort()));
            out.write("\n");
            out.write(String.valueOf(this.authKey));
            out.write("\n");
            out.close();
            Log.log(1, this, "jEdit server started on port " + this.socket.getLocalPort());
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return;
        }
        this.start();
    }

    public void run() {
        try {
            while (true) {
                BufferedReader in;
                Socket client;
                block6: {
                    client = this.socket.accept();
                    Log.log(3, this, client + ": connected");
                    in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                    try {
                        int key = Integer.parseInt(in.readLine());
                        if (key != this.authKey) {
                            Log.log(9, this, client + ": wrong" + " authorization key");
                            in.close();
                            client.close();
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        Log.log(9, this, client + ": invalid" + " authorization key");
                        in.close();
                        client.close();
                    }
                    continue;
                }
                Log.log(1, this, client + ": authenticated" + " successfully");
                this.handleClient(client, in);
                client.close();
            }
        }
        catch (IOException io) {
            Log.log(9, this, io);
            return;
        }
    }

    void stopServer() {
        this.stop();
        new File(this.portFile).delete();
    }

    private void TSnewView(final Buffer buffer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                View view = jEdit.newView(jEdit.getFirstView(), buffer);
                view.requestFocus();
                view.toFront();
            }
        });
    }

    private Buffer TSnewFile() {
        final Buffer[] retVal = new Buffer[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    retVal[0] = jEdit.newFile(null);
                }
            });
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
        return retVal[0];
    }

    private Buffer TSopenFile(final String parent, final String path, final boolean readOnly) {
        final Buffer[] retVal = new Buffer[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    retVal[0] = jEdit.openFile(null, parent, path, readOnly, false);
                }
            });
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
        return retVal[0];
    }

    private Buffer TSloadSession(final String session) {
        final Buffer[] retVal = new Buffer[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    retVal[0] = Sessions.loadSession(session, false);
                }
            });
        }
        catch (Exception e) {
            Log.log(9, this, e);
        }
        return retVal[0];
    }

    private void TSsetBuffer(final View view, final Buffer buffer) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                view.setBuffer(buffer);
            }
        });
    }

    private void handleClient(Socket client, BufferedReader in) throws IOException {
        String command;
        boolean readOnly = false;
        boolean reuseView = false;
        String parent = null;
        String session = null;
        boolean endOpts = false;
        View view = null;
        Buffer buffer = null;
        while ((command = in.readLine()) != null) {
            if (endOpts) {
                buffer = this.TSopenFile(parent, command, readOnly);
                continue;
            }
            if (command.equals("--")) {
                endOpts = true;
                continue;
            }
            if (command.equals("readonly")) {
                readOnly = true;
                continue;
            }
            if (command.equals("reuseview")) {
                reuseView = true;
                continue;
            }
            if (command.startsWith("parent=")) {
                parent = command.substring(7);
                continue;
            }
            if (command.startsWith("session=")) {
                session = command.substring(8);
                continue;
            }
            Log.log(9, this, client + ": unknown server" + " command: " + command);
        }
        if (buffer == null && session != null) {
            buffer = this.TSloadSession(session);
        }
        if (buffer == null) {
            buffer = this.TSnewFile();
        }
        if (reuseView) {
            view = jEdit.getFirstView();
            this.TSsetBuffer(view, buffer);
            view.requestFocus();
            view.toFront();
        } else {
            this.TSnewView(buffer);
        }
    }
}

