/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextUtilities;
import org.gjt.sp.util.Log;

public class Abbrevs {
    private static boolean expandOnInput;
    private static Hashtable globalAbbrevs;
    private static Hashtable modes;

    public static boolean getExpandOnInput() {
        return expandOnInput;
    }

    public static void setExpandOnInput(boolean expandOnInput) {
        Abbrevs.expandOnInput = expandOnInput;
    }

    public static void expandAbbrev(View view, boolean add) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int line = textArea.getCaretLine();
        int lineStart = textArea.getLineStartOffset(line);
        int caret = textArea.getCaretPosition();
        String lineText = textArea.getLineText(line);
        if (lineText.length() == 0) {
            if (add) {
                view.getToolkit().beep();
            }
            return;
        }
        int pos = caret - lineStart;
        if (pos == 0) {
            if (add) {
                view.getToolkit().beep();
            }
            return;
        }
        int wordStart = TextUtilities.findWordStart(lineText, pos - 1, (String)buffer.getProperty("noWordSep"));
        String abbrev = lineText.substring(wordStart, pos);
        String expand = Abbrevs.expandAbbrev(buffer.getMode().getName(), abbrev);
        if (expand == null) {
            if (add) {
                Abbrevs.addAbbrev(view, abbrev);
            }
            return;
        }
        buffer.beginCompoundEdit();
        try {
            buffer.remove(lineStart + wordStart, pos - wordStart);
            buffer.insertString(lineStart + wordStart, expand, null);
        }
        catch (BadLocationException bl) {
            Log.log(9, Abbrevs.class, bl);
        }
        buffer.endCompoundEdit();
    }

    public static String expandAbbrev(String mode, String abbrev) {
        String expand;
        Hashtable modeAbbrevs = (Hashtable)modes.get(mode);
        if (modeAbbrevs != null && (expand = (String)modeAbbrevs.get(abbrev)) != null) {
            return expand;
        }
        return (String)globalAbbrevs.get(abbrev);
    }

    public static Hashtable getGlobalAbbrevs() {
        return globalAbbrevs;
    }

    public static void setGlobalAbbrevs(Hashtable globalAbbrevs) {
        Abbrevs.globalAbbrevs = globalAbbrevs;
    }

    public static Hashtable getModeAbbrevs() {
        return modes;
    }

    public static void setModeAbbrevs(Hashtable modes) {
        Abbrevs.modes = modes;
    }

    static void load() {
        expandOnInput = "yes".equals(jEdit.getProperty("view.expandOnInput"));
        globalAbbrevs = new Hashtable();
        modes = new Hashtable();
        boolean loaded = false;
        String settings = jEdit.getSettingsDirectory();
        if (settings != null) {
            String path = MiscUtilities.constructPath(settings, "abbrevs");
            try {
                Abbrevs.loadAbbrevs(new FileReader(path));
                loaded = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                Log.log(9, Abbrevs.class, "Error while loading " + path);
                Log.log(9, Abbrevs.class, e);
            }
        }
        if (!loaded) {
            try {
                Abbrevs.loadAbbrevs(new InputStreamReader(Abbrevs.class.getResourceAsStream("default.abbrevs")));
            }
            catch (Exception e) {
                Log.log(9, Abbrevs.class, "Error while loading default.abbrevs");
                Log.log(9, Abbrevs.class, e);
            }
        }
    }

    static void save() {
        jEdit.setProperty("view.expandOnInput", expandOnInput ? "yes" : "no");
        String settings = jEdit.getSettingsDirectory();
        if (settings != null) {
            String path = MiscUtilities.constructPath(settings, "abbrevs");
            try {
                Abbrevs.saveAbbrevs(new FileWriter(path));
            }
            catch (Exception e) {
                Log.log(9, Abbrevs.class, "Error while saving " + path);
                Log.log(9, Abbrevs.class, e);
            }
        }
    }

    private Abbrevs() {
    }

    private static void loadAbbrevs(Reader _in) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(_in);
        Hashtable currentAbbrevs = null;
        while ((line = in.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.startsWith("[")) {
                if (line.equals("[global]")) {
                    currentAbbrevs = globalAbbrevs;
                    continue;
                }
                String mode = line.substring(1, line.length() - 1);
                currentAbbrevs = (Hashtable)modes.get(mode);
                if (currentAbbrevs != null) continue;
                currentAbbrevs = new Hashtable();
                modes.put(mode, currentAbbrevs);
                continue;
            }
            int index = line.indexOf(124);
            currentAbbrevs.put(line.substring(0, index), MiscUtilities.escapesToChars(line.substring(index + 1)));
        }
        in.close();
    }

    private static void saveAbbrevs(Writer _out) throws Exception {
        BufferedWriter out = new BufferedWriter(_out);
        String lineSep = System.getProperty("line.separator");
        out.write("[global]");
        out.write(lineSep);
        Abbrevs.saveAbbrevs(out, globalAbbrevs);
        Enumeration keys = modes.keys();
        Enumeration values = modes.elements();
        while (keys.hasMoreElements()) {
            out.write(91);
            out.write((String)keys.nextElement());
            out.write(93);
            out.write(lineSep);
            Abbrevs.saveAbbrevs(out, (Hashtable)values.nextElement());
        }
        out.close();
    }

    private static void saveAbbrevs(Writer out, Hashtable abbrevs) throws Exception {
        String lineSep = System.getProperty("line.separator");
        Enumeration keys = abbrevs.keys();
        Enumeration values = abbrevs.elements();
        while (keys.hasMoreElements()) {
            String abbrev = (String)keys.nextElement();
            if (abbrev.startsWith("[")) {
                out.write(92);
            }
            out.write(abbrev);
            out.write(124);
            out.write(MiscUtilities.charsToEscapes((String)values.nextElement()));
            out.write(lineSep);
        }
    }

    private static void addAbbrev(View view, String abbrev) {
        Object[] args = new String[]{abbrev};
        JTextField textField = new JTextField();
        Object[] message = new Object[]{jEdit.getProperty("add-abbrev.message", args), textField};
        Object[] options = new Object[]{jEdit.getProperty("add-abbrev.global"), jEdit.getProperty("add-abbrev.mode"), jEdit.getProperty("common.cancel")};
        int retVal = JOptionPane.showOptionDialog(view, message, jEdit.getProperty("add-abbrev.title"), 0, 3, null, options, options[0]);
        String expand = textField.getText();
        if (expand == null || retVal != 0 && retVal != 1) {
            return;
        }
        if (retVal == 1) {
            String mode = view.getBuffer().getMode().getName();
            Hashtable<String, String> modeAbbrevs = (Hashtable<String, String>)modes.get(mode);
            if (modeAbbrevs == null) {
                modeAbbrevs = new Hashtable<String, String>();
                modes.put(mode, modeAbbrevs);
            }
            modeAbbrevs.put(abbrev, expand);
        } else {
            globalAbbrevs.put(abbrev, expand);
        }
        Abbrevs.expandAbbrev(view, false);
    }
}

