/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JComponent;
import jun.dock.core.DockContainer;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockContainer_;
import jun.dock.impl.UTIL;

class SplitBar
extends JComponent
implements MouseListener,
MouseMotionListener,
Serializable {
    static final int SplitBarWidth = 2;
    public int m_SplitDirection;
    public DockContainer_ m_ParentContainer = null;
    public DockContainer_ m_ContainerOne = null;
    public DockContainer_ m_ContainerTwo = null;
    private boolean m_CursorHadSetted = false;
    Color m_bkcolor;
    Color m_defaultbkcolor;

    public SplitBar(int splitDirection) {
        this.m_SplitDirection = splitDirection;
        this.Init();
    }

    public SplitBar(int splitDirection, DockContainer parent, DockContainer one, DockContainer two) {
        this.m_SplitDirection = splitDirection;
        this.m_ParentContainer = (DockContainer_)parent;
        this.m_ContainerOne = (DockContainer_)one;
        this.m_ContainerTwo = (DockContainer_)two;
        this.Init();
    }

    public void Init() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_bkcolor = this.m_defaultbkcolor = DockFramework.BackGroundColor;
    }

    public Cursor GetCursor(String curName) {
        return UTIL.GetCursor(this, curName, new Point(10, 10));
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rc = this.getBounds();
        g.setColor(this.m_bkcolor);
        g.fillRect(0, 0, rc.width, rc.height);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.m_CursorHadSetted) {
            if (this.m_SplitDirection == 2) {
                this.setCursor(this.GetCursor("SYS_WE"));
            } else {
                this.setCursor(this.GetCursor("SYS_NS"));
            }
            this.m_CursorHadSetted = true;
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_bkcolor = DockFramework.BorderLineColor;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        int delta;
        Rectangle rcp;
        Rectangle rc2;
        Rectangle rc1;
        Rectangle rc;
        this.m_bkcolor = this.m_defaultbkcolor;
        this.repaint();
        if (this.m_SplitDirection == 2 && this.m_ContainerOne != null && this.m_ContainerOne != null && this.m_ParentContainer != null) {
            if (this.m_ContainerOne.getFixedWidth() > 0 || this.m_ContainerTwo.getFixedWidth() > 0) {
                this.m_ParentContainer.RecalculateSizeOfChildren();
                return;
            }
            rc = this.getBounds();
            rc1 = this.m_ContainerOne.getBounds();
            rc2 = this.m_ContainerTwo.getBounds();
            rcp = this.m_ParentContainer.getBounds();
            rc1.width = rc.x - rc1.x;
            delta = rc.x + 2 - rc2.x;
            rc2.x = rc.x + 2;
            rc2.width -= delta;
            this.m_ContainerOne.setBounds(rc1);
            this.m_ContainerTwo.setBounds(rc2);
            int clientWidth = rcp.width - this.m_ParentContainer.getSplitBarList().size() * 2;
            this.m_ContainerOne.setPercent(rc1.width * 100 / clientWidth);
            this.m_ContainerTwo.setPercent(rc2.width * 100 / clientWidth);
        }
        if (this.m_SplitDirection == 1 && this.m_ContainerOne != null && this.m_ContainerOne != null && this.m_ParentContainer != null) {
            if (this.m_ContainerOne.getFixedHeight() > 0 || this.m_ContainerTwo.getFixedHeight() > 0) {
                this.m_ParentContainer.RecalculateSizeOfChildren();
                return;
            }
            rc = this.getBounds();
            rc1 = this.m_ContainerOne.getBounds();
            rc2 = this.m_ContainerTwo.getBounds();
            rcp = this.m_ParentContainer.getBounds();
            rc1.height = rc.y - rc1.y;
            delta = rc.y + 2 - rc2.y;
            rc2.y = rc.y + 2;
            rc2.height -= delta;
            this.m_ContainerOne.setBounds(rc1);
            this.m_ContainerTwo.setBounds(rc2);
            int clientHeight = rcp.height - this.m_ParentContainer.getSplitBarList().size() * 2;
            this.m_ContainerOne.setPercent(rc1.height * 100 / clientHeight);
            this.m_ContainerTwo.setPercent(rc2.height * 100 / clientHeight);
        }
    }

    public void mouseDragged(MouseEvent e) {
        Rectangle rc2;
        Rectangle rc1;
        Rectangle rc = this.getBounds();
        if (this.m_SplitDirection == 2) {
            rc.x += e.getX() - 1;
            if (this.m_ContainerOne != null && this.m_ContainerOne != null && this.m_ParentContainer != null) {
                rc1 = this.m_ContainerOne.getBounds();
                rc2 = this.m_ContainerTwo.getBounds();
                if (rc.x < rc1.x + 10) {
                    return;
                }
                if (rc.x + 2 > rc2.x + rc2.width - 10) {
                    return;
                }
            }
        }
        if (this.m_SplitDirection == 1) {
            rc.y += e.getY() - 1;
            if (this.m_ContainerOne != null && this.m_ContainerOne != null && this.m_ParentContainer != null) {
                rc1 = this.m_ContainerOne.getBounds();
                rc2 = this.m_ContainerTwo.getBounds();
                if (rc.y < rc1.y + 10) {
                    return;
                }
                if (rc.y + 2 > rc2.y + rc2.height - 10) {
                    return;
                }
            }
        }
        this.setBounds(rc);
    }

    public void mouseMoved(MouseEvent e) {
    }
}

