/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import jun.dock.core.DockBar;
import jun.dock.core.DockBarFrame;
import jun.dock.core.DockContainer;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarFrame_;
import jun.dock.impl.SplitBar;
import org.kxml.kdom.Element;

public class DockContainer_
extends JLayeredPane
implements ComponentListener,
Serializable,
DockContainer {
    private int m_SplitDirection;
    private ArrayList m_ContainerList = null;
    private ArrayList m_HideContainerList = null;
    private int m_IndexBeforeHide = 0;
    private ArrayList m_SplitBarList = null;
    private DockBarFrame_ m_BarFrame = null;
    private DockContainer_ m_ParentContainer = null;
    private int m_Percent = 100;
    private String m_Name = "";

    public DockContainer_(String name) {
        this.Init(name, null);
    }

    DockContainer_(DockBarFrame dbf) {
        this.Init("", (DockBarFrame_)dbf);
    }

    DockContainer_(DockBar db) {
        this.Init("", new DockBarFrame_(db));
    }

    DockContainer_(DockContainer_ pdc) {
        DockContainer_ dc;
        this.setLayout(null);
        this.m_Name = pdc.m_Name;
        this.m_SplitDirection = pdc.m_SplitDirection;
        this.m_ContainerList = new ArrayList();
        this.m_ContainerList.addAll(pdc.m_ContainerList);
        this.m_HideContainerList = new ArrayList();
        this.m_HideContainerList.addAll(pdc.m_HideContainerList);
        this.m_SplitBarList = new ArrayList();
        this.m_SplitBarList.addAll(pdc.m_SplitBarList);
        this.m_BarFrame = pdc.m_BarFrame;
        if (this.m_BarFrame != null) {
            this.add(this.m_BarFrame);
        }
        this.m_ParentContainer = pdc.m_ParentContainer;
        this.m_Percent = pdc.m_Percent;
        int i = 0;
        while (i < this.m_ContainerList.size()) {
            dc = (DockContainer_)this.m_ContainerList.get(i);
            dc.m_ParentContainer = this;
            pdc.remove(dc);
            this.add(dc);
            ++i;
        }
        i = 0;
        while (i < this.m_HideContainerList.size()) {
            dc = (DockContainer_)this.m_HideContainerList.get(i);
            dc.m_ParentContainer = this;
            ++i;
        }
        i = 0;
        while (i < this.m_SplitBarList.size()) {
            SplitBar sb = (SplitBar)this.m_SplitBarList.get(i);
            sb.m_ParentContainer = this;
            pdc.remove(sb);
            this.add(sb);
            this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
            ++i;
        }
        this.addComponentListener(this);
    }

    public DockContainer getRootContainer() {
        if (this.isRoot()) {
            return this;
        }
        return this.m_ParentContainer.getRootContainer();
    }

    private void Init(String name, DockBarFrame_ dbf) {
        this.setLayout(null);
        this.m_SplitDirection = 0;
        this.m_BarFrame = dbf == null ? new DockBarFrame_(name) : dbf;
        this.add(this.m_BarFrame);
        this.m_ContainerList = new ArrayList();
        this.m_HideContainerList = new ArrayList();
        this.m_SplitBarList = new ArrayList();
        this.addComponentListener(this);
    }

    public int getSplitDirection() {
        return this.m_SplitDirection;
    }

    void Split(int splitDirection, DockContainer beforeDC, DockContainer dc, boolean addBefore) {
        if (splitDirection == 2) {
            this.horizontalSplit(beforeDC, dc, addBefore);
        }
        if (splitDirection == 1) {
            this.verticalSplit(beforeDC, dc, addBefore);
        }
    }

    public void horizontalSplit(DockContainer beforeDC, DockContainer adc, boolean addBefore) {
        DockContainer_ dc = (DockContainer_)adc;
        int AddAt = 0;
        if (beforeDC != null) {
            AddAt = this.m_ContainerList.indexOf(beforeDC);
        }
        if (AddAt < 0) {
            AddAt = 0;
        }
        if (!addBefore && this.m_ContainerList.size() > 0) {
            ++AddAt;
        }
        boolean AddAtHead = false;
        boolean AddAtTail = false;
        if (AddAt == 0) {
            AddAtHead = true;
        }
        if (!AddAtHead && AddAt >= this.m_ContainerList.size()) {
            AddAtTail = true;
        }
        switch (this.m_SplitDirection) {
            case 0: {
                SplitBar sb;
                if (this.m_ContainerList.size() != 0 || this.m_BarFrame == null) break;
                this.remove(this.m_BarFrame);
                this.m_SplitDirection = 2;
                DockContainer_ ndc = new DockContainer_(this.m_BarFrame);
                this.m_BarFrame = null;
                ndc.m_ParentContainer = this;
                this.m_ContainerList.add(ndc);
                this.add(ndc);
                dc.m_ParentContainer = this;
                this.add(dc);
                if (!addBefore) {
                    this.m_ContainerList.add(1, dc);
                    sb = new SplitBar(2, this, ndc, dc);
                } else {
                    this.m_ContainerList.add(0, dc);
                    sb = new SplitBar(2, this, dc, ndc);
                }
                this.m_SplitBarList.add(sb);
                this.add(sb);
                this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
                break;
            }
            case 2: {
                dc.m_ParentContainer = this;
                this.add(dc);
                this.m_ContainerList.add(AddAt, dc);
                if (this.m_ContainerList.size() > 1) {
                    SplitBar sb = null;
                    if (AddAtHead) {
                        sb = new SplitBar(2, this, dc, (DockContainer)this.m_ContainerList.get(AddAt + 1));
                    }
                    if (AddAtTail) {
                        sb = new SplitBar(2, this, (DockContainer)this.m_ContainerList.get(AddAt - 1), dc);
                    }
                    if (!AddAtHead && !AddAtTail) {
                        sb = new SplitBar(2, this, dc, (DockContainer)this.m_ContainerList.get(AddAt + 1));
                        SplitBar lsb = (SplitBar)this.m_SplitBarList.get(AddAt - 1);
                        lsb.m_ContainerTwo = dc;
                    }
                    int AddSpAt = AddAt;
                    if (AddAtTail) {
                        --AddSpAt;
                    }
                    this.m_SplitBarList.add(AddSpAt, sb);
                    this.add(sb);
                    this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
                    break;
                }
                this.Rind();
                break;
            }
            case 1: {
                DockContainer_ ndc = new DockContainer_(this);
                this.m_ContainerList.clear();
                this.m_SplitBarList.clear();
                this.m_SplitDirection = 2;
                ndc.m_ParentContainer = this;
                this.m_ContainerList.add(ndc);
                this.add(ndc);
                this.horizontalSplit(null, dc, addBefore);
                return;
            }
        }
        int c = this.m_ContainerList.size();
        int i = 0;
        while (i < c) {
            DockContainer_ ndc = (DockContainer_)this.m_ContainerList.get(i);
            if (dc.m_Percent == 100) {
                if (ndc.m_Percent == 100) {
                    ndc.setPercent(100 / c);
                } else {
                    ndc.setPercent(ndc.m_Percent * (c - 1) / c);
                }
            } else if (ndc != dc) {
                ndc.setPercent(ndc.m_Percent * (100 - dc.m_Percent) / 100);
            }
            ++i;
        }
        this.RecalculateSizeOfChildren();
    }

    public void verticalSplit(DockContainer beforeDC, DockContainer adc, boolean addBefore) {
        DockContainer_ dc = (DockContainer_)adc;
        int AddAt = 0;
        if (beforeDC != null) {
            AddAt = this.m_ContainerList.indexOf(beforeDC);
        }
        if (AddAt < 0) {
            AddAt = 0;
        }
        if (!addBefore && this.m_ContainerList.size() > 0) {
            ++AddAt;
        }
        boolean AddAtHead = false;
        boolean AddAtTail = false;
        if (AddAt == 0) {
            AddAtHead = true;
        }
        if (!AddAtHead && AddAt == this.m_ContainerList.size()) {
            AddAtTail = true;
        }
        switch (this.m_SplitDirection) {
            case 0: {
                SplitBar sb;
                if (this.m_ContainerList.size() != 0 || this.m_BarFrame == null) break;
                this.remove(this.m_BarFrame);
                this.m_SplitDirection = 1;
                DockContainer_ ndc = new DockContainer_(this.m_BarFrame);
                this.m_BarFrame = null;
                ndc.m_ParentContainer = this;
                this.m_ContainerList.add(ndc);
                this.add(ndc);
                dc.m_ParentContainer = this;
                this.add(dc);
                if (!addBefore) {
                    this.m_ContainerList.add(1, dc);
                    sb = new SplitBar(1, this, ndc, dc);
                } else {
                    this.m_ContainerList.add(0, dc);
                    sb = new SplitBar(1, this, dc, ndc);
                }
                this.m_SplitBarList.add(sb);
                this.add(sb);
                this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
                break;
            }
            case 1: {
                dc.m_ParentContainer = this;
                this.add(dc);
                this.m_ContainerList.add(AddAt, dc);
                if (this.m_ContainerList.size() > 1) {
                    SplitBar sb = null;
                    if (AddAtHead) {
                        sb = new SplitBar(1, this, dc, (DockContainer)this.m_ContainerList.get(AddAt + 1));
                    }
                    if (AddAtTail) {
                        sb = new SplitBar(1, this, (DockContainer)this.m_ContainerList.get(AddAt - 1), dc);
                    }
                    if (!AddAtHead && !AddAtTail) {
                        sb = new SplitBar(1, this, dc, (DockContainer)this.m_ContainerList.get(AddAt + 1));
                        SplitBar lsb = (SplitBar)this.m_SplitBarList.get(AddAt - 1);
                        lsb.m_ContainerTwo = dc;
                    }
                    int AddSpAt = AddAt;
                    if (AddAtTail) {
                        --AddSpAt;
                    }
                    this.m_SplitBarList.add(AddSpAt, sb);
                    this.add(sb);
                    this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
                    break;
                }
                this.Rind();
                break;
            }
            case 2: {
                DockContainer_ ndc = new DockContainer_(this);
                this.m_ContainerList.clear();
                this.m_SplitBarList.clear();
                this.m_SplitDirection = 1;
                ndc.m_ParentContainer = this;
                this.m_ContainerList.add(ndc);
                this.add(ndc);
                this.verticalSplit(null, dc, addBefore);
                return;
            }
        }
        int c = this.m_ContainerList.size();
        int i = 0;
        while (i < c) {
            DockContainer_ ndc = (DockContainer_)this.m_ContainerList.get(i);
            if (dc.m_Percent == 100) {
                if (ndc.m_Percent == 100) {
                    ndc.setPercent(100 / c);
                } else {
                    ndc.setPercent(ndc.m_Percent * (c - 1) / c);
                }
            } else if (ndc != dc) {
                ndc.setPercent(ndc.m_Percent * (100 - dc.m_Percent) / 100);
            }
            ++i;
        }
        this.RecalculateSizeOfChildren();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.RecalculateSizeOfChildren();
        this.doLayout();
    }

    public void componentShown(ComponentEvent e) {
    }

    public boolean isRoot() {
        return this.m_ParentContainer == null;
    }

    void RecalculateSizeOfChildren() {
        Rectangle rc = this.getBounds();
        int childrenCount = this.m_ContainerList.size();
        boolean n = false;
        int k = 0;
        int totalPercent = 0;
        ArrayList<Integer> fixedList = new ArrayList<Integer>();
        ArrayList<Integer> dynamicList = new ArrayList<Integer>();
        try {
            switch (this.m_SplitDirection) {
                case 0: {
                    this.m_BarFrame.setBounds(0, 0, rc.width, rc.height);
                    break;
                }
                case 2: {
                    DockContainer_ cdc;
                    totalPercent = 0;
                    int i = 0;
                    while (i < childrenCount) {
                        cdc = (DockContainer_)this.m_ContainerList.get(i);
                        if (cdc.getFixedWidth() == 0) {
                            dynamicList.add(i);
                            totalPercent += cdc.getPercent();
                        } else {
                            fixedList.add(i);
                        }
                        ++i;
                    }
                    int totalFixedWidth = 0;
                    int maxFixedWidth = rc.width - 2 * (childrenCount - 1);
                    int i2 = 0;
                    while (i2 < fixedList.size()) {
                        cdc = (DockContainer_)this.m_ContainerList.get((Integer)fixedList.get(i2));
                        int fw = cdc.getFixedWidth();
                        if ((totalFixedWidth += fw) < maxFixedWidth) {
                            cdc.setBounds(0, 0, fw, rc.height);
                        } else {
                            cdc.setBounds(0, 0, fw - (totalFixedWidth - maxFixedWidth), rc.height);
                        }
                        ++i2;
                    }
                    int dynamicTotalWidth = Math.max(0, rc.width - totalFixedWidth - 2 * (childrenCount - 1));
                    int usedDynamicWidth = 0;
                    int i3 = 0;
                    while (i3 < dynamicList.size()) {
                        cdc = (DockContainer_)this.m_ContainerList.get((Integer)dynamicList.get(i3));
                        if (i3 == dynamicList.size() - 1) {
                            cdc.setBounds(0, 0, dynamicTotalWidth - usedDynamicWidth, rc.height);
                        } else {
                            k = (int)((double)dynamicTotalWidth * 1.0 * (double)cdc.getPercent() / (double)totalPercent);
                            usedDynamicWidth += k;
                            cdc.setBounds(0, 0, k, rc.height);
                        }
                        ++i3;
                    }
                    int Left = 0;
                    i3 = 0;
                    while (i3 < childrenCount) {
                        cdc = (DockContainer_)this.m_ContainerList.get(i3);
                        Rectangle cdc_rc = cdc.getBounds();
                        cdc_rc.x = Left;
                        cdc_rc.y = 0;
                        cdc.setBounds(cdc_rc);
                        Left += cdc_rc.width;
                        if (i3 < this.m_SplitBarList.size()) {
                            ((SplitBar)this.m_SplitBarList.get(i3)).setBounds(Left, 0, 2, rc.height);
                        }
                        Left += 2;
                        ++i3;
                    }
                    break;
                }
                case 1: {
                    DockContainer_ cdc;
                    totalPercent = 0;
                    int i = 0;
                    while (i < childrenCount) {
                        cdc = (DockContainer_)this.m_ContainerList.get(i);
                        if (cdc.getFixedHeight() == 0) {
                            dynamicList.add(i);
                            totalPercent += cdc.getPercent();
                        } else {
                            fixedList.add(i);
                        }
                        ++i;
                    }
                    int totalFixedHeight = 0;
                    int maxFixedHeight = rc.height - 2 * (childrenCount - 1);
                    int i4 = 0;
                    while (i4 < fixedList.size()) {
                        cdc = (DockContainer_)this.m_ContainerList.get((Integer)fixedList.get(i4));
                        int fh = cdc.getFixedHeight();
                        if ((totalFixedHeight += fh) < maxFixedHeight) {
                            cdc.setBounds(0, 0, rc.width, fh);
                        } else {
                            cdc.setBounds(0, 0, rc.width, fh - (totalFixedHeight - maxFixedHeight));
                        }
                        ++i4;
                    }
                    int dynamicTotalHeight = Math.max(0, rc.height - totalFixedHeight - 2 * (childrenCount - 1));
                    int usedDynamicHeight = 0;
                    int i5 = 0;
                    while (i5 < dynamicList.size()) {
                        cdc = (DockContainer_)this.m_ContainerList.get((Integer)dynamicList.get(i5));
                        if (i5 == dynamicList.size() - 1) {
                            cdc.setBounds(0, 0, rc.width, dynamicTotalHeight - usedDynamicHeight);
                        } else {
                            k = (int)((double)dynamicTotalHeight * 1.0 * (double)cdc.getPercent() / (double)totalPercent);
                            usedDynamicHeight += k;
                            cdc.setBounds(0, 0, rc.width, k);
                        }
                        ++i5;
                    }
                    int Top = 0;
                    i5 = 0;
                    while (i5 < childrenCount) {
                        cdc = (DockContainer_)this.m_ContainerList.get(i5);
                        Rectangle cdc_rc = cdc.getBounds();
                        cdc_rc.x = 0;
                        cdc_rc.y = Top;
                        cdc.setBounds(cdc_rc);
                        Top += cdc_rc.height;
                        if (i5 < this.m_SplitBarList.size()) {
                            ((SplitBar)this.m_SplitBarList.get(i5)).setBounds(0, Top, rc.width, 2);
                        }
                        Top += 2;
                        ++i5;
                    }
                    break block1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPercent() {
        return this.m_Percent;
    }

    public void setPercent(int widthPercent) {
        if (this.isRoot()) {
            this.m_Percent = 100;
            return;
        }
        this.m_Percent = widthPercent;
        this.componentResized(null);
    }

    public int getFixedWidth() {
        int childrenCount = this.m_ContainerList.size();
        int ret = 0;
        switch (this.m_SplitDirection) {
            case 0: {
                ArrayList list = this.m_BarFrame.getDockBarList();
                int i = 0;
                while (i < list.size()) {
                    int w = ((DockBar)list.get(i)).getFixedWidth();
                    ret = Math.max(ret, w);
                    ++i;
                }
                return ret;
            }
            case 2: {
                return 0;
            }
            case 1: {
                int i = 0;
                while (i < this.m_ContainerList.size()) {
                    DockContainer dc = (DockContainer)this.m_ContainerList.get(i);
                    int w = dc.getFixedWidth();
                    ret = Math.max(ret, w);
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    public int getFixedHeight() {
        int childrenCount = this.m_ContainerList.size();
        int ret = 0;
        switch (this.m_SplitDirection) {
            case 0: {
                ArrayList list = this.m_BarFrame.getDockBarList();
                int i = 0;
                while (i < list.size()) {
                    int w = ((DockBar)list.get(i)).getFixedHeight();
                    ret = Math.max(ret, w);
                    ++i;
                }
                return ret;
            }
            case 1: {
                return 0;
            }
            case 2: {
                int i = 0;
                while (i < this.m_ContainerList.size()) {
                    DockContainer dc = (DockContainer)this.m_ContainerList.get(i);
                    int w = dc.getFixedHeight();
                    ret = Math.max(ret, w);
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    public void print(Graphics g) {
        Rectangle rc = this.getBounds();
        --rc.width;
        --rc.height;
        g.setColor(DockFramework.BackGroundColor);
        g.fillRect(0, 0, rc.width, rc.height);
        super.paint(g);
    }

    public DockContainer getDockContainerAtPoint(Point point) {
        Rectangle rc = this.getBounds();
        Point p = new Point(point);
        p.x -= rc.x;
        p.y -= rc.y;
        if (p.x > 300) {
            boolean bl = true;
        }
        rc.setLocation(0, 0);
        if (!rc.contains(p)) {
            return null;
        }
        if (this.m_ContainerList.size() == 0) {
            return this;
        }
        int i = 0;
        while (i < this.m_ContainerList.size()) {
            DockContainer dc = (DockContainer)this.m_ContainerList.get(i);
            DockContainer ret = dc.getDockContainerAtPoint(p);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    Rectangle getAbsoluteBounds() {
        Rectangle rc = this.getBounds();
        if (this.isRoot()) {
            return rc;
        }
        Rectangle prc = this.m_ParentContainer.getAbsoluteBounds();
        rc.x += prc.x;
        rc.y += prc.y;
        return rc;
    }

    public boolean removeDockContainer(DockContainer dc) {
        int di = this.m_ContainerList.indexOf(dc);
        if (di < 0) {
            return false;
        }
        this.remove((DockContainer_)dc);
        SplitBar sb = null;
        int sbc = this.m_SplitBarList.size();
        if (di == 0) {
            if (this.m_SplitBarList.size() > 0) {
                sb = (SplitBar)this.m_SplitBarList.get(0);
                this.remove(sb);
                this.m_SplitBarList.remove(0);
            }
        } else if (di + 1 == this.m_ContainerList.size()) {
            if (this.m_SplitBarList.size() > 0) {
                sb = (SplitBar)this.m_SplitBarList.get(sbc - 1);
                this.remove(sb);
                this.m_SplitBarList.remove(sbc - 1);
            }
        } else {
            sb = (SplitBar)this.m_SplitBarList.get(di);
            this.remove(sb);
            this.m_SplitBarList.remove(di);
            sb = (SplitBar)this.m_SplitBarList.get(di - 1);
            sb.m_ContainerTwo = (DockContainer_)this.m_ContainerList.get(di + 1);
        }
        this.m_ContainerList.remove(di);
        int n = this.m_ContainerList.size();
        int totalPercent = 0;
        int i = 0;
        while (i < n) {
            totalPercent += this.getDockContainerAt(i).getPercent();
            ++i;
        }
        DockContainer idc = null;
        int sumPercent = 0;
        int newPercent = 0;
        Rectangle rc = this.getBounds();
        int i2 = 0;
        while (i2 < n) {
            idc = this.getDockContainerAt(i2);
            newPercent = idc.getPercent() * 100 / totalPercent;
            if (i2 + 1 == n) {
                idc.setPercent(100 - sumPercent);
            } else {
                idc.setPercent(newPercent);
            }
            sumPercent += newPercent;
            ++i2;
        }
        this.Rind();
        return true;
    }

    void Rind() {
        int i = 0;
        while (i < this.m_ContainerList.size()) {
            ((DockContainer_)this.getDockContainerAt(i)).Rind();
            ++i;
        }
        SplitBar sb = null;
        DockContainer_ sdc = null;
        if (this.getVisibleSubContainerCount() == 1 && this.getUnVisibleSubContainerCount() == 0) {
            DockContainer_ tdc;
            sdc = (DockContainer_)this.m_ContainerList.get(0);
            this.remove(sdc);
            this.m_Name = "clone sub dc";
            this.m_SplitDirection = sdc.m_SplitDirection;
            this.m_ContainerList = new ArrayList();
            this.m_ContainerList.addAll(sdc.m_ContainerList);
            this.m_HideContainerList = new ArrayList();
            this.m_HideContainerList.addAll(sdc.m_HideContainerList);
            this.m_SplitBarList = new ArrayList();
            this.m_SplitBarList.addAll(sdc.m_SplitBarList);
            this.m_BarFrame = sdc.m_BarFrame;
            if (this.m_BarFrame != null) {
                this.add(this.m_BarFrame);
            }
            int i2 = 0;
            while (i2 < this.m_ContainerList.size()) {
                tdc = (DockContainer_)this.m_ContainerList.get(i2);
                tdc.m_ParentContainer = this;
                sdc.remove(tdc);
                this.add(tdc);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_HideContainerList.size()) {
                tdc = (DockContainer_)this.m_HideContainerList.get(i2);
                tdc.m_ParentContainer = this;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m_SplitBarList.size()) {
                sb = (SplitBar)this.m_SplitBarList.get(i2);
                sb.m_ParentContainer = this;
                sdc.remove(sb);
                this.add(sb);
                this.setLayer(sb, JLayeredPane.PALETTE_LAYER);
                ++i2;
            }
            sdc.m_ContainerList.clear();
        }
        this.RecalculateSizeOfChildren();
        if (this.getVisibleSubContainerCount() == 0 && this.getUnVisibleSubContainerCount() > 0) {
            this.hideContainer();
        }
    }

    public boolean moveDockContainerAheadOrBehind(DockContainer dc1, DockContainer dc2, boolean ahead) {
        if (ahead) {
            return this.moveDockContainerAhead(dc1, dc2);
        }
        return this.moveDockContainerBehind(dc1, dc2);
    }

    public boolean moveDockContainerAhead(DockContainer dc1, DockContainer dc2) {
        int di1 = this.m_ContainerList.indexOf(dc1);
        int di2 = this.m_ContainerList.indexOf(dc2);
        if (di1 < 0 || di2 < 0) {
            return false;
        }
        if (di1 + 1 == di2) {
            return true;
        }
        this.m_ContainerList.remove(di1);
        this.m_ContainerList.add(di2 - (di1 < di2 ? 1 : 0), dc1);
        SplitBar sb = null;
        int i = 0;
        while (i < this.m_SplitBarList.size()) {
            sb = (SplitBar)this.m_SplitBarList.get(i);
            sb.m_ContainerOne = (DockContainer_)this.getDockContainerAt(i);
            sb.m_ContainerTwo = (DockContainer_)this.getDockContainerAt(i + 1);
            ++i;
        }
        this.RecalculateSizeOfChildren();
        this.repaint();
        return true;
    }

    public boolean moveDockContainerBehind(DockContainer dc1, DockContainer dc2) {
        int di1 = this.m_ContainerList.indexOf(dc1);
        int di2 = this.m_ContainerList.indexOf(dc2);
        if (di1 < 0 || di2 < 0) {
            return false;
        }
        if (di1 == di2 + 1) {
            return true;
        }
        this.m_ContainerList.remove(di1);
        this.m_ContainerList.add(di2 + (di1 < di2 ? 0 : 1), dc1);
        SplitBar sb = null;
        int i = 0;
        while (i < this.m_SplitBarList.size()) {
            sb = (SplitBar)this.m_SplitBarList.get(i);
            sb.m_ContainerOne = (DockContainer_)this.getDockContainerAt(i);
            sb.m_ContainerTwo = (DockContainer_)this.getDockContainerAt(i + 1);
            ++i;
        }
        this.RecalculateSizeOfChildren();
        this.repaint();
        return true;
    }

    public DockContainer getDockContainerAt(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.m_ContainerList.size()) {
            return null;
        }
        return (DockContainer)this.m_ContainerList.get(index);
    }

    public int getLevel() {
        if (this.isRoot()) {
            return 1;
        }
        return this.m_ParentContainer.getLevel() + 1;
    }

    public int sameLeftAscendCount() {
        if (this.isRoot()) {
            return 0;
        }
        Rectangle rc = this.getBounds();
        if (rc.x != 0) {
            return 0;
        }
        return 1 + this.m_ParentContainer.sameLeftAscendCount();
    }

    public int sameRightAscendCount() {
        if (this.isRoot()) {
            return 0;
        }
        Rectangle rc = this.getAbsoluteBounds();
        Rectangle prc = this.m_ParentContainer.getAbsoluteBounds();
        if (rc.x + rc.width != prc.x + prc.width) {
            return 0;
        }
        return 1 + this.m_ParentContainer.sameRightAscendCount();
    }

    public int sameTopAscendCount() {
        if (this.isRoot()) {
            return 0;
        }
        Rectangle rc = this.getBounds();
        if (rc.y != 0) {
            return 0;
        }
        return 1 + this.m_ParentContainer.sameTopAscendCount();
    }

    public int sameBottomAscendCount() {
        if (this.isRoot()) {
            return 0;
        }
        Rectangle rc = this.getAbsoluteBounds();
        Rectangle prc = this.m_ParentContainer.getAbsoluteBounds();
        if (rc.y + rc.height != prc.y + prc.height) {
            return 0;
        }
        return 1 + this.m_ParentContainer.sameBottomAscendCount();
    }

    public DockContainer ascend(int ac) {
        if (ac <= 0) {
            return this;
        }
        return this.m_ParentContainer.ascend(ac - 1);
    }

    public void hideContainer() {
        if (this.isRoot()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(false);
        this.m_ParentContainer.m_HideContainerList.add(this);
        this.m_IndexBeforeHide = this.m_ParentContainer.m_ContainerList.indexOf(this);
        this.m_ParentContainer.removeDockContainer(this);
        if (this.m_ParentContainer.getVisibleSubContainerCount() == 0) {
            this.m_ParentContainer.hideContainer();
        }
    }

    public void showContainer() {
        if (this.isVisible()) {
            return;
        }
        if (this.isRoot()) {
            this.setVisible(true);
            return;
        }
        if (!this.m_ParentContainer.isVisible()) {
            this.m_ParentContainer.showContainer();
        }
        this.setVisible(true);
        this.m_ParentContainer.restoreDockContainer(this);
    }

    public void restoreDockContainer(DockContainer subDC) {
        int index = this.m_HideContainerList.indexOf(subDC);
        if (index < 0) {
            return;
        }
        this.m_HideContainerList.remove(index);
        int n = ((DockContainer_)subDC).m_IndexBeforeHide;
        boolean addBefore = true;
        int cc = this.m_ContainerList.size();
        if (n >= cc) {
            n = cc - 1;
            addBefore = false;
        }
        DockContainer beforeDC = null;
        if (n >= 0) {
            beforeDC = (DockContainer)this.m_ContainerList.get(n);
        }
        if (this.m_SplitDirection == 2) {
            this.horizontalSplit(beforeDC, subDC, addBefore);
        } else {
            this.verticalSplit(beforeDC, subDC, addBefore);
        }
    }

    public int getVisibleSubContainerCount() {
        return this.m_ContainerList.size();
    }

    public int getUnVisibleSubContainerCount() {
        return this.m_HideContainerList.size();
    }

    public void saveToXML(Element e) {
        Element ec;
        e.setValue("SplitDirection", String.valueOf(this.m_SplitDirection));
        e.setValue("IndexBeforeHide", String.valueOf(this.m_IndexBeforeHide));
        e.setValue("Percent", String.valueOf(this.m_Percent));
        e.setValue("Name", this.m_Name);
        if (this.m_BarFrame == null) {
            e.setValue("BarFrame", "null");
        } else {
            e.setValue("BarFrame", "");
            Element ef = new Element();
            ef.setName("BarFrame");
            e.addChild(4, (Object)ef);
            this.m_BarFrame.saveToXML(ef);
        }
        e.setValue("SubContainerCount", String.valueOf(this.m_ContainerList.size() + this.m_HideContainerList.size()));
        int n = 0;
        int i = 0;
        while (i < this.m_ContainerList.size()) {
            ec = new Element();
            ec.setName("SubContainer_" + String.valueOf(i));
            ec.setValue("Visible", "1");
            e.addChild(4, (Object)ec);
            ((DockContainer)this.m_ContainerList.get(i)).saveToXML(ec);
            ++i;
        }
        n = this.m_ContainerList.size();
        i = 0;
        while (i < this.m_HideContainerList.size()) {
            ec = new Element();
            ec.setName("SubContainer_" + String.valueOf(i + n));
            ec.setValue("Visible", "0");
            e.addChild(4, (Object)ec);
            ((DockContainer)this.m_HideContainerList.get(i)).saveToXML(ec);
            ++i;
        }
    }

    public static DockContainer CreateFromXML(Element e) {
        DockContainer_ ret = null;
        String t = e.getValue("BarFrame").trim().toLowerCase();
        if (!t.equals("null")) {
            Element ef = e.getElement("BarFrame");
            ret = new DockContainer_(DockBarFrame_.CreateFromXML(ef));
        }
        int scc = Integer.valueOf(e.getValue("SubContainerCount"));
        int sp = Integer.valueOf(e.getValue("SplitDirection"));
        if (ret == null && scc > 0) {
            Element ec = e.getElement("SubContainer_0");
            ret = (DockContainer_)DockContainer_.CreateFromXML(ec);
            DockContainer lastDC = null;
            int i = 1;
            while (i < scc) {
                ec = e.getElement("SubContainer_" + String.valueOf(i));
                DockContainer subDC = DockContainer_.CreateFromXML(ec);
                ret.Split(sp, lastDC, subDC, false);
                lastDC = subDC;
                ++i;
            }
            i = 0;
            while (i < scc) {
                ec = e.getElement("SubContainer_" + String.valueOf(i));
                ((DockContainer_)ret.m_ContainerList.get((int)i)).m_Percent = Integer.valueOf(ec.getValue("Percent"));
                ++i;
            }
        }
        ret.m_IndexBeforeHide = Integer.valueOf(e.getValue("IndexBeforeHide"));
        ret.m_Percent = Integer.valueOf(e.getValue("Percent"));
        ret.m_Name = e.getValue("Name");
        return ret;
    }

    public DockContainer getParentContainer() {
        return this.m_ParentContainer;
    }

    public ArrayList getContainerList() {
        return this.m_ContainerList;
    }

    public DockBarFrame getDockBarFrame() {
        return this.m_BarFrame;
    }

    public ArrayList getHideContainerList() {
        return this.m_HideContainerList;
    }

    public ArrayList getSplitBarList() {
        return this.m_SplitBarList;
    }
}

