/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import jun.dock.core.DockBar;
import jun.dock.core.DockBarFrame;
import jun.dock.core.DockBarFrameTitle;
import jun.dock.core.DockBarTab;
import jun.dock.core.DockContainer;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarFrameTitle_;
import jun.dock.impl.DockBarTabButton_;
import jun.dock.impl.DockBarTab_;
import jun.dock.impl.DockBar_;
import org.kxml.kdom.Element;

public class DockBarFrame_
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
DockBarFrame {
    private ArrayList m_DockBarList;
    private ArrayList m_HideDockBarList;
    private DockBarFrameTitle_ m_Title = null;
    private DockBarTab_ m_Tab = null;
    private DockBar m_CurrentActiveDockBar = null;

    public DockBarFrame_(String name) {
        this.init(name, null);
    }

    public DockBarFrame_(DockBar db) {
        this.init("", db);
    }

    private void init(String name, DockBar db) {
        this.setLayout(null);
        this.setBounds(0, 0, 100, 100);
        this.m_DockBarList = new ArrayList();
        this.m_HideDockBarList = new ArrayList();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_Title = new DockBarFrameTitle_(this);
        this.m_Tab = new DockBarTab_(this);
        DockBar ndb = null;
        ndb = db == null ? new DockBar_(name) : db;
        this.addBar(ndb);
        this.activeDockBar(ndb);
    }

    public void addBar(DockBar db) {
        this.m_DockBarList.add(db);
        this.add(db);
        db.setDockBarFrame(this);
        db.setVisible(false);
        DockBarTabButton_ dbtb = new DockBarTabButton_(this.m_Tab, db);
        this.resizeAllDockBar();
        this.m_Tab.CalculateItemWidth();
        this.repaint();
    }

    public void removeBar(DockBar db) {
        int index = this.m_DockBarList.indexOf(db);
        if (index < 0) {
            return;
        }
        if (index + 1 > this.m_DockBarList.size()) {
            return;
        }
        this.m_DockBarList.remove(index);
        this.remove(db);
        this.m_Tab.remove((DockBarTabButton_)db.getTabButton());
        if (this.m_DockBarList.size() > 1) {
            this.m_Tab.getItemWidthList().remove(index);
        }
        if (this.m_CurrentActiveDockBar.equals(db) && this.m_DockBarList.size() > 0) {
            this.activeDockBar((DockBar)this.m_DockBarList.get(0));
        }
        this.resizeAllDockBar();
        this.m_Tab.CalculateItemWidth();
        this.repaint();
    }

    public void hideDockBar(DockBar db) {
        if (db == null) {
            return;
        }
        int index = this.m_DockBarList.indexOf(db);
        if (index < 0) {
            return;
        }
        if (index + 1 > this.m_DockBarList.size()) {
            return;
        }
        db.setIndexBeforeHide(index);
        this.m_HideDockBarList.add(db);
        this.removeBar(db);
        if (this.m_DockBarList.size() == 0) {
            this.getContainer().hideContainer();
        }
    }

    public void hideDockBar(String name) {
        this.hideDockBar(this.findDockBar(name));
    }

    public void showDockBar(DockBar db) {
        if (db == null) {
            return;
        }
        int index = this.m_HideDockBarList.indexOf(db);
        if (index < 0) {
            return;
        }
        if (index + 1 > this.m_HideDockBarList.size()) {
            return;
        }
        this.m_HideDockBarList.remove(index);
        this.addBar(db);
        this.setDockBarIndex(db, db.getIndexBeforeHide());
        if (this.m_DockBarList.size() == 1) {
            this.activeDockBar(db);
        }
        this.getContainer().showContainer();
    }

    public void showDockBar(String name) {
        this.showDockBar(this.findHideDockBar(name));
    }

    public DockContainer getContainer() {
        return (DockContainer)((Object)this.getParent());
    }

    public void activeDockBar(DockBar db) {
        this.m_CurrentActiveDockBar = db;
        int i = 0;
        while (i < this.m_DockBarList.size()) {
            DockBar_ adb = (DockBar_)this.m_DockBarList.get(i);
            if (adb.equals(db)) {
                adb.setVisible(true);
                adb.getTabButton().setActive(true);
            } else {
                adb.setVisible(false);
                adb.getTabButton().setActive(false);
            }
            ++i;
        }
        this.m_Tab.CalculateItemWidth();
        this.repaint();
    }

    public int getActiveDockBarIndex() {
        return this.m_DockBarList.indexOf(this.m_CurrentActiveDockBar);
    }

    public DockBar getActiveDockBar() {
        return this.m_CurrentActiveDockBar;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.resizeAllDockBar();
    }

    public void componentShown(ComponentEvent e) {
    }

    public DockBar findDockBar(String name) {
        return this.findDockBar(name, this.m_DockBarList);
    }

    public DockBar findHideDockBar(String name) {
        return this.findDockBar(name, this.m_HideDockBarList);
    }

    public DockBar findDockBar(String name, ArrayList list) {
        String t = name;
        t = t.toLowerCase().trim();
        int i = 0;
        while (i < list.size()) {
            DockBar_ bar = (DockBar_)list.get(i);
            String s = bar.getBarName();
            if (t.equals(s = s.toLowerCase().trim())) {
                return bar;
            }
            ++i;
        }
        return null;
    }

    public void paint(Graphics g) {
        Rectangle rc = this.getBounds();
        g.setColor(DockFramework.BackGroundColor);
        g.fillRect(0, 0, rc.width, rc.height);
        rc.y = this.m_Title.getTitleBarHeight();
        rc.height = rc.height - (rc.y + 1 + (this.m_Tab.isVisible() ? this.m_Tab.getTabBarHeight() : 0));
        g.setColor(DockFramework.BorderLineColor);
        g.drawRect(0, rc.y, --rc.width, rc.height + (this.m_Tab.isVisible() ? 1 : 0));
        super.paint(g);
    }

    private void resizeAllDockBar() {
        Rectangle rc = this.getBounds();
        int h = rc.height;
        this.m_Title.setBounds(0, 0, rc.width, this.m_Title.getTitleBarHeight() + 1);
        rc.y = this.m_Title.getTitleBarHeight();
        rc.height -= rc.y;
        if (this.m_DockBarList.size() > 1) {
            this.m_Tab.setVisible(true);
            this.m_Tab.setBounds(0, h - this.m_Tab.getTabBarHeight(), rc.width, this.m_Tab.getTabBarHeight());
            rc.height -= this.m_Tab.getTabBarHeight();
        } else {
            this.m_Tab.setVisible(false);
        }
        int i = 0;
        while (i < this.m_DockBarList.size()) {
            DockBar_ bar = (DockBar_)this.m_DockBarList.get(i);
            bar.setBounds(rc);
            ++i;
        }
    }

    public void setDockBarIndex(DockBar db, int index) {
        int oldIndex = this.m_DockBarList.indexOf(db);
        if (oldIndex < 0) {
            return;
        }
        if (this.m_DockBarList.size() < 2) {
            return;
        }
        if (oldIndex == index) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= this.m_DockBarList.size()) {
            index = this.m_DockBarList.size() - 1;
        }
        this.m_DockBarList.remove(oldIndex);
        this.m_DockBarList.add(index, db);
        this.activeDockBar(db);
    }

    public int getDockBarIndex(DockBar db) {
        return this.m_DockBarList.indexOf(db);
    }

    public boolean isCurrentActiveBar(DockBar db) {
        return this.m_CurrentActiveDockBar == db;
    }

    public void saveToXML(Element e) {
        e.setValue("ActiveBarIndex", String.valueOf(this.m_DockBarList.indexOf(this.m_CurrentActiveDockBar)));
        e.setValue("DockBarCount", String.valueOf(this.m_DockBarList.size() + this.m_HideDockBarList.size()));
        int i = 0;
        while (i < this.m_DockBarList.size()) {
            Element edb = new Element();
            e.addChild(4, (Object)edb);
            edb.setName("DockBar_" + String.valueOf(i));
            edb.setValue("Visible", "1");
            ((DockBar)this.m_DockBarList.get(i)).saveToXML(edb);
            ++i;
        }
        int n = this.m_DockBarList.size();
        int i2 = 0;
        while (i2 < this.m_HideDockBarList.size()) {
            Element edb = new Element();
            e.addChild(4, (Object)edb);
            edb.setName("DockBar_" + String.valueOf(i2 + n));
            edb.setValue("Visible", "0");
            ((DockBar)this.m_HideDockBarList.get(i2)).saveToXML(edb);
            ++i2;
        }
    }

    public static DockBarFrame_ CreateFromXML(Element e) {
        DockBarFrame_ dbf = null;
        Element edb = null;
        DockBar_ db = null;
        String t = e.getValue("DockBarCount");
        int bc = Integer.valueOf(t);
        if (bc > 0) {
            edb = e.getElement("DockBar_0");
            db = DockBar_.CreateFromXML(edb);
            dbf = new DockBarFrame_(db);
            int i = 1;
            while (i < bc) {
                edb = e.getElement("DockBar_" + String.valueOf(i));
                db = DockBar_.CreateFromXML(edb);
                dbf.addBar(db);
                ++i;
            }
        }
        return dbf;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public DockBar getCurrentActiveDockBar() {
        return this.m_CurrentActiveDockBar;
    }

    public ArrayList getDockBarList() {
        return this.m_DockBarList;
    }

    public ArrayList getHideDockBarList() {
        return this.m_HideDockBarList;
    }

    public DockBarTab getTab() {
        return this.m_Tab;
    }

    public DockBarFrameTitle getTitleBar() {
        return this.m_Title;
    }
}

