/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.script.engine;

import IM.util.Tools;
import appletrpc.RPC;
import appletrpc.RPCParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import jun.db.core.DataStore;
import org.kxml.kdom.Element;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.tools.shell.JavaPolicySecurity;
import wiseoa.script.engine.GlobalFunction;
import wiseoa.script.engine.GlobalFunctionI;
import wiseoa.script.engine.OutputPane;

public class ScriptEngine
extends JApplet
implements KeyListener,
GlobalFunctionI {
    JButton jb_Save;
    JavaPolicySecurity PolicySecurity = new JavaPolicySecurity();
    public String HomeURL;
    private JSplitPane Split;
    JEditorPane EditPane;
    OutputPane Out;
    Scriptable scope = null;
    String fileName;
    String Script;
    String globalScript;
    GlobalFunction GF;
    public String currentUserName = "";
    public String currentUserSsoName = "";
    public int currentUserID = -1;
    public int currentUnitID = -1;
    public String currentUnitName = "";
    public int groupIdOfCurrentUser = 0;
    public String groupNameOfCurrentUser = "";
    public String currentUserShowName = "";

    public void init() {
        this.HomeURL = this.getCodeBase().toString();
        if (this.HomeURL.substring(0, 4).equalsIgnoreCase("file")) {
            this.HomeURL = "http://zengjun3:8080/wiseoa/";
        }
    }

    public ScriptEngine() {
        Tools.initAllFontSon9();
        this.EditPane = new JEditorPane();
        this.Out = new OutputPane();
        JPanel jp = new JPanel();
        this.jb_Save = new JButton("\u4fdd\u5b58");
        this.jb_Save.setToolTipText("F2");
        this.jb_Save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ScriptEngine.this.Save()) {
                    Tools.ShowInfo(null, "\u4fdd\u5b58\u6210\u529f\u3002");
                }
            }
        });
        JButton jb_Run = new JButton("\u8fd0\u884c");
        jb_Run.setToolTipText("F9");
        jb_Run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptEngine.this.Run();
            }
        });
        JButton jb_Debug = new JButton("\u8c03\u8bd5");
        jb_Debug.setToolTipText("F10");
        jb_Debug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScriptEngine.this.Debug();
            }
        });
        jp.add(this.jb_Save);
        jp.add(jb_Run);
        JScrollPane sp1 = new JScrollPane(this.EditPane);
        JScrollPane sp2 = new JScrollPane(this.Out);
        this.Split = new JSplitPane(0, sp1, sp2);
        this.Split.setContinuousLayout(true);
        this.Split.setOneTouchExpandable(true);
        this.Split.setDividerLocation(400);
        Container cc = this.getContentPane();
        cc.setLayout(new BorderLayout());
        cc.add((Component)this.Split, "Center");
        cc.add((Component)jp, "North");
        this.addKeyListener(this);
        this.EditPane.addKeyListener(this);
        this.Out.addKeyListener(this);
    }

    public void start() {
        this.fileName = this.getParameter("file");
        RPCParameter p = new RPCParameter();
        p.put("homeurl", this.HomeURL);
        p.put("file", this.fileName);
        p = RPC.Call(String.valueOf(this.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "LoadCurrentInfo", p);
        if (p.Success) {
            this.currentUserID = p.get("currentuserid", -1);
            this.currentUnitID = p.get("currentunitid", -1);
            this.currentUnitName = p.get("currentunitname", "");
            this.currentUserName = p.get("currentusername", "");
            this.currentUserSsoName = p.get("currentuserssoname", "");
            this.currentUserShowName = p.get("currentusershowname", "");
            this.groupIdOfCurrentUser = p.get("groupid", 0);
            this.groupNameOfCurrentUser = p.get("groupname", "");
            this.globalScript = p.get("globalscript", "");
            this.Script = p.get("script", "");
        }
        this.EditPane.setText(this.Script);
        this.EditPane.setCaretPosition(0);
        this.fileName = this.getParameter("file");
        if (this.fileName == null) {
            this.fileName = "exercise" + this.currentUserID + ".js";
        }
        if (!this.fileName.startsWith("exercise")) {
            this.jb_Save.setVisible(false);
        }
        try {
            try {
                Context cx = this.initEngine();
                this.SafeAddScript(cx, this.globalScript);
            }
            catch (Exception exception) {}
        }
        finally {
            Context.exit();
        }
        this.GF = new GlobalFunction(this.HomeURL, this);
    }

    public void stop() {
        super.stop();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            this.Save();
        }
        if (e.getKeyCode() == 120) {
            this.Run();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean Save() {
        RPCParameter p = new RPCParameter();
        p.put("file", this.fileName);
        p.put("source", this.EditPane.getText());
        p = RPC.Call(String.valueOf(this.HomeURL) + "servlet/wiseoa.script.rpc.ScriptEngineRPC", "Save", p);
        return p.Success;
    }

    public Context initEngine() {
        Context cx = Context.enter();
        try {
            cx.setOptimizationLevel(1);
            try {
                cx.setSecurityController((SecurityController)this.PolicySecurity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scope = cx.initStandardObjects();
            Object obj = Context.javaToJS((Object)this, (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"flow", (Object)obj);
            Object wrappedOut = Context.javaToJS((Object)this.Out, (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"out", (Object)wrappedOut);
        }
        catch (Exception e) {
            System.out.println("\u521d\u59cb\u5316\u811a\u672c\u9519\u8bef" + e.getMessage());
        }
        return cx;
    }

    public void Run() {
        block6: {
            Context cx = null;
            try {
                try {
                    cx = Context.enter();
                    String script = this.getScript();
                    this.SafeAddScript(cx, script);
                    Object fObj = this.scope.get("main", this.scope);
                    if (!(fObj instanceof Function)) {
                        System.out.println("  \u4e0d\u5b58\u5728main\u51fd\u6570.");
                        break block6;
                    }
                    Object[] functionArgs = new Object[]{};
                    Function f = (Function)fObj;
                    Object object = f.call(cx, this.scope, this.scope, functionArgs);
                }
                catch (Exception e) {
                    this.Out.println(e.getMessage());
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    public String getScript() {
        return this.EditPane.getText();
    }

    public void Debug() {
    }

    public void SafeAddScript(Context cx, String script) {
        if (script.trim().equals("")) {
            return;
        }
        try {
            cx.evaluateString(this.scope, script, "", 1, null);
        }
        catch (Exception e) {
            this.Out.println("\u5728\u52a0\u8f7d\u811a\u672c\u65f6\u51fa\u9519\uff0c" + e.getMessage());
        }
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public String getCurrentUserSsoName() {
        return this.currentUserSsoName;
    }

    public String getCurrentUserShowName() {
        return this.currentUserShowName;
    }

    public int getCurrentUserId() {
        return this.currentUserID;
    }

    public int getCurrentUnitId() {
        return this.currentUnitID;
    }

    public String getCurrentUnitName() {
        return this.currentUnitName;
    }

    public int getCurrentUserGroupId() {
        return this.groupIdOfCurrentUser;
    }

    public String getCurrentUserGroupName() {
        return this.groupNameOfCurrentUser;
    }

    public void alert(String msg) {
        this.GF.alert(msg);
    }

    public boolean confirm(String msg) {
        return this.GF.confirm(msg);
    }

    public DataStore createDataStore(String dbpool, String sql) {
        return this.GF.createDataStore(dbpool, sql, "", "");
    }

    public DataStore createDataStore(String dbpool, String sql, String dbCharset, String charset) {
        return this.GF.createDataStore(dbpool, sql, dbCharset, charset);
    }

    public void delay(int delay) {
        this.GF.delay(delay);
    }

    public String getStringFromFile(String file) {
        return this.getStringFromFile(file, "GBK");
    }

    public String getStringFromFile(String file, String charset) {
        return this.GF.getStringFromFile(file, charset);
    }

    public Element getXMLConfig(String file) {
        return this.GF.getXMLConfig(file);
    }

    public String newGUID() {
        return this.GF.newGUID();
    }

    public Date newDate() {
        return this.GF.newDate();
    }

    public int random(int n) {
        return this.GF.random(n);
    }

    public void refreshWorkCount() {
        this.GF.refreshWorkCount();
    }

    public String newWork(int flowid, int templateid, int owner, String subject, String querymobile, int level, String rq) {
        return this.GF.newWork(flowid, templateid, owner, subject, querymobile, level, rq);
    }

    public String getUnitProperty(int unit, String propertyName) {
        return this.GF.getUnitProperty(unit, propertyName);
    }
}

