/*
 * Decompiled with CFR 0.152.
 */
package IM.util;

import IM.util.Base64Coder;
import com.sun.org.apache.regexp.internal.RE;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Tools {
    public static void initAllFontSon9() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Font f1 = new Font("SimSun", 0, 12);
        Font f2 = new Font("SimSun", 1, 12);
        Tools.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    public static Image GetImageFromURL(Component Wnd, String imgURL) {
        Applet ContainedByApplet = Tools.ContainedByApplet(Wnd);
        Image img = null;
        URL url = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            url = Wnd.getClass().getClassLoader().getResource(imgURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            img = ContainedByApplet.getImage(url);
            MediaTracker tracker = new MediaTracker(ContainedByApplet);
            tracker.addImage(img, 0);
            tracker.waitForAll();
        }
        catch (Exception e) {
            img = tk.getImage(url);
            MediaTracker tracker = new MediaTracker(Wnd);
            tracker.addImage(img, 0);
            try {
                tracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return img;
    }

    public static Object GetObjectFromServlet(URL url) throws Exception {
        Object ret = null;
        try {
            URLConnection urlcon = url.openConnection();
            urlcon.connect();
            GZIPInputStream gs = new GZIPInputStream(new BufferedInputStream(urlcon.getInputStream()));
            ObjectInputStream p = new ObjectInputStream(gs);
            ret = p.readObject();
            p.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return ret;
    }

    public static void ShowInfo(Component parentComponent, String info) {
        JOptionPane.showMessageDialog(parentComponent, info, "\u63d0\u793a", 2);
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static String FileSize(double fl) {
        DecimalFormat df = new DecimalFormat("###,###,###.0");
        String size = fl < 1024.0 ? "1KB" : (fl < 1048576.0 ? String.valueOf(df.format(fl / 1024.0)) + "KB" : String.valueOf(df.format(fl / 1048576.0)) + "MB");
        return size;
    }

    public static void MoveToScreenCenter(Component jf) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((d.width - jf.getWidth()) / 2, (d.height - jf.getHeight()) / 2);
    }

    public static void Delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String EncryptString(String s, String keys) {
        try {
            byte[] rawKeyData = keys.getBytes();
            SecureRandom sr = new SecureRandom();
            DESKeySpec dks = new DESKeySpec(rawKeyData);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, (Key)key, sr);
            byte[] data = s.getBytes();
            byte[] encryptedData = cipher.doFinal(data);
            return new String(Base64Coder.encode(encryptedData));
        }
        catch (Exception e) {
            return s;
        }
    }

    public static String DecryptString(String s, String keys) {
        try {
            SecureRandom sr = new SecureRandom();
            byte[] rawKeyData = keys.getBytes();
            DESKeySpec dks = new DESKeySpec(rawKeyData);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey key = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, (Key)key, sr);
            byte[] encryptedData = Base64Coder.decode(s.toCharArray());
            byte[] decryptedData = cipher.doFinal(encryptedData);
            return new String(decryptedData);
        }
        catch (Exception e) {
            return s;
        }
    }

    public static StringBuffer HTML2Text(String str) {
        StringBuffer sb = new StringBuffer(1024);
        String s = Tools.ToGBKHTML(str).toString();
        int len = s.length();
        boolean inTag = false;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '<') {
                inTag = true;
            } else if (c == '>') {
                inTag = false;
            } else if (!inTag) {
                sb.append(c);
            }
            ++i;
        }
        return sb;
    }

    public static StringBuffer ToGBKHTML(String s) {
        StringBuffer sb = new StringBuffer(s);
        try {
            ArrayList<Integer> a1 = new ArrayList<Integer>();
            ArrayList<Integer> a2 = new ArrayList<Integer>();
            ArrayList<Integer> a3 = new ArrayList<Integer>();
            ArrayList<Integer> a4 = new ArrayList<Integer>();
            RE r = new RE("&#([0-9]{3,5})\\s*;");
            int startAt = 0;
            while (r.match(s, startAt)) {
                int n = r.getParenCount();
                int p1 = r.getParenStart(0);
                int p2 = r.getParenEnd(0);
                int p3 = r.getParenStart(1);
                int p4 = r.getParenEnd(1);
                startAt = p2;
                a1.add(p1);
                a2.add(p2);
                a3.add(p3);
                a4.add(p4);
            }
            StringBuffer temp = new StringBuffer(10);
            int i = a1.size() - 1;
            while (i >= 0) {
                int p1 = (Integer)a1.get(i);
                int p2 = (Integer)a2.get(i);
                int p3 = (Integer)a3.get(i);
                int p4 = (Integer)a4.get(i);
                temp.delete(0, temp.length());
                temp.append((char)Integer.valueOf(sb.substring(p3, p4)).intValue());
                sb.replace(p1, p2, temp.toString());
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb;
    }

    public static boolean MkDirs(String path) {
        File nextFile = new File(path);
        if (!nextFile.exists()) {
            nextFile.mkdirs();
        }
        return nextFile.exists();
    }
}

