/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.api;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.jco.util.Language;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Locale;
import java.util.Properties;

public final class RfcOptions {
    private Properties properties;
    private String propertyPrefix;
    private String destination = null;
    private char type = (char)63;
    private String sysnr = null;
    private int trace;
    private int cpicTrace;
    private boolean logonCheck = true;
    private byte allocationType = (byte)3;
    private String ashost = null;
    private String gwhost = null;
    private String gwserv = null;
    private String saprouter = null;
    private String user = null;
    private String alias_user = null;
    private String client = null;
    private String language = null;
    private String password = null;
    private int pcs = 1;
    private int useSAPGui = 0;
    private boolean abapDebug = false;
    private String communication_cp = null;
    private String mysapsso2 = null;
    private boolean getsso2 = false;
    private String extid_data = null;
    private String extid_type = null;
    private String x509cert = null;
    private static final int RFC_SNC_MODE_OFF = 0;
    private static final int RFC_SNC_MODE_ON = 1;
    private int snc_mode = 0;
    private int snc_qop = 8;
    private String snc_myname = null;
    private String snc_partnername = null;
    private String snc_lib = null;
    private String r3name = null;
    private String group = null;
    private String mshost = null;
    private String msserv = null;
    private String reg_name = null;
    private String reg_host = null;
    private String reg_path = null;
    private boolean useDeltaManagement = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLogonData() throws RfcException {
        if ('E' == this.type || 'R' == this.type) {
            this.user = "EXTERN";
            this.password = "EXTERN";
            this.language = "E";
            return;
        }
        if (this.type == 'V') {
            return;
        }
        if (null == this.client) {
            throw new RfcException(19, "'client' missing", 101, 0L, true);
        }
        if (this.client.length() == 3) {
            if (this.client.equals("   ")) {
                this.client = "XXX";
            }
        } else {
            char d2;
            if (this.client.length() >= 3) throw new RfcException(19, "'client' needs to be a three digit number string instead of '" + this.client + "'", 101, 0L, true);
            char d1 = this.client.length() != 0 ? (char)this.client.charAt(0) : (char)'0';
            char c = d2 = this.client.length() == 2 ? (char)this.client.charAt(1) : (char)'0';
            if (d1 < 48 || d1 > 57 || d2 < 48 || d2 > 57) throw new RfcException(19, "'client' needs to be a three digit number string instead of '" + this.client + "'", 101, 0L, true);
            this.client = "0" + d1 + d2;
        }
        if (this.user != null) {
            int strlen = this.user.length();
            StringBuilder strBuf = new StringBuilder(strlen);
            for (int i = 0; i < strlen; ++i) {
                strBuf.append(Character.toUpperCase(this.user.charAt(i)));
            }
            this.user = strBuf.toString();
            if (this.password != null || this.snc_mode == 1) return;
            throw new RfcException(19, "'password' missing", 101, 0L, true);
        }
        if (this.alias_user != null) {
            if (this.password != null || this.snc_mode == 1) return;
            throw new RfcException(19, "'password' missing", 101, 0L, true);
        }
        if (this.mysapsso2 == null && this.x509cert == null && this.snc_mode != 1) {
            throw new RfcException(19, "user id is missing: neither user nor user alias nor sso ticket nor certificate is specified", 101, 0L, true);
        }
        this.password = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkParameters() throws RfcException {
        char digit;
        block46: {
            boolean throwException;
            block45: {
                char c;
                int len;
                if ('B' != this.type && 'E' != this.type && 'A' != this.type && 'R' != this.type && '2' != this.type && 'F' != this.type && 'V' != this.type) {
                    String string;
                    if (this.type == '?') {
                        string = "'type' is missing";
                        throw new RfcException(19, string, 101, 0L, true);
                    }
                    string = "'type' not supported: '" + this.type + "'";
                    throw new RfcException(19, string, 101, 0L, true);
                }
                switch (this.type) {
                    case 'F': {
                        this.ashost = "localhost";
                        this.sysnr = JCoRuntime.getProfileParameter("SAPSYSTEM");
                        this.type = (char)65;
                    }
                    case 'A': {
                        if (null == this.ashost) {
                            throw new RfcException(19, "'ashost' is missing", 101, 0L, true);
                        }
                        if (null == this.sysnr) {
                            throw new RfcException(19, "'sysnr' is missing", 101, 0L, true);
                        }
                        if (this.sysnr.length() != 2) {
                            if (this.sysnr.length() != 1) throw new RfcException(19, "'sysnr' needs to be a two digit number string instead of '" + this.sysnr + "'", 101, 0L, true);
                            digit = this.sysnr.charAt(0);
                            if (digit < '0') throw new RfcException(19, "'sysnr' needs to be a two digit number string instead of '" + this.sysnr + "'", 101, 0L, true);
                            if (digit > '9') throw new RfcException(19, "'sysnr' needs to be a two digit number string instead of '" + this.sysnr + "'", 101, 0L, true);
                            this.sysnr = "0" + digit;
                        } else if (this.sysnr.equals("$$")) {
                            this.sysnr = JCoRuntime.getProfileParameter("SAPSYSTEM");
                            if (this.sysnr == null) {
                                throw new RfcException(19, "'$$' as value for 'sysnr' requires SAPSYSTEM to be set in environment", 101, 0L, true);
                            }
                            if (Environment.inJStartup()) {
                                boolean isDoubleStack;
                                String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                                boolean bl = isDoubleStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                                if (!isDoubleStack) {
                                    throw new RfcException(19, "'$$' as value for 'sysnr' is only valid in a double stack environment", 101, 0L, true);
                                }
                            }
                        }
                        if (this.gwserv == null) break block46;
                        throwException = false;
                        len = this.gwserv.length();
                        c = '\u0000';
                        if (len == 4) {
                            break;
                        }
                        if (!this.gwserv.startsWith("sapgw")) break block45;
                        if (this.gwserv.equals("sapgw$$")) {
                            String sysnrProfile = JCoRuntime.getProfileParameter("SAPSYSTEM");
                            if (sysnrProfile == null) {
                                throw new RfcException(19, "'sapgw$$' as value for 'gwserv' requires SAPSYSTEM to be set in environment", 101, 0L, true);
                            }
                            if (Environment.inJStartup()) {
                                boolean isDoubleStack;
                                String instanceName = JCoRuntime.getProfileParameter("INSTANCE_NAME");
                                boolean bl = isDoubleStack = instanceName != null && instanceName.length() > 0 && instanceName.charAt(0) == 'D';
                                if (!isDoubleStack) {
                                    throw new RfcException(19, "'sapgw$$' as value for 'gwserv' is only valid in a double stack environment", 101, 0L, true);
                                }
                            }
                            this.gwserv = "sapgw" + sysnrProfile;
                            break block45;
                        } else {
                            if (len < 7) {
                                throwException = true;
                            }
                            for (int i = 5; i < len; ++i) {
                                c = this.gwserv.charAt(i);
                                if (c >= '0' && c <= '9') continue;
                                throwException = true;
                                break block45;
                            }
                        }
                        break block45;
                    }
                    case 'B': {
                        if (null == this.mshost) {
                            throw new RfcException(19, "'mshost' missing", 101, 0L, true);
                        }
                        if (null == this.r3name) {
                            throw new RfcException(19, "'r3name' missing", 101, 0L, true);
                        }
                        if (null == this.group) {
                            this.group = "PUBLIC";
                        }
                        break block46;
                    }
                    case 'E': 
                    case 'R': {
                        if (Environment.inStandalone()) {
                            throw new RfcException(19, "Communication with RFC server programs is not supported with JCo standalone " + JCo.getVersion(), 101, 0L, true);
                        }
                        this.useDeltaManagement = false;
                        if (null == this.reg_host) {
                            if (this.gwhost == null) throw new RfcException(19, "'tphost' missing", 101, 0L, true);
                            if (this.gwserv == null) throw new RfcException(19, "'tphost' missing", 101, 0L, true);
                            this.type = (char)82;
                        }
                        if (this.type != 'R' && null == this.reg_name) {
                            throw new RfcException(19, "'tpname' missing", 101, 0L, true);
                        }
                        this.reg_path = this.reg_name;
                        break block46;
                    }
                    case '2': {
                        throw new RfcException(19, "type '2' not supported", 101, 0L, true);
                    }
                    case 'V': {
                        break block46;
                    }
                    default: {
                        throw new RfcException(19, "'type' missing or wrong", 101, 0L, true);
                    }
                }
                for (int i = 0; i < len; ++i) {
                    c = this.gwserv.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    throwException = true;
                    break;
                }
            }
            if (throwException) {
                throw new RfcException(19, "Parameter gateway service ('gwserv') needs to be of format #### or sapgw## (# is a digit) instead of '" + this.gwserv + '\'', 101, 0L, true);
            }
        }
        this.checkLogonData();
        switch (this.snc_mode) {
            case 1: {
                if (-1 == this.snc_qop) {
                    throw new RfcException(19, "'snc_qop' missing or invalid", 101, 0L, true);
                }
                if (null == this.snc_myname) {
                    this.snc_myname = " ";
                }
                if (null == this.snc_partnername && this.type != 'B') {
                    throw new RfcException(19, "'snc_partnername' missing", 101, 0L, true);
                }
                if (null != this.snc_lib) break;
                throw new RfcException(19, "'snc_lib' missing", 101, 0L, true);
            }
            case 0: {
                break;
            }
            default: {
                this.snc_mode = 0;
            }
        }
        if (this.pcs != 1 && this.pcs != 2) {
            throw new RfcException(19, "'pcs' missing or wrong", 101, 0L, true);
        }
        if (this.communication_cp == null) return;
        if (this.communication_cp.length() > 4) {
            throw new RfcException(19, "'communication codepage' needs to be a 4 digit number string instead of '" + this.communication_cp + "'", 101, 0L, true);
        }
        int i = 0;
        while (i < this.communication_cp.length()) {
            digit = this.communication_cp.charAt(i);
            if (digit < '0') throw new RfcException(19, "'communication codepage' needs to be a 4 digit number string instead of '" + this.communication_cp + "'", 101, 0L, true);
            if (digit > '9') {
                throw new RfcException(19, "'communication codepage' needs to be a 4 digit number string instead of '" + this.communication_cp + "'", 101, 0L, true);
            }
            ++i;
        }
    }

    public void setProperties(Properties prop, String prefix) throws RfcException {
        String req_cp;
        this.properties = prop;
        this.propertyPrefix = prefix;
        String reader = this.getTrimmedProperty(prop, prefix, "type");
        if (null != reader) {
            this.type = reader.charAt(0);
        }
        this.sysnr = this.getTrimmedProperty(prop, prefix, "sysnr");
        this.trace = 0;
        reader = this.getTrimmedProperty(prop, prefix, "trace");
        if (null != reader && reader.equals("1")) {
            this.trace = 1;
        }
        this.cpicTrace = -1;
        reader = this.getTrimmedProperty(prop, prefix, "cpic_trace");
        if (null != reader) {
            try {
                this.cpicTrace = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.logonCheck = (reader = this.getTrimmedProperty(prop, prefix, "lcheck")) == null || this.toBoolean(reader);
        this.ashost = this.getTrimmedProperty(prop, prefix, "ashost");
        this.gwhost = this.getTrimmedProperty(prop, prefix, "gwhost");
        this.gwserv = this.getTrimmedProperty(prop, prefix, "gwserv");
        this.saprouter = this.getTrimmedProperty(prop, prefix, "saprouter");
        this.user = this.getRightTrimmedProperty(prop, prefix, "user");
        this.alias_user = this.getTrimmedProperty(prop, prefix, "alias_user");
        this.client = this.getTrimmedProperty(prop, prefix, "client");
        this.language = this.getTrimmedProperty(prop, prefix, "lang");
        if (this.language != null) {
            this.setLanguage(this.language);
        }
        this.password = this.getRightTrimmedProperty(prop, prefix, "passwd");
        reader = this.getTrimmedProperty(prop, prefix, "pcs");
        if (null != reader) {
            try {
                this.pcs = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                this.pcs = 1;
            }
        }
        if ((this.type == 'A' || this.type == 'B') && Environment.inStandalone()) {
            reader = this.getTrimmedProperty(prop, prefix, "use_sapgui");
            if (reader != null) {
                try {
                    this.useSAPGui = Integer.parseInt(reader);
                    if (this.useSAPGui < 0) {
                        this.useSAPGui = 0;
                    } else if (this.useSAPGui > 2) {
                        this.useSAPGui = 2;
                    }
                }
                catch (NumberFormatException ex) {
                    this.useSAPGui = 0;
                }
            }
            if ((reader = this.getTrimmedProperty(prop, prefix, "abap_debug")) != null) {
                this.abapDebug = "1".equals(reader);
                if (this.abapDebug) {
                    this.useSAPGui = 1;
                }
            }
        }
        if ((req_cp = this.getTrimmedProperty(prop, prefix, "codepage")) != null && req_cp.length() == 4) {
            this.pcs = req_cp.charAt(0) == '4' && !req_cp.equals("4110") ? 2 : 1;
            this.communication_cp = req_cp;
        }
        reader = this.getTrimmedProperty(prop, prefix, "getsso2");
        this.getsso2 = this.toBoolean(reader);
        this.mysapsso2 = this.getTrimmedProperty(prop, prefix, "mysapsso2");
        reader = this.getTrimmedProperty(prop, prefix, "getsso2");
        this.getsso2 = "1".equals(reader);
        this.extid_data = this.getTrimmedProperty(prop, prefix, "extid_data");
        this.extid_type = this.getTrimmedProperty(prop, prefix, "extid_type");
        this.x509cert = this.getTrimmedProperty(prop, prefix, "x509cert");
        reader = this.getTrimmedProperty(prop, prefix, "snc_mode");
        this.snc_mode = this.toBoolean(reader) ? 1 : 0;
        reader = this.getTrimmedProperty(prop, prefix, "snc_qop");
        if (null != reader) {
            try {
                this.snc_qop = Integer.parseInt(reader);
            }
            catch (NumberFormatException nfe) {
                this.snc_qop = -1;
            }
        }
        this.snc_myname = this.getTrimmedProperty(prop, prefix, "snc_myname");
        this.snc_partnername = this.getTrimmedProperty(prop, prefix, "snc_partnername");
        this.snc_lib = this.getTrimmedProperty(prop, prefix, "snc_lib");
        this.r3name = this.getTrimmedProperty(prop, prefix, "r3name");
        this.group = this.getTrimmedProperty(prop, prefix, "group");
        this.mshost = this.getTrimmedProperty(prop, prefix, "mshost");
        this.msserv = this.getTrimmedProperty(prop, prefix, "msserv");
        this.reg_name = this.getTrimmedProperty(prop, prefix, "tpname");
        this.reg_host = this.getTrimmedProperty(prop, prefix, "tphost");
        reader = this.getTrimmedProperty(prop, prefix, "delta");
        if (null != reader) {
            this.useDeltaManagement = !reader.equals("0");
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onlyConnectionInfo) {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append("TYPE=").append(this.type);
        if (this.destination != null) {
            buf.append(" DEST=").append(this.destination);
        }
        if (!onlyConnectionInfo) {
            if (this.user != null) {
                buf.append(" USER=\"").append(this.user).append('\"');
            }
            if (this.alias_user != null) {
                buf.append(" ALIAS_USER=\"").append(this.alias_user).append('\"');
            }
            if (this.password != null) {
                buf.append(" PASSWD=**********");
            }
            buf.append(" CLIENT=").append(this.client);
            if (this.language != null) {
                buf.append(" LANG=").append(this.language);
            }
        }
        switch (this.type) {
            case 'A': {
                buf.append(" ASHOST=").append(this.ashost).append(" SYSNR=").append(this.sysnr);
                if (this.gwhost == null) break;
                buf.append(" GWHOST=").append(this.gwhost).append(" GWSERV=").append(this.gwserv);
                break;
            }
            case 'B': {
                buf.append(" MSHOST=").append(this.mshost).append(" GROUP=").append(this.group).append(" R3NAME=").append(this.r3name);
                if (this.msserv == null) break;
                buf.append(" MSSERV=" + this.msserv);
                break;
            }
            case 'E': 
            case 'R': {
                buf.append(" GWHOST=").append(this.gwhost);
                buf.append(" TPHOST=").append(this.reg_host);
                buf.append(" GWSERV=").append(this.gwserv).append(" PROGID=").append(this.reg_name);
                break;
            }
        }
        if (this.saprouter != null) {
            buf.append(" SAPROUTER=").append(this.saprouter);
        }
        if (this.snc_mode == 1) {
            buf.append(" SNC_MODE=1 SNC_QOP=").append(Integer.toString(this.snc_qop));
            if (this.snc_myname != null) {
                buf.append(" SNC_MYNAME=\"").append(this.snc_myname).append('\"');
            }
            if (this.snc_partnername != null) {
                buf.append(" SNC_PARTNERNAME=\"").append(this.snc_partnername).append('\"');
            }
        }
        if (!onlyConnectionInfo) {
            if (0 != this.isTrace()) {
                buf.append(" TRACE=" + this.isTrace());
            }
            if (this.isGetsso2()) {
                buf.append(" GETSSO2=true");
            }
            if (this.mysapsso2 != null) {
                buf.append(" MYSAPSSO2=\"").append(this.mysapsso2).append('\"');
            }
            if (this.x509cert != null) {
                buf.append(" X509CERT=\"").append(this.x509cert).append('\"');
            }
        }
        buf.append(" PCS=").append(Integer.toString(this.pcs));
        if (this.abapDebug) {
            buf.append(" ABAP_DEBUG=1");
        }
        if (this.useSAPGui > 0) {
            buf.append(" USE_SAPGUI=").append(this.useSAPGui);
        }
        if (this.communication_cp != null) {
            buf.append(" COMM_CP=").append(this.communication_cp);
        }
        if (!this.useDeltaManagement) {
            buf.append(" DELTA=OFF");
        }
        return buf.toString();
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setSysnr(int sysnrInt) throws RfcException {
        int second = sysnrInt % 10;
        int first = sysnrInt / 10;
        if (first > 10) {
            throw new RfcException(19, new StringBuilder(256).append("'sysnr' needs to be a two digit number string instead of '").append(sysnrInt).append("'").toString(), 101, 0L, true);
        }
        this.sysnr = new StringBuilder(2).append((char)(48 + first)).append((char)(48 + second)).toString();
    }

    public String getSysnr() {
        return this.sysnr;
    }

    public void setAshost(String ashost) {
        this.ashost = ashost;
    }

    public String getAshost() {
        return this.ashost;
    }

    public int isTrace() {
        return this.trace;
    }

    public int getCpicTrace() {
        return this.cpicTrace;
    }

    public String getGwhost() {
        return this.gwhost;
    }

    public String getGwserv() {
        return this.gwserv;
    }

    public String getSaprouter() {
        return this.saprouter;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isGetsso2() {
        return this.getsso2;
    }

    public String getExtid_data() {
        return this.extid_data;
    }

    public String getExtid_type() {
        return this.extid_type;
    }

    public String getX509cert() {
        return this.x509cert;
    }

    public int getSnc_mode() {
        return this.snc_mode;
    }

    public String getSnc_myname() {
        return this.snc_myname;
    }

    public int getSnc_qop() {
        return this.snc_qop;
    }

    public String getSnc_partnername() {
        return this.snc_partnername;
    }

    public String getSnc_lib() {
        return this.snc_lib;
    }

    public String getR3name() {
        return this.r3name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getMshost() {
        return this.mshost;
    }

    public String getMsserv() {
        return this.msserv;
    }

    public String getReg_name() {
        return this.reg_name;
    }

    public String getReg_host() {
        return this.reg_host;
    }

    public String getReg_path() {
        return this.reg_path;
    }

    public char getType() {
        return this.type;
    }

    public String getMysapsso2() {
        return this.getTrimmedProperty(this.properties, this.propertyPrefix, "mysapsso2");
    }

    public String getClient() {
        return this.client;
    }

    public void setLanguage(String language) throws RfcException {
        String tempLanguage = Language.getSAPLanguage(language);
        if (tempLanguage == null) {
            throw new RfcException(1, "Language '" + language + "' is not available", 101, 0L, true);
        }
        this.language = tempLanguage;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPcs() {
        return this.pcs;
    }

    public int getUseSAPGui() {
        return this.useSAPGui;
    }

    public boolean usesAbapDebug() {
        return this.abapDebug;
    }

    public boolean executeLogonCheck() {
        return this.logonCheck;
    }

    public byte getAllocationType() {
        return this.allocationType;
    }

    public void setAllocationType(byte b) {
        this.allocationType = b;
    }

    public String getAlias() {
        return this.alias_user;
    }

    private String findProperty(Properties props, String prefix, String key) {
        String value = props.getProperty(prefix + key);
        if (value == null && (value = props.getProperty(key)) == null) {
            key = key.toUpperCase(Locale.ENGLISH);
            value = props.getProperty(key);
        }
        return value;
    }

    protected boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase(Locale.ENGLISH)).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    protected String getRightTrimmedProperty(Properties props, String prefix, String key) {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = this.rightTrim(value)).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String getTrimmedProperty(Properties props, String prefix, String key) {
        String value = this.findProperty(props, prefix, key);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected String rightTrim(String str) {
        if (str != null) {
            int last;
            int i;
            for (i = last = str.length() - 1; i >= 0 && str.charAt(i) <= ' '; --i) {
            }
            if (i < last) {
                str = str.substring(0, i + 1);
            }
        }
        return str;
    }

    public String getCommunication_cp() {
        return this.communication_cp;
    }

    public boolean isDeltaManagementOn() {
        return this.useDeltaManagement;
    }
}

