/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.support;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.support.AbortException;
import com.sap.conn.jco.support.SimpleDataProviderImpl;
import com.sap.conn.jco.support.Test;
import com.sap.conn.jco.support.TidManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRfcTest {
    private static void runRfcRaiseError(ClientTestConfig cfg) throws Exception {
        cfg.testName = "RFC Raise Error Test";
        cfg.functionName = "RFC_RAISE_ERROR";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
        String method = Test.ask(cfg.out, cfg.in, "Enter method", "2");
        String messageType = Test.ask(cfg.out, cfg.in, "Enter message type", "E");
        String parameter = Test.ask(cfg.out, cfg.in, "Enter parameter (empty - <enter>)", "");
        cfg.function.getImportParameterList().setValue("METHOD", method);
        cfg.function.getImportParameterList().setValue("MESSAGETYPE", messageType);
        cfg.function.getImportParameterList().setValue("PARAMETER", parameter);
        try {
            cfg.function.execute(cfg.clientDestination);
        }
        catch (JCoException e) {
            cfg.out.println("Test success, thrown exception was " + e.toString());
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    private static void runSystemInfo(ClientTestConfig cfg) throws Exception {
        cfg.testName = "System Info";
        cfg.functionName = "RFC_SYSTEM_INFO";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
        JRfcTest.printDestinationInfo(cfg.out, cfg.clientDestination);
        cfg.function.execute(cfg.clientDestination);
        JCoStructure sysInfo = cfg.function.getExportParameterList().getStructure("RFCSI_EXPORT");
        cfg.out.println("");
        cfg.out.println("SAP System information:");
        cfg.out.print("Destination        ");
        cfg.out.println(sysInfo.getString("RFCDEST"));
        cfg.out.print("Host               ");
        cfg.out.println(sysInfo.getString("RFCHOST"));
        cfg.out.print("System ID          ");
        cfg.out.println(sysInfo.getString("RFCSYSID"));
        cfg.out.print("Database           ");
        cfg.out.println(sysInfo.getString("RFCDATABS"));
        cfg.out.print("DB Host            ");
        cfg.out.println(sysInfo.getString("RFCDBHOST"));
        cfg.out.print("DB System          ");
        cfg.out.println(sysInfo.getString("RFCDBSYS"));
        cfg.out.print("SAP Release        ");
        cfg.out.println(sysInfo.getString("RFCSAPRL"));
        if (sysInfo.getMetaData().hasField("RFCKERNRL")) {
            cfg.out.print("SAP Kernel Release ");
            cfg.out.println(sysInfo.getString("RFCKERNRL"));
        }
        cfg.out.print("RFC Protocol       ");
        cfg.out.println(sysInfo.getString("RFCPROTO"));
        cfg.out.print("Characters         ");
        cfg.out.println(sysInfo.getString("RFCCHARTYP"));
        cfg.out.print("Integers           ");
        cfg.out.println(sysInfo.getString("RFCINTTYP"));
        cfg.out.print("Floating P.        ");
        cfg.out.println(sysInfo.getString("RFCFLOTYP"));
        cfg.out.print("SAP Machine Id     ");
        cfg.out.println(sysInfo.getString("RFCMACH"));
        cfg.out.print("Timezone           ");
        cfg.out.println(sysInfo.getString("RFCTZONE"));
        cfg.out.println("");
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    static void prepareTest(ClientTestConfig cfg) throws Exception {
        while (cfg.clientDestination == null) {
            cfg.clientDestinationName = Test.ask(cfg.out, cfg.in, "\nclient destination name (<enter> for exit).....:", "");
            if (cfg.clientDestinationName.length() == 0) {
                throw new AbortException();
            }
            try {
                cfg.clientDestination = JCoDestinationManager.getDestination(cfg.clientDestinationName);
            }
            catch (Exception e) {
                Test.displayException(cfg.out, e);
                cfg.clientDestinationName = null;
            }
        }
        try {
            cfg.rep = cfg.clientDestination.getRepository();
            cfg.function = cfg.rep.getFunction(cfg.functionName);
        }
        catch (Exception ex) {
            cfg.out.println("Preparation for " + cfg.testName + " failed, error message: \n");
            Test.displayException(cfg.out, ex);
            throw ex;
        }
    }

    private static void runConnectionTest(ClientTestConfig cfg) throws Exception {
        cfg.testName = "CONNECTION_TEST";
        cfg.functionName = "STFC_CONNECTION";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
        try {
            String numberOfCallsStr = Test.ask(cfg.out, cfg.in, "Enter numer of calls ", "1");
            cfg.numberOfCalls = Integer.parseInt(numberOfCallsStr);
        }
        catch (Exception e) {
            cfg.numberOfCalls = 1;
        }
        cfg.out.println();
        cfg.out.println("Number of calls " + cfg.numberOfCalls);
        for (int numberOfCall = 0; numberOfCall < cfg.numberOfCalls; ++numberOfCall) {
            JCoParameterList imports = cfg.function.getImportParameterList();
            imports.setValue("REQUTEXT", "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ 1234567890");
            cfg.function.execute(cfg.clientDestination);
            JCoParameterList exports = cfg.function.getExportParameterList();
            cfg.out.println("Import Parameter REQUTEXT: " + imports.getString("REQUTEXT"));
            cfg.out.println("\nExport Parameter ECHOTEXT: " + exports.getString("ECHOTEXT"));
            cfg.out.println("Export Parameter RESPTEXT: " + exports.getString("RESPTEXT"));
            if (cfg.numberOfCalls <= numberOfCall + 1) continue;
            Test.ask(cfg.out, cfg.in, "Hit return key for next RFC call", null);
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    private static void runPerformanceTest(ClientTestConfig cfg) throws Exception {
        cfg.testName = "PERFORMANCE_TEST";
        cfg.functionName = "STFC_PERFORMANCE";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\n         SAP JCo TEST - " + cfg.testName + "  \n\n");
        int LGET0332 = Test.askInt(cfg.out, cfg.in, "Enter the length of the LGET0332 ", 0);
        int LGET1000 = Test.askInt(cfg.out, cfg.in, "Enter the length of the LGET1000 ", 1000);
        int LGIT0332 = Test.askInt(cfg.out, cfg.in, "Enter the length of the LGIT0332 ", 0);
        int LGIT1000 = Test.askInt(cfg.out, cfg.in, "Enter the length of the LGIT1000 ", 1000);
        cfg.numberOfCalls = Test.askInt(cfg.out, cfg.in, "Enter numer of calls ", 1);
        for (int numberOfCall = 0; numberOfCall < cfg.numberOfCalls; ++numberOfCall) {
            JCoParameterList imports = cfg.function.getImportParameterList();
            imports.setValue("LGET0332", LGET0332);
            imports.setValue("LGET1000", LGET1000);
            imports.setValue("LGIT0332", LGIT0332);
            imports.setValue("LGIT1000", LGIT1000);
            imports.setValue("CHECKTAB", "X");
            JCoParameterList tables = cfg.function.getTableParameterList();
            JRfcTest.fillTable(tables.getTable("ITAB0332"), imports.getInt("LGIT0332"));
            JRfcTest.fillTable(tables.getTable("ITAB1000"), imports.getInt("LGIT1000"));
            cfg.function.execute(cfg.clientDestination);
            JCoParameterList exports = cfg.function.getExportParameterList();
            cfg.out.println("Import Parameter CHECKTAB: " + imports.getValue("CHECKTAB"));
            cfg.out.println("Import Parameter LGIT0332: " + imports.getValue("LGIT0332"));
            cfg.out.println("Import Parameter LGIT1000: " + imports.getValue("LGIT1000"));
            cfg.out.println("Import Parameter LGET0332: " + imports.getValue("LGET0332"));
            cfg.out.println("Import Parameter LGET1000: " + imports.getValue("LGET1000"));
            cfg.out.println("\nExport Parameter EXITCODE: " + exports.getValue("EXITCODE"));
            cfg.out.println("Export Parameter TEXT0332: '" + exports.getValue("TEXT0332") + "'");
            cfg.out.println("Export Parameter TEXT1000: '" + exports.getValue("TEXT1000") + "'");
            cfg.out.println();
            cfg.out.println(JRfcTest.checkTable("Export", tables.getTable("ETAB0332"), "0332", imports.getInt("LGET0332"), imports.getString("CHECKTAB")));
            cfg.out.println(JRfcTest.checkTable("Export", tables.getTable("ETAB1000"), "1000", imports.getInt("LGET1000"), imports.getString("CHECKTAB")));
            cfg.out.println(JRfcTest.checkTable("Import", tables.getTable("ITAB0332"), "0332", imports.getInt("LGIT0332"), imports.getString("CHECKTAB")));
            cfg.out.println(JRfcTest.checkTable("Import", tables.getTable("ITAB1000"), "1000", imports.getInt("LGIT1000"), imports.getString("CHECKTAB")));
            if (cfg.numberOfCalls <= numberOfCall + 1) continue;
            Test.ask(cfg.out, cfg.in, "Hit return key for next RFC call", null);
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    private static void runStructureTest(ClientTestConfig cfg) throws Exception {
        cfg.testName = "STRUCTURE_TEST";
        cfg.functionName = "STFC_STRUCTURE";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
        cfg.numberOfCalls = Test.askInt(cfg.out, cfg.in, "Enter numer of calls ", 1);
        for (int numberOfCall = 0; numberOfCall < cfg.numberOfCalls; ++numberOfCall) {
            JCoStructure istruct = cfg.function.getImportParameterList().getStructure("IMPORTSTRUCT");
            istruct.setValue("RFCFLOAT", 1000000.0);
            istruct.setValue("RFCCHAR1", "A");
            istruct.setValue("RFCINT2", 1000);
            istruct.setValue("RFCINT1", 10);
            istruct.setValue("RFCCHAR4", "EXT.");
            istruct.setValue("RFCINT4", 100000);
            istruct.setValue("RFCHEX3", new byte[]{49, 50, 51});
            istruct.setValue("RFCCHAR2", "BC");
            istruct.setValue("RFCTIME", "124500");
            istruct.setValue("RFCDATE", "19960924");
            istruct.setValue("RFCDATA1", "01234567890123456789012345678901234567890123456789");
            istruct.setValue("RFCDATA2", "01234567890123456789012345678901234567890123456789");
            JCoTable tab = cfg.function.getTableParameterList().getTable("RFCTABLE");
            tab.copyFrom(istruct);
            cfg.function.execute(cfg.clientDestination);
            cfg.out.println("Import Parameter IMPORTSTRUCT:\n");
            JRfcTest.displayParameters(cfg.out, cfg.function.getImportParameterList(), 0, true);
            cfg.out.println("\nExport Parameter ECHOSTRUCT:\n");
            JRfcTest.displayParameters(cfg.out, cfg.function.getExportParameterList(), 0, true);
            cfg.out.println("\nInternal Table RFCTABLE:");
            JRfcTest.displayParameters(cfg.out, cfg.function.getTableParameterList(), 0, true);
            if (cfg.numberOfCalls <= numberOfCall + 1) continue;
            Test.ask(cfg.out, cfg.in, "Hit return key for next RFC call", null);
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTranRfcTest(ClientTestConfig cfg) throws Exception {
        TidManager tidManager = new TidManager("trfctest.tid");
        cfg.testName = "TRANSACTIONAL_RFC";
        cfg.functionName = "STFC_WRITE_TO_TCPIC";
        JRfcTest.prepareTest(cfg);
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
        cfg.numberOfCalls = Test.askInt(cfg.out, cfg.in, "Enter numer of calls ", 1);
        for (int numberOfCall = 0; numberOfCall < cfg.numberOfCalls; ++numberOfCall) {
            Object var6_6;
            JCoTable tcpicdat = cfg.function.getTableParameterList().getTable("TCPICDAT");
            for (int i = 0; i < 10; ++i) {
                tcpicdat.appendRow();
                tcpicdat.setValue("LINE", new StringBuffer("Line No ").append(i).append(" ASYN-Test - ").append(numberOfCall).append(" :  12345678901234567890123456789012").toString());
            }
            String tid = cfg.clientDestination.createTID();
            tidManager.update_TID(tid, "CREATED");
            try {
                cfg.function.execute(cfg.clientDestination, tid);
                var6_6 = null;
                tidManager.update_TID(tid, "CONFIRMED");
            }
            catch (Throwable throwable) {
                var6_6 = null;
                tidManager.update_TID(tid, "CONFIRMED");
                cfg.clientDestination.confirmTID(tid);
                throw throwable;
            }
            cfg.clientDestination.confirmTID(tid);
            if (cfg.numberOfCalls <= numberOfCall + 1) continue;
            Test.ask(cfg.out, cfg.in, "Hit return key for next RFC call", null);
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + " finished \n\n");
    }

    private static void xrunGenericCall(ClientTestConfig cfg) throws Exception {
        cfg.testName = "Generic call";
        cfg.functionName = "RFC_PING";
        JRfcTest.prepareTest(cfg);
        String functionName = null;
        while (functionName == null) {
            functionName = Test.ask(cfg.out, cfg.in, "Which function module you'd like test? ('exit' for exit)", cfg.functionName);
            if (functionName.equalsIgnoreCase("exit")) {
                throw new AbortException();
            }
            try {
                JCoFunction function;
                cfg.function = function = cfg.rep.getFunction(functionName);
                cfg.functionName = functionName;
            }
            catch (JCoException e) {
                if (e.getGroup() != 123) {
                    throw e;
                }
                cfg.out.println("Error: the function " + functionName + " was not found in " + cfg.rep.getName());
                functionName = null;
            }
        }
        cfg.out.println("\n\nSAP JCo TEST - " + cfg.testName + "  \n\n");
    }

    static void displayParameters(ClientTestConfig cfg, boolean importsOnly, boolean modify) {
    }

    private static void printDestinationInfo(PrintWriter out, JCoDestination d) {
        out.println("Destiantion information:");
        out.print("destination ");
        out.println(d.getDestinationName());
        out.print("type        ");
        out.println("" + d.getType());
        if (d.getClient() != null) {
            out.print("client      ");
            out.println(d.getClient());
        }
        if (d.getUser() != null) {
            out.print("user        ");
            out.println(d.getUser());
        }
        if (d.getAliasUser() != null) {
            out.print("alias user  ");
            out.println(d.getAliasUser());
        }
        if (d.getLanguage() != null) {
            out.print("language    ");
            out.println(d.getLanguage());
        }
        if (d.getLogonCheck() != null) {
            out.print("logon check ");
            out.println(d.getLogonCheck());
        }
        if (d.getApplicationServerHost() != null) {
            out.print("ashost      ");
            out.println(d.getApplicationServerHost());
        }
        if (d.getSystemNumber() != null) {
            out.print("sysnr       ");
            out.println(d.getSystemNumber());
        }
        if (d.getMessageServerHost() != null) {
            out.print("mshost      ");
            out.println(d.getMessageServerHost());
        }
        if (d.getMessageServerService() != null) {
            out.print("msserv      ");
            out.println(d.getMessageServerService());
        }
        if (d.getLogonGroup() != null) {
            out.print("group       ");
            out.println(d.getLogonGroup());
        }
        if (d.getR3Name() != null) {
            out.print("r3name      ");
            out.println(d.getR3Name());
        }
        if (d.getGatewayHost() != null) {
            out.print("gwhost      ");
            out.println(d.getGatewayHost());
        }
        if (d.getGatewayService() != null) {
            out.print("gwserv      ");
            out.println(d.getGatewayService());
        }
    }

    private static String checkTable(String iType, JCoTable tab, String type, int len, String checkTab) {
        int numberOfRows = tab.getNumRows();
        String returnMess = iType + " table (length " + type + "):";
        if (numberOfRows != len) {
            returnMess = returnMess + "  ERROR:  #Lines = " + numberOfRows + "  Expected: " + len;
        } else if (!checkTab.toUpperCase().equals("Y")) {
            returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: NO CHECK";
        } else {
            if (!tab.isEmpty()) {
                String field = "";
                int pos = 0;
                int value = 0;
                for (int i = 0; i < numberOfRows; ++i) {
                    tab.setRow(i);
                    for (int j = 0; j < tab.getNumColumns(); ++j) {
                        int expectValue;
                        int currPos;
                        field = tab.getString(j);
                        pos = j == 0 ? 40 : 0;
                        for (int k = pos; k < field.length(); ++k) {
                            value = k % 10;
                            if (field.substring(k, k + 1).equals(String.valueOf(value))) continue;
                            returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + k + ":  " + field.substring(k, k + 1) + "/" + value;
                            return returnMess;
                        }
                        if (field.length() >= tab.getMetaData().getLength(j)) continue;
                        if (j == 0 && field.length() < 40) {
                            currPos = 40;
                            expectValue = 0;
                        } else {
                            currPos = field.length();
                            expectValue = field.length() % 10;
                        }
                        returnMess = returnMess + " ERROR at line " + (i + 1) + " position " + currPos + ":   /" + expectValue;
                        return returnMess;
                    }
                }
            }
            returnMess = returnMess + "  #Lines = " + numberOfRows + ": OK,  Contents: OK";
        }
        return returnMess;
    }

    private static void fillTable(JCoTable tab, int len) {
        if (len < 1) {
            return;
        }
        tab.deleteAllRows();
        tab.appendRows(len);
        for (int i = 0; i < len; ++i) {
            tab.setRow(i);
            String field = "Line Length: " + tab.getRecordMetaData().getRecordLength() + " Line No.: " + (i + 1);
            for (int j = field.length(); j < 40; ++j) {
                field = field + " ";
            }
            int pos = 0;
            for (int j = 0; j < tab.getNumColumns(); ++j) {
                if (j == 0) {
                    pos = 40;
                } else {
                    pos = 0;
                    field = "";
                }
                for (int k = pos; k < tab.getMetaData().getLength(j); ++k) {
                    field = field + String.valueOf(k % 10);
                }
                tab.setValue(j, field);
            }
        }
    }

    protected static void displayParameters(PrintWriter out, JCoRecord input, int index, boolean displayText) {
        switch (input.getMetaData().getType(index)) {
            case 17: {
                JCoStructure struct = input.getStructure(index);
                for (int j = 0; j < struct.getFieldCount(); ++j) {
                    JRfcTest.displayParameters(out, struct, j, displayText);
                }
                break;
            }
            case 99: {
                JCoTable table = input.getTable(index);
                if (table.isEmpty()) break;
                table.firstRow();
                for (int i = 0; i < table.getNumRows(); ++i) {
                    if (displayText) {
                        out.println("\nLine No.: " + (i + 1));
                    }
                    for (int j = 0; j < table.getNumColumns(); ++j) {
                        JRfcTest.displayParameters(out, table, j, displayText);
                    }
                    table.nextRow();
                }
                break;
            }
            case -1: {
                out.println("Parameter " + input.getMetaData().getName(index) + " has invalid type " + input.getMetaData().getType(index));
                break;
            }
            default: {
                if (displayText) {
                    out.println(input.getMetaData().getName(index) + ": " + input.getString(index));
                    break;
                }
                out.println(input.getString(index));
            }
        }
    }

    private static List<Method> getAvailableTests() {
        Method[] methods = JRfcTest.class.getDeclaredMethods();
        ArrayList<Method> availableTests = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("run")) continue;
            availableTests.add(methods[i]);
        }
        return availableTests;
    }

    private static String askForTestDestination(ClientTestConfig cfg, SimpleDataProviderImpl ddpi) {
        List<String> availableDests = ddpi.getAvailableClientDestinations();
        String destName = null;
        while (destName == null) {
            if (!availableDests.isEmpty()) {
                cfg.out.println("   Available destinations are:");
                cfg.out.print("   ");
                Iterator<String> availableDestIt = availableDests.iterator();
                while (availableDestIt.hasNext()) {
                    cfg.out.print(availableDestIt.next());
                    if (!availableDestIt.hasNext()) continue;
                    cfg.out.print(",");
                }
                cfg.out.println();
            }
            if ((destName = Test.ask(cfg.out, cfg.in, "Enter the destination name:", cfg.clientDestinationName)).length() <= 0) continue;
            try {
                JCoDestination dest;
                cfg.clientDestination = dest = JCoDestinationManager.getDestination(destName);
                cfg.clientDestinationName = destName;
            }
            catch (JCoException e) {
                cfg.out.println("Cannot use destination " + destName + ", because of");
                Test.displayException(cfg.out, e);
                destName = null;
            }
        }
        return destName;
    }

    private static void startUI(ClientTestConfig cfg, SimpleDataProviderImpl ddpi) {
        List<Method> availableTests = JRfcTest.getAvailableTests();
        String answer = "";
        while (!answer.equalsIgnoreCase("E")) {
            if (answer.length() > 0) {
                try {
                    if (answer.charAt(0) == 'C' || answer.charAt(0) == 'c') {
                        JRfcTest.config(cfg);
                    } else {
                        int testNumber = Integer.parseInt(answer) - 1;
                        Method test = availableTests.get(testNumber);
                        cfg.out.println();
                        cfg.out.println("Test: " + test.getName().substring("run".length()));
                        JRfcTest.askForTestDestination(cfg, ddpi);
                        test.invoke(null, cfg);
                    }
                }
                catch (InvocationTargetException e) {
                    cfg.out.println();
                    Test.displayException(cfg.out, e.getTargetException());
                    cfg.out.println();
                    answer = "";
                }
                catch (Exception e) {
                    cfg.out.println();
                    Test.displayException(cfg.out, e);
                    cfg.out.println();
                    answer = "";
                }
            }
            cfg.out.println();
            cfg.out.println("***********************************************");
            cfg.out.println("*   Test cases for the client communication   *");
            cfg.out.println("***********************************************");
            cfg.out.println();
            int testIdx = 0;
            for (Method testMethod : availableTests) {
                String testName = testMethod.getName().substring("run".length());
                cfg.out.print(++testIdx);
                cfg.out.print(": ");
                cfg.out.println(testName);
            }
            cfg.out.println("C: configuration");
            cfg.out.println("E: exit");
            answer = Test.ask(cfg.out, cfg.in, "choose a test, <C> for config or <E> for exit", "E");
        }
    }

    private static void config(ClientTestConfig cfg) {
        String answer = "";
        String jcoTraceLevelCurr = JCo.getProperty("jco.trace_level");
        String jcoTracePathCurr = JCo.getProperty("jco.trace_path");
        String jrfcTraceLevelCurr = JCo.getMiddlewareProperty("jrfc.trace");
        String cpicTraceLevelCurr = JCo.getMiddlewareProperty("cpic.trace");
        if (jcoTraceLevelCurr == null) {
            jcoTraceLevelCurr = "0";
        }
        if (jcoTracePathCurr == null) {
            jcoTracePathCurr = ".";
        }
        if (jrfcTraceLevelCurr == null) {
            jrfcTraceLevelCurr = "0";
        }
        if (cpicTraceLevelCurr == null) {
            cpicTraceLevelCurr = "0";
        }
        while (!answer.equalsIgnoreCase("R")) {
            if (answer.length() > 0) {
                if (answer.charAt(0) == '1') {
                    cfg.out.println();
                    answer = Test.ask(cfg.out, cfg.in, "enter JCo trace level", jcoTraceLevelCurr);
                    try {
                        int level = Integer.parseInt(answer);
                        if (level < 0 || level > 10) {
                            throw new RuntimeException("level " + level + " is out of range. allowed are [0..10]");
                        }
                        JCo.setProperty("jco.trace_level", answer);
                    }
                    catch (Exception e) {
                        cfg.out.println();
                        cfg.out.println("Exception thrown for your input (" + e.toString() + ")");
                    }
                } else if (answer.charAt(0) == '2') {
                    cfg.out.println();
                    answer = Test.ask(cfg.out, cfg.in, "enter JCo trace path", jcoTracePathCurr);
                    try {
                        JCo.setProperty("jco.trace_path", answer);
                    }
                    catch (Exception e) {
                        cfg.out.println();
                        cfg.out.println("Exception thrown for your input (" + e.toString() + ")");
                    }
                } else if (answer.charAt(0) == '3') {
                    cfg.out.println();
                    answer = Test.ask(cfg.out, cfg.in, "enter RFC trace level", jrfcTraceLevelCurr);
                    try {
                        int level = Integer.parseInt(answer);
                        if (level < 0 || level > 1) {
                            throw new RuntimeException("level " + level + " is out of range. allowed are [0..1]");
                        }
                        JCo.setMiddlewareProperty("jrfc.trace", answer);
                    }
                    catch (Exception e) {
                        cfg.out.println();
                        cfg.out.println("Exception thrown for your input (" + e.toString() + ")");
                    }
                } else if (answer.charAt(0) == '4') {
                    cfg.out.println();
                    answer = Test.ask(cfg.out, cfg.in, "enter CPIC trace level", cpicTraceLevelCurr);
                    try {
                        int level = Integer.parseInt(answer);
                        if (level < 0 || level > 3) {
                            throw new RuntimeException("level " + level + " is out of range. allowed are [0..3]");
                        }
                        JCo.setMiddlewareProperty("cpic.trace", answer);
                    }
                    catch (Exception e) {
                        cfg.out.println();
                        cfg.out.println("Exception thrown for your input (" + e.toString() + ")");
                    }
                }
            }
            jcoTraceLevelCurr = JCo.getProperty("jco.trace_level");
            jcoTracePathCurr = JCo.getProperty("jco.trace_path");
            jrfcTraceLevelCurr = JCo.getMiddlewareProperty("jrfc.trace");
            cpicTraceLevelCurr = JCo.getMiddlewareProperty("cpic.trace");
            if (jcoTraceLevelCurr == null) {
                jcoTraceLevelCurr = "0";
            }
            if (jcoTracePathCurr == null) {
                jcoTracePathCurr = "not specified => stdout";
            }
            if (jrfcTraceLevelCurr == null) {
                jrfcTraceLevelCurr = "0";
            }
            if (cpicTraceLevelCurr == null) {
                cpicTraceLevelCurr = "0";
            }
            answer = "";
            cfg.out.println();
            cfg.out.println("***********************************************");
            cfg.out.println("*   Test cases for the client communication   *");
            cfg.out.println("***********************************************");
            cfg.out.println();
            cfg.out.println("1. JCo trace level [" + jcoTraceLevelCurr + "]");
            cfg.out.println("2. JCo trace path [" + jcoTracePathCurr + "]");
            cfg.out.println("3. RFC trace level [" + jrfcTraceLevelCurr + "]");
            cfg.out.println("4. CPIC trace level [" + cpicTraceLevelCurr + "]");
            cfg.out.println();
            cfg.out.println("R - return to the main menu");
            answer = Test.ask(cfg.out, cfg.in, "enter a number or <R> to return", "R");
        }
    }

    public static void main(String[] a) throws Exception {
        PrintWriter out = new PrintWriter(System.out, true);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        SimpleDataProviderImpl ddpi = new SimpleDataProviderImpl(out, in);
        Environment.registerDestinationDataProvider(ddpi);
        Environment.registerServerDataProvider(ddpi);
        ClientTestConfig cfg = new ClientTestConfig();
        cfg.out = out;
        cfg.in = in;
        JRfcTest.startUI(cfg, ddpi);
    }

    private static class ClientTestConfig {
        String testName;
        int numberOfCalls;
        JCoDestination clientDestination;
        String clientDestinationName;
        JCoRepository rep = null;
        JCoFunction function = null;
        String functionName = null;
        PrintWriter out;
        BufferedReader in;
        int jcoTraceLevel;

        private ClientTestConfig() {
        }
    }
}

