/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleSessionRefProvider
implements SessionReferenceProvider {
    static final String CLIENT_TYPE = "%%CLIENT";
    static final String SERVER_TYPE = "%%SERVER";
    final Map<String, Thread> activeSessions = Collections.synchronizedMap(new HashMap());
    private ThreadLocalSessionReference threadLocalSessionRef = new ThreadLocalSessionReference();
    private HashMap<String, SessionReference> referenceCache = new HashMap();

    public JCoSessionReference getCurrentSessionReference(String scopeType) {
        SessionReference ref = (SessionReference)this.threadLocalSessionRef.get();
        if (ref == null) {
            ref = this.startSession(CLIENT_TYPE);
            if (scopeType != null) {
                ref.push(scopeType);
            }
        }
        return ref;
    }

    public boolean isSessionAlive(String sessionId) {
        Thread thread = this.activeSessions.get(sessionId);
        if (!thread.isAlive()) {
            this.activeSessions.remove(sessionId);
            return false;
        }
        return true;
    }

    SessionReference startSession(String type) {
        SessionReference ref = (SessionReference)this.threadLocalSessionRef.get();
        if (ref == null) {
            ref = new SessionReference(this);
            this.threadLocalSessionRef.set(ref);
        }
        ref.push(type);
        assert (ref.getStackSize() > 0);
        return ref;
    }

    SessionReference endSession(String type) {
        SessionReference ref = (SessionReference)this.threadLocalSessionRef.get();
        if (ref != null && ref.pop(type) < 0) {
            this.threadLocalSessionRef.set(null);
        }
        return ref;
    }

    public void jcoServerSessionContinued(String sessionID) {
        SessionReference ref = this.referenceCache.get(sessionID);
        this.threadLocalSessionRef.set(ref);
    }

    public void jcoServerSessionFinished(String sessionID) {
        this.endSession(SERVER_TYPE);
    }

    public void jcoServerSessionPassivated(String sessionID) {
        SessionReference ref = (SessionReference)this.threadLocalSessionRef.get();
        if (ref != null) {
            this.referenceCache.put(ref.getID(), ref);
            this.threadLocalSessionRef.set(null);
        }
    }

    public JCoSessionReference jcoServerSessionStarted() {
        SessionReference ref = this.startSession(SERVER_TYPE);
        return ref;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadLocalSessionReference
    extends ThreadLocal<SessionReference> {
        private ThreadLocalSessionReference() {
        }

        @Override
        public void set(SessionReference value) {
            SessionReference curSession = (SessionReference)this.get();
            if (curSession != null) {
                SimpleSessionRefProvider.this.activeSessions.remove(curSession.getID());
            }
            if (value != null) {
                SimpleSessionRefProvider.this.activeSessions.put(value.getID(), Thread.currentThread());
            }
            super.set(value);
        }
    }

    static final class SessionReference
    implements JCoSessionReference {
        private static long sessionCounter = 0L;
        private String ID;
        private SimpleSessionRefProvider provider;
        private ArrayList<String> stack = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SessionReference(SimpleSessionRefProvider provider) {
            long counter;
            this.provider = provider;
            SessionReference sessionReference = this;
            synchronized (sessionReference) {
                counter = ++sessionCounter;
            }
            this.ID = "Thr-" + Thread.currentThread().getId() + "-" + counter;
        }

        int pop(String type) {
            int level = this.stack.size() - 1;
            if (level >= 0 && this.stack.get(level).equals(type)) {
                this.stack.remove(level);
            }
            return level;
        }

        int push(String type) {
            int level = this.stack.size() - 1;
            if (level < 0 || !this.stack.get(level).equals(type)) {
                this.stack.add(type);
            }
            return this.stack.size() - 1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("Session Reference ").append(this.ID).append(" stack length ").append(this.stack.size());
            sb.append(" [");
            for (String stackEntry : this.stack) {
                sb.append(stackEntry);
            }
            sb.append("]");
            return sb.toString();
        }

        int getStackSize() {
            return this.stack.size();
        }

        public void contextFinished() {
            this.provider.endSession(SimpleSessionRefProvider.CLIENT_TYPE);
        }

        public void contextStarted() {
            this.provider.startSession(SimpleSessionRefProvider.CLIENT_TYPE);
        }

        public String getID() {
            return this.ID;
        }
    }
}

