/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco;

public class JCoException
extends Exception {
    static final long serialVersionUID = 20050909001L;
    public static final int JCO_ERROR_PROGRAM = 101;
    public static final int JCO_ERROR_CONFIGURATION = 101;
    public static final int JCO_ERROR_COMMUNICATION = 102;
    public static final int JCO_ERROR_LOGON_FAILURE = 103;
    public static final int JCO_ERROR_SYSTEM_FAILURE = 104;
    public static final int JCO_ERROR_APPLICATION_EXCEPTION = 105;
    public static final int JCO_ERROR_RESOURCE = 106;
    public static final int JCO_ERROR_PROTOCOL = 107;
    public static final int JCO_ERROR_INTERNAL = 108;
    public static final int JCO_ERROR_CANCELLED = 109;
    public static final int JCO_ERROR_STATE_BUSY = 110;
    public static final int JCO_ERROR_ABAP_CLASS_EXCEPTION = 111;
    public static final int JCO_ERROR_REQUEST_CANCELLED = 112;
    public static final int JCO_ERROR_EXTENSION = 120;
    public static final int JCO_ERROR_NULL_HANDLE = 121;
    public static final int JCO_ERROR_CONVERSION = 122;
    public static final int JCO_ERROR_FUNCTION_NOT_FOUND = 123;
    public static final int JCO_ERROR_ILLEGAL_TID = 124;
    public static final int JCO_ERROR_UNSUPPORTED_CODEPAGE = 125;
    public static final int JCO_ERROR_ABAP_EXCEPTION = 126;
    public static final int JCO_ERROR_FIELD_NOT_FOUND = 127;
    public static final int JCO_ERROR_NOT_SUPPORTED = 128;
    public static final int JCO_ERROR_SERVER_STARTUP = 129;
    public static final int JCO_ERROR_XML_PARSER = 130;
    public static final int JCO_ERROR_ILLEGAL_ARGUMENT = 131;
    public static final int JCO_ERROR_CONCURRENT_CALL = 132;
    public static final int JCO_ERROR_INVALID_HANDLE = 133;
    public static final int JCO_ERROR_INITIALIZATION = 134;
    public static final int JCO_ERROR_TIMEOUT = 135;
    public static final int JCO_ERROR_ILLEGAL_STATE = 136;
    public static final int JCO_ERROR_CONTEXT_NOT_FOUND = 137;
    public static final int JCO_ERROR_DSR_LOAD_ERROR = 150;
    public static final int JCO_ERROR_DSR_PASSPORT_NOT_RECEIVED = 151;
    public static final int JCO_ERROR_DSR_PASSPORT_NOT_VALID = 152;
    public static final int JCO_ERROR_SESSION_REF_NOT_VALID = 153;
    public static final int JCO_ERROR_JARM_LOAD_ERROR = 155;
    public static final int JCO_ERROR_SHAREABLE_CONTAINER = 160;
    public static final int JCO_ERROR_CREATE_SESSION = 170;
    public static final int JCO_ERROR_PASSIVATE_SESSION = 171;
    public static final int JCO_ERROR_RESTORE_SESSION = 172;
    public static final int JCO_ERROR_DESTINATION_DATA_INVALID = 180;
    public static final int JCO_ERROR_SERVER_DATA_INVALID = 181;
    private int group;
    private String key;
    private String remoteSystemInfo;
    private String messageClass;
    private char messageType;
    private String messageNumber;
    private String[] messageParameters;

    public JCoException(int group, String key, String message) {
        this(group, key, message, null, '\u0000', null, null, null, null);
    }

    public JCoException(int group, String key, String message, Throwable cause) {
        this(group, key, message, null, '\u0000', null, null, cause, null);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters) {
        this(group, key, message, messageClass, messageType, messageNumber, messageParameters, null, null);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters, Throwable cause) {
        this(group, key, message, messageClass, messageType, messageNumber, messageParameters, cause, null);
    }

    public JCoException(int group, String key, String message, String messageClass, char messageType, String messageNumber, String[] messageParameters, Throwable cause, String raisedBy) {
        super(message, cause);
        this.key = key;
        this.group = group;
        this.messageClass = messageClass;
        this.messageType = messageType;
        this.messageNumber = messageNumber;
        if (messageParameters != null) {
            this.messageParameters = new String[4];
            System.arraycopy(messageParameters, 0, this.messageParameters, 0, Math.min(messageParameters.length, this.messageParameters.length));
        }
        this.remoteSystemInfo = raisedBy;
    }

    public final int getGroup() {
        return this.group;
    }

    public final String getKey() {
        return this.key;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public String getMessageText() {
        if (this.messageParameters != null) {
            StringBuffer buf = new StringBuffer(256);
            for (int i = 0; i < this.messageParameters.length; ++i) {
                if (this.messageParameters[i] == null) continue;
                buf.append(this.messageParameters[i]);
            }
            return buf.toString();
        }
        return null;
    }

    public String getMessageParameter(int index) {
        if (index < 0 || index > 3) {
            throw new IndexOutOfBoundsException("Message parameter " + index + " is not available. Valid range is 0-3");
        }
        if (this.messageParameters != null) {
            return this.messageParameters[index];
        }
        return null;
    }

    public String[] getMessageParameters() {
        if (this.messageParameters != null) {
            String[] returnMessageParameters = new String[4];
            System.arraycopy(this.messageParameters, 0, returnMessageParameters, 0, 4);
            return returnMessageParameters;
        }
        return null;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append(": (").append(this.group).append(") ");
        buffer.append(this.key).append(": ").append(this.getMessage());
        if (this.messageType == 'X' && "00".equals(this.messageClass) && "341".equals(this.messageNumber)) {
            if (this.messageParameters != null && this.messageParameters[0] != null) {
                buffer.append(" (Remote shortdump: ").append(this.messageParameters[0]);
            }
            if (this.remoteSystemInfo != null) {
                buffer.append(" in system ").append(this.remoteSystemInfo);
            }
            buffer.append(')');
        } else if (this.remoteSystemInfo != null) {
            if (this.group == 104) {
                buffer.append(" (raised by system ");
            } else {
                buffer.append(" (remote system is ");
            }
            buffer.append(this.remoteSystemInfo).append(')');
        }
        return buffer.toString();
    }
}

