/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Message
implements Serializable {
    public static final int CMD_NOUSE = 0;
    public static final int CMD_TellServerMyID = 10;
    public static final int CMD_TellServerMyState = 20;
    public static final int CMD_NotifyClientSomeoneState = 30;
    public static final int CMD_SystemBroadcast = 50;
    public static final int CMD_SendMessage = 60;
    public static final int CMD_BroadcastMessage = 70;
    public static final int CMD_QueryMyFriendsState = 80;
    public static final int CMD_TIP = 90;
    public static final int CMD_CanNotFeedback = 100;
    public static final int CMD_ReceiveMessage = 110;
    public static final int CMD_UploadFile = 120;
    public static final int CMD_UploadFileProgress = 130;
    public static final int CMD_SendFile = 140;
    public static final int CMD_SendFileCancel = 150;
    public static final int CMD_SendFileAccept = 160;
    public static final int CMD_SendFileReject = 170;
    public static final int CMD_SendFileHalt = 190;
    public static final int CMD_SendFileOver = 200;
    public static final int CMD_SendFileProgress = 210;
    public static final int CMD_KeyTyped = 220;
    public static final int CMD_SendAction = 230;
    public static final int CMD_ReceiveAction = 240;
    public static final int CMD_SendFileAutoAccept = 250;
    public static final int CMD_BeforcedIntoShutdown = 260;
    public static final int CMD_BeforcedIntoShutdownIKnow = 270;
    public static final int CMD_YouCanLogin = 280;
    public static final int CMD_BeforcedIntoShutdownReject = 290;
    public static final int CMD_YouNeednotLogin = 300;
    public static final int CMD_ServerShutdown = 310;
    public static final int CMD_Ping = 320;
    public static final int CMD_AutoSendFileRequest = 330;
    public static final int CMD_AutoSendFileRequestPermit = 370;
    public static final int CMD_SendFileRedirectToKnowledgeBase = 380;
    public static final int CMD_TellServerMyID_Again = 390;
    public static final int CMD_Logout = 400;
    public static final String TYPE_CHAT = "chat";
    public int msgType;
    public int msgSender;
    public ArrayList msgReceiver;
    public String msgBody;
    public HashMap msgTag;

    public Message(int type, int sender, ArrayList receiver, String body) {
        this.Init(type, sender, receiver, body, null);
    }

    public Message(int type, int sender, ArrayList receiver, String body, HashMap tag) {
        this.Init(type, sender, receiver, body, tag);
    }

    private void Init(int type, int sender, ArrayList receiver, String body, HashMap tag) {
        this.msgType = type;
        this.msgSender = sender;
        this.msgReceiver = receiver;
        this.msgBody = body;
        this.msgTag = tag;
        if (tag == null) {
            this.msgTag = new HashMap();
        }
    }

    public static Message Decoder(byte[] b) {
        Message ret = new Message(-1, 0, null, "");
        if (b == null) {
            return ret;
        }
        if (b.length == 0) {
            return ret;
        }
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(b);
            GZIPInputStream gs = new GZIPInputStream(bi);
            ObjectInputStream p = new ObjectInputStream(gs);
            ret = (Message)p.readObject();
            p.close();
            return ret;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ret;
        }
    }

    public byte[] Encode() {
        byte[] ret = new byte[]{};
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(new GZIPOutputStream(bo));
            os.writeObject(this);
            os.flush();
            os.close();
            byte[] byArray = ret = bo.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            bo = null;
        }
    }

    public String ExtractValue(String varName) {
        int p1 = this.msgBody.indexOf("<" + varName + ">");
        if (p1 < 0) {
            return "";
        }
        int p2 = this.msgBody.indexOf("</" + varName + ">");
        if (p2 < 0) {
            return "";
        }
        return this.msgBody.substring(p1 + varName.length() + 2, p2);
    }

    public String getMsgTypeName() {
        try {
            Field[] f = this.getClass().getFields();
            int i = 0;
            while (i < f.length) {
                Integer nn = new Integer(0);
                if (f[i].getInt(nn) == this.msgType) {
                    return f[i].getName();
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(this.msgType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(" \u53d1\u9001\u4eba\uff1a" + this.msgSender);
        if (this.msgReceiver != null) {
            sb.append(" \u63a5\u6536\u4eba\uff1a" + this.msgReceiver.toString());
        }
        sb.append(" \u7c7b\u578b\uff1a");
        sb.append(this.getMsgTypeName());
        return sb.toString();
    }
}

