/*
 * Decompiled with CFR 0.152.
 */
package IM.client;

import IM.client.ClientProtocolProvider;
import IM.client.Message;
import IM.client.MessageParser;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import javax.swing.JApplet;
import org.apache.mina.io.IoConnector;
import org.apache.mina.io.socket.SocketConnector;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.io.IoProtocolConnector;

public class Client {
    private static final int CONNECT_TIMEOUT = 60;
    private int PORT;
    private String HOST;
    private JApplet pApplet;
    private MessageParser Parser;
    private ProtocolSession session = null;
    private Message lastMessage = null;

    public Client(JApplet applet, MessageParser parser, int port, String server) {
        this.pApplet = applet;
        this.Parser = parser;
        this.PORT = port;
        try {
            this.HOST = applet.getCodeBase().getHost();
        }
        catch (Exception e) {
            this.HOST = server;
        }
        if (this.HOST.equals("")) {
            this.HOST = "zengjun3";
        }
    }

    private void log(String s) {
        System.out.println(s);
    }

    public boolean connect() {
        try {
            IoProtocolConnector connector = new IoProtocolConnector((IoConnector)new SocketConnector());
            ClientProtocolProvider protocolProvider = new ClientProtocolProvider(this.Parser);
            this.session = connector.connect((SocketAddress)new InetSocketAddress(this.HOST, this.PORT), 60, (ProtocolProvider)protocolProvider);
        }
        catch (Exception e) {
            this.log(e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        if (this.session == null) {
            return true;
        }
        return this.session.isConnected();
    }

    public String sendMessage(Message m) {
        if (m == null) {
            return "\u6d88\u606f\u4e3a\u7a7a";
        }
        if (this.session.isConnected()) {
            this.lastMessage = m;
            this.session.write((Object)m);
            return "";
        }
        this.Parser.catchException(new ClosedChannelException());
        return "";
    }

    public void reSendLastMessage() {
        this.sendMessage(this.lastMessage);
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

