/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanTermQuery
extends SpanQuery {
    private Term term;

    public SpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public String getField() {
        return this.term.field();
    }

    public Collection getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.term);
        return terms;
    }

    public String toString(String field) {
        if (this.term.field().equals(field)) {
            return this.term.text();
        }
        return this.term.toString();
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        return new Spans(reader){
            private TermPositions positions;
            private int doc;
            private int freq;
            private int count;
            private int position;
            {
                this.positions = indexReader.termPositions(SpanTermQuery.this.term);
                this.doc = -1;
            }

            public boolean next() throws IOException {
                if (this.count == this.freq) {
                    if (!this.positions.next()) {
                        this.doc = Integer.MAX_VALUE;
                        return false;
                    }
                    this.doc = this.positions.doc();
                    this.freq = this.positions.freq();
                    this.count = 0;
                }
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public boolean skipTo(int target) throws IOException {
                if (!this.positions.skipTo(target)) {
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
                this.doc = this.positions.doc();
                this.freq = this.positions.freq();
                this.count = 0;
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public int doc() {
                return this.doc;
            }

            public int start() {
                return this.position;
            }

            public int end() {
                return this.position + 1;
            }

            public String toString() {
                return "spans(" + SpanTermQuery.this.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : String.valueOf(this.doc) + "-" + this.position));
            }
        };
    }
}

