/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.PriorityQueue;

public class SpanOrQuery
extends SpanQuery {
    private List clauses;
    private String field;

    public SpanOrQuery(SpanQuery[] clauses) {
        this.clauses = new ArrayList(clauses.length);
        int i = 0;
        while (i < clauses.length) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
            ++i;
        }
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanOr([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader);
        }
        return new Spans(reader){
            private List all;
            private SpanQueue queue;
            private boolean firstTime;
            {
                this.all = new ArrayList(SpanOrQuery.this.clauses.size());
                this.queue = new SpanQueue(SpanOrQuery.this.clauses.size());
                Iterator i = SpanOrQuery.this.clauses.iterator();
                while (i.hasNext()) {
                    this.all.add(((SpanQuery)i.next()).getSpans(indexReader));
                }
                this.firstTime = true;
            }

            public boolean next() throws IOException {
                if (this.firstTime) {
                    int i = 0;
                    while (i < this.all.size()) {
                        Spans spans = (Spans)this.all.get(i);
                        if (spans.next()) {
                            this.queue.put(spans);
                        } else {
                            this.all.remove(i--);
                        }
                        ++i;
                    }
                    this.firstTime = false;
                    return this.queue.size() != 0;
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.adjustTop();
                    return true;
                }
                this.all.remove(this.queue.pop());
                return this.queue.size() != 0;
            }

            private Spans top() {
                return (Spans)this.queue.top();
            }

            /*
             * Unable to fully structure code
             */
            public boolean skipTo(int target) throws IOException {
                block5: {
                    if (!this.firstTime) ** GOTO lbl19
                    i = 0;
                    while (i < this.all.size()) {
                        spans = (Spans)this.all.get(i);
                        if (spans.skipTo(target)) {
                            this.queue.put(spans);
                        } else {
                            this.all.remove(i--);
                        }
                        ++i;
                    }
                    this.firstTime = false;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        if (this.top().skipTo(target)) {
                            this.queue.adjustTop();
                            continue;
                        }
                        this.all.remove(this.queue.pop());
lbl19:
                        // 3 sources

                        ** while (this.queue.size() != 0 && this.top().doc() < target)
                    }
                }
                return this.queue.size() != 0;
            }

            public int doc() {
                return this.top().doc();
            }

            public int start() {
                return this.top().start();
            }

            public int end() {
                return this.top().end();
            }

            public String toString() {
                return "spans(" + SpanOrQuery.this + ")@" + (this.firstTime ? "START" : (this.queue.size() > 0 ? String.valueOf(this.doc()) + ":" + this.start() + "-" + this.end() : "END"));
            }
        };
    }

    private class SpanQueue
    extends PriorityQueue {
        public SpanQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            Spans spans1 = (Spans)o1;
            Spans spans2 = (Spans)o2;
            if (spans1.doc() == spans2.doc()) {
                if (spans1.start() == spans2.start()) {
                    return spans1.end() < spans2.end();
                }
                return spans1.start() < spans2.start();
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

