/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanNotQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;

    public SpanNotQuery(SpanQuery include, SpanQuery exclude) {
        this.include = include;
        this.exclude = exclude;
        if (!include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    public String getField() {
        return this.include.getField();
    }

    public Collection getTerms() {
        return this.include.getTerms();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNot(");
        buffer.append(this.include.toString(field));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field));
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        return new Spans(reader){
            private Spans includeSpans;
            private boolean moreInclude;
            private Spans excludeSpans;
            private boolean moreExclude;
            {
                this.includeSpans = SpanNotQuery.this.include.getSpans(indexReader);
                this.moreInclude = true;
                this.excludeSpans = SpanNotQuery.this.exclude.getSpans(indexReader);
                this.moreExclude = true;
            }

            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.next();
                }
                while (this.moreInclude && this.moreExclude) {
                    if (this.includeSpans.doc() > this.excludeSpans.doc()) {
                        this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                    }
                    while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                        this.moreExclude = this.excludeSpans.next();
                    }
                    if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) break;
                    this.moreInclude = this.includeSpans.next();
                }
                return this.moreInclude;
            }

            public boolean skipTo(int target) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.skipTo(target);
                }
                if (!this.moreInclude) {
                    return false;
                }
                if (this.moreExclude && this.includeSpans.doc() > this.excludeSpans.doc()) {
                    this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                }
                while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                    this.moreExclude = this.excludeSpans.next();
                }
                if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.includeSpans.doc();
            }

            public int start() {
                return this.includeSpans.start();
            }

            public int end() {
                return this.includeSpans.end();
            }

            public String toString() {
                return "spans(" + SpanNotQuery.this.toString() + ")";
            }
        };
    }
}

