/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultipleTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;

public class PhrasePrefixQuery
extends Query {
    private String field;
    private ArrayList termArrays = new ArrayList();
    private Vector positions = new Vector();
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] terms) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = (Integer)this.positions.lastElement() + 1;
        }
        this.add(terms, position);
    }

    public void add(Term[] terms, int position) {
        if (this.termArrays.size() == 0) {
            this.field = terms[0].field();
        }
        int i = 0;
        while (i < terms.length) {
            if (terms[i].field() != this.field) {
                throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + terms[i]);
            }
            ++i;
        }
        this.termArrays.add(terms);
        this.positions.addElement(new Integer(position));
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        int i = 0;
        while (i < this.positions.size()) {
            result[i] = (Integer)this.positions.elementAt(i);
            ++i;
        }
        return result;
    }

    protected Weight createWeight(Searcher searcher) {
        if (this.termArrays.size() == 1) {
            Term[] terms = (Term[])this.termArrays.get(0);
            BooleanQuery boq = new BooleanQuery();
            int i = 0;
            while (i < terms.length) {
                boq.add(new TermQuery(terms[i]), false, false);
                ++i;
            }
            boq.setBoost(this.getBoost());
            return boq.createWeight(searcher);
        }
        return new PhrasePrefixWeight(searcher);
    }

    public final String toString(String f) {
        StringBuffer buffer = new StringBuffer();
        if (!this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        Iterator i = this.termArrays.iterator();
        while (i.hasNext()) {
            Term[] terms = (Term[])i.next();
            buffer.append(String.valueOf(terms[0].text()) + (terms.length > 1 ? "*" : ""));
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    private class PhrasePrefixWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public PhrasePrefixWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return PhrasePrefixQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            Iterator i = PhrasePrefixQuery.this.termArrays.iterator();
            while (i.hasNext()) {
                Term[] terms = (Term[])i.next();
                int j = 0;
                while (j < terms.length) {
                    this.idf += PhrasePrefixQuery.this.getSimilarity(this.searcher).idf(terms[j], this.searcher);
                    ++j;
                }
            }
            this.queryWeight = this.idf * PhrasePrefixQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            if (PhrasePrefixQuery.this.termArrays.size() == 0) {
                return null;
            }
            TermPositions[] tps = new TermPositions[PhrasePrefixQuery.this.termArrays.size()];
            int i = 0;
            while (i < tps.length) {
                Term[] terms = (Term[])PhrasePrefixQuery.this.termArrays.get(i);
                TermPositions p = terms.length > 1 ? new MultipleTermPositions(reader, terms) : reader.termPositions(terms[0]);
                if (p == null) {
                    return null;
                }
                tps[i] = p;
                ++i;
            }
            if (PhrasePrefixQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, tps, PhrasePrefixQuery.this.getPositions(), PhrasePrefixQuery.this.getSimilarity(this.searcher), reader.norms(PhrasePrefixQuery.this.field));
            }
            return new SloppyPhraseScorer(this, tps, PhrasePrefixQuery.this.getPositions(), PhrasePrefixQuery.this.getSimilarity(this.searcher), PhrasePrefixQuery.this.slop, reader.norms(PhrasePrefixQuery.this.field));
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setDescription("weight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation idfExpl = new Explanation(this.idf, "idf(" + this.getQuery() + ")");
            Explanation queryExpl = new Explanation();
            queryExpl.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation boostExpl = new Explanation(PhrasePrefixQuery.this.getBoost(), "boost");
            if (PhrasePrefixQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(boostExpl);
            }
            queryExpl.addDetail(idfExpl);
            Explanation queryNormExpl = new Explanation(this.queryNorm, "queryNorm");
            queryExpl.addDetail(queryNormExpl);
            queryExpl.setValue(boostExpl.getValue() * idfExpl.getValue() * queryNormExpl.getValue());
            result.addDetail(queryExpl);
            Explanation fieldExpl = new Explanation();
            fieldExpl.setDescription("fieldWeight(" + this.getQuery() + " in " + doc + "), product of:");
            Explanation tfExpl = this.scorer(reader).explain(doc);
            fieldExpl.addDetail(tfExpl);
            fieldExpl.addDetail(idfExpl);
            Explanation fieldNormExpl = new Explanation();
            byte[] fieldNorms = reader.norms(PhrasePrefixQuery.this.field);
            float fieldNorm = fieldNorms != null ? Similarity.decodeNorm(fieldNorms[doc]) : 0.0f;
            fieldNormExpl.setValue(fieldNorm);
            fieldNormExpl.setDescription("fieldNorm(field=" + PhrasePrefixQuery.this.field + ", doc=" + doc + ")");
            fieldExpl.addDetail(fieldNormExpl);
            fieldExpl.setValue(tfExpl.getValue() * idfExpl.getValue() * fieldNormExpl.getValue());
            result.addDetail(fieldExpl);
            result.setValue(queryExpl.getValue() * fieldExpl.getValue());
            if (queryExpl.getValue() == 1.0f) {
                return fieldExpl;
            }
            return result;
        }
    }
}

