/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.MultiSearcherThread;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
    }

    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        int i = 0;
        while (i < this.searchables.length) {
            docFreq += this.searchables[i].docFreq(term);
            ++i;
        }
        return docFreq;
    }

    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            msta[i] = new MultiSearcherThread(this.searchables[i], query, filter, nDocs, hq, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
            ++i;
        }
        i = 0;
        while (i < this.searchables.length) {
            try {
                msta[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
            } else {
                throw ioe;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopDocs(totalHits, scoreDocs);
    }

    public TopFieldDocs search(Query query, Filter filter, int nDocs, Sort sort) throws IOException {
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(null, nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            msta[i] = new MultiSearcherThread(this.searchables[i], query, filter, nDocs, hq, sort, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
            ++i;
        }
        i = 0;
        while (i < this.searchables.length) {
            try {
                msta[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
            } else {
                throw ioe;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields());
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            final int start = this.starts[i];
            this.searchables[i].search(query, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
            ++i;
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            queries[i] = this.searchables[i].rewrite(original);
            ++i;
        }
        return original.combine(queries);
    }
}

