/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable[] searchables) throws IOException {
        this.searchables = searchables;
        this.starts = new int[searchables.length + 1];
        int i = 0;
        while (i < searchables.length) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchables[i].maxDoc();
            ++i;
        }
        this.starts[searchables.length] = this.maxDoc;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            this.searchables[i].close();
            ++i;
        }
    }

    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        int i = 0;
        while (i < this.searchables.length) {
            docFreq += this.searchables[i].docFreq(term);
            ++i;
        }
        return docFreq;
    }

    public Document doc(int n) throws IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i]);
    }

    public int searcherIndex(int n) {
        return this.subSearcher(n);
    }

    /*
     * Unable to fully structure code
     */
    public int subSearcher(int n) {
        lo = 0;
        hi = this.searchables.length - 1;
        while (hi >= lo) {
            mid = lo + hi >> 1;
            midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n <= midValue) ** GOTO lbl13
            lo = mid + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++mid;
lbl13:
                // 2 sources

                ** while (mid + 1 < this.searchables.length && this.starts[mid + 1] == midValue)
            }
lbl14:
            // 1 sources

            return mid;
        }
        return hi;
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        int i = 0;
        while (i < this.searchables.length) {
            TopDocs docs = this.searchables[i].search(query, filter, nDocs);
            totalHits += docs.totalHits;
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j = 0;
            while (j < scoreDocs.length) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) break;
                ++j;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopDocs(totalHits, scoreDocs);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        PriorityQueue hq = null;
        int totalHits = 0;
        int i = 0;
        while (i < this.searchables.length) {
            TopFieldDocs docs = this.searchables[i].search(query, filter, n, sort);
            if (hq == null) {
                hq = new FieldDocSortedHitQueue(docs.fields, n);
            }
            totalHits += docs.totalHits;
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j = 0;
            while (j < scoreDocs.length) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) break;
                ++j;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopFieldDocs(totalHits, scoreDocs, ((FieldDocSortedHitQueue)hq).getFields());
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            final int start = this.starts[i];
            this.searchables[i].search(query, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
            ++i;
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            queries[i] = this.searchables[i].rewrite(original);
            ++i;
        }
        return original.combine(queries);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        int i = this.subSearcher(doc);
        return this.searchables[i].explain(query, doc - this.starts[i]);
    }
}

