/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;

public final class Hits {
    private Query query;
    private Searcher searcher;
    private Filter filter = null;
    private Sort sort = null;
    private int length;
    private Vector hitDocs = new Vector();
    private HitDoc first;
    private HitDoc last;
    private int numDocs = 0;
    private int maxDocs = 200;

    Hits(Searcher s, Query q, Filter f) throws IOException {
        this.query = q;
        this.searcher = s;
        this.filter = f;
        this.getMoreDocs(50);
    }

    Hits(Searcher s, Query q, Filter f, Sort o) throws IOException {
        this.query = q;
        this.searcher = s;
        this.filter = f;
        this.sort = o;
        this.getMoreDocs(50);
    }

    private final void getMoreDocs(int min) throws IOException {
        if (this.hitDocs.size() > min) {
            min = this.hitDocs.size();
        }
        int n = min * 2;
        TopDocs topDocs = this.sort == null ? this.searcher.search(this.query, this.filter, n) : this.searcher.search(this.query, this.filter, n, this.sort);
        this.length = topDocs.totalHits;
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        float scoreNorm = 1.0f;
        if (this.length > 0 && scoreDocs[0].score > 1.0f) {
            scoreNorm = 1.0f / scoreDocs[0].score;
        }
        int end = scoreDocs.length < this.length ? scoreDocs.length : this.length;
        int i = this.hitDocs.size();
        while (i < end) {
            this.hitDocs.addElement(new HitDoc(scoreDocs[i].score * scoreNorm, scoreDocs[i].doc));
            ++i;
        }
    }

    public final int length() {
        return this.length;
    }

    public final Document doc(int n) throws IOException {
        HitDoc hitDoc = this.hitDoc(n);
        this.remove(hitDoc);
        this.addToFront(hitDoc);
        if (this.numDocs > this.maxDocs) {
            HitDoc oldLast = this.last;
            this.remove(this.last);
            oldLast.doc = null;
        }
        if (hitDoc.doc == null) {
            hitDoc.doc = this.searcher.doc(hitDoc.id);
        }
        return hitDoc.doc;
    }

    public final float score(int n) throws IOException {
        return this.hitDoc((int)n).score;
    }

    public final int id(int n) throws IOException {
        return this.hitDoc((int)n).id;
    }

    private final HitDoc hitDoc(int n) throws IOException {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException("Not a valid hit number: " + n);
        }
        if (n >= this.hitDocs.size()) {
            this.getMoreDocs(n);
        }
        return (HitDoc)this.hitDocs.elementAt(n);
    }

    private final void addToFront(HitDoc hitDoc) {
        if (this.first == null) {
            this.last = hitDoc;
        } else {
            this.first.prev = hitDoc;
        }
        hitDoc.next = this.first;
        this.first = hitDoc;
        hitDoc.prev = null;
        ++this.numDocs;
    }

    private final void remove(HitDoc hitDoc) {
        if (hitDoc.doc == null) {
            return;
        }
        if (hitDoc.next == null) {
            this.last = hitDoc.prev;
        } else {
            hitDoc.next.prev = hitDoc.prev;
        }
        if (hitDoc.prev == null) {
            this.first = hitDoc.next;
        } else {
            hitDoc.prev.next = hitDoc.next;
        }
        --this.numDocs;
    }
}

