/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    double distance;
    boolean endEnum = false;
    Term searchTerm = null;
    String field = "";
    String text = "";
    int textlen;
    String prefix = "";
    int prefixLength = 0;
    float minimumSimilarity;
    double scale_factor;
    private int[][] e = new int[1][1];

    public FuzzyTermEnum(IndexReader reader, Term term) throws IOException {
        this(reader, term, 0.5f, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity) throws IOException {
        this(reader, term, minSimilarity, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity, int prefixLength) throws IOException {
        this.minimumSimilarity = minSimilarity;
        this.scale_factor = 1.0f / (1.0f - this.minimumSimilarity);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        this.text = this.searchTerm.text();
        this.textlen = this.text.length();
        if (prefixLength > 0 && prefixLength < this.textlen) {
            this.prefixLength = prefixLength;
            this.prefix = this.text.substring(0, prefixLength);
            this.text = this.text.substring(prefixLength);
            this.textlen = this.text.length();
        }
        this.setEnum(reader.terms(new Term(this.searchTerm.field(), this.prefix)));
    }

    protected final boolean termCompare(Term term) {
        String termText = term.text();
        if (this.field == term.field() && termText.startsWith(this.prefix)) {
            String target = termText.substring(this.prefixLength);
            int targetlen = target.length();
            int dist = this.editDistance(this.text, target, this.textlen, targetlen);
            this.distance = 1.0 - (double)dist / (double)Math.min(this.textlen, targetlen);
            return this.distance > (double)this.minimumSimilarity;
        }
        this.endEnum = true;
        return false;
    }

    protected final float difference() {
        return (float)((this.distance - (double)this.minimumSimilarity) * this.scale_factor);
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int editDistance(String s, String t, int n, int m) {
        if (this.e.length <= n || this.e[0].length <= m) {
            this.e = new int[Math.max(this.e.length, n + 1)][Math.max(this.e[0].length, m + 1)];
        }
        int[][] d = this.e;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                d[i][j] = s_i != t.charAt(j - 1) ? FuzzyTermEnum.min(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1]) + 1 : FuzzyTermEnum.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1]);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public void close() throws IOException {
        super.close();
        this.searchTerm = null;
        this.field = null;
        this.text = null;
    }
}

