/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.SortComparator;

class FieldCacheImpl
implements FieldCache {
    final Map cache = new WeakHashMap();

    FieldCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader reader, String field, int type) {
        Entry entry = new Entry(field, type);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap readerCache;
            block4: {
                readerCache = (HashMap)this.cache.get(reader);
                if (readerCache != null) break block4;
                return null;
            }
            return readerCache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader reader, String field, Object comparer) {
        Entry entry = new Entry(field, comparer);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap readerCache;
            block4: {
                readerCache = (HashMap)this.cache.get(reader);
                if (readerCache != null) break block4;
                return null;
            }
            return readerCache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, int type, Object value) {
        Entry entry = new Entry(field, type);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap<Entry, Object> readerCache = (HashMap<Entry, Object>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Entry, Object>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(entry, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader reader, String field, Object comparer, Object value) {
        Entry entry = new Entry(field, comparer);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            HashMap<Entry, Object> readerCache = (HashMap<Entry, Object>)this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Entry, Object>();
                this.cache.put(reader, readerCache);
            }
            return readerCache.put(entry, value);
        }
    }

    public int[] getInts(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), 4);
        if (ret == null) {
            int[] retArray = new int[reader.maxDoc()];
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != field) {
                            break;
                        }
                        int termval = Integer.parseInt(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(reader, field, 4, (Object)retArray);
            return retArray;
        }
        return (int[])ret;
    }

    public float[] getFloats(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), 5);
        if (ret == null) {
            float[] retArray = new float[reader.maxDoc()];
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != field) {
                            break;
                        }
                        float termval = Float.parseFloat(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(reader, field, 5, (Object)retArray);
            return retArray;
        }
        return (float[])ret;
    }

    public String[] getStrings(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), 3);
        if (ret == null) {
            String[] retArray = new String[reader.maxDoc()];
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != field) {
                            break;
                        }
                        String termval = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(reader, field, 3, (Object)retArray);
            return retArray;
        }
        return (String[])ret;
    }

    public FieldCache.StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), -1);
        if (ret == null) {
            int[] retArray = new int[reader.maxDoc()];
            String[] mterms = new String[reader.maxDoc() + 1];
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, ""));
                int t = 0;
                mterms[t++] = null;
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != field) {
                            break;
                        }
                        if (t >= mterms.length) {
                            throw new RuntimeException("there are more terms than documents in field \"" + field + "\"");
                        }
                        mterms[t] = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = t;
                        }
                        ++t;
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
                if (t == 0) {
                    mterms = new String[1];
                } else if (t < mterms.length) {
                    String[] terms = new String[t];
                    System.arraycopy(mterms, 0, terms, 0, t);
                    mterms = terms;
                }
            }
            FieldCache.StringIndex value = new FieldCache.StringIndex(retArray, mterms);
            this.store(reader, field, -1, (Object)value);
            return value;
        }
        return (FieldCache.StringIndex)ret;
    }

    public Object getAuto(IndexReader reader, String field) throws IOException {
        Object ret;
        block11: {
            ret = this.lookup(reader, field = field.intern(), 2);
            if (ret == null) {
                TermEnum enumerator = reader.terms(new Term(field, ""));
                try {
                    Term term = enumerator.term();
                    if (term == null) {
                        throw new RuntimeException("no terms in field " + field + " - cannot determine sort type");
                    }
                    if (term.field() == field) {
                        String termtext = term.text().trim();
                        try {
                            Integer.parseInt(termtext);
                            ret = this.getInts(reader, field);
                        }
                        catch (NumberFormatException nfe1) {
                            try {
                                Float.parseFloat(termtext);
                                ret = this.getFloats(reader, field);
                            }
                            catch (NumberFormatException nfe2) {
                                ret = this.getStringIndex(reader, field);
                            }
                        }
                        if (ret != null) {
                            this.store(reader, field, 2, ret);
                        }
                        break block11;
                    }
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                finally {
                    enumerator.close();
                }
            }
        }
        return ret;
    }

    public Comparable[] getCustom(IndexReader reader, String field, SortComparator comparator) throws IOException {
        Object ret = this.lookup(reader, field = field.intern(), comparator);
        if (ret == null) {
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            if (retArray.length > 0) {
                TermDocs termDocs = reader.termDocs();
                TermEnum termEnum = reader.terms(new Term(field, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != field) {
                            break;
                        }
                        Comparable termval = comparator.getComparable(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(reader, field, 9, (Object)retArray);
            return retArray;
        }
        return (Comparable[])ret;
    }

    static class Entry {
        final String field;
        final int type;
        final Object custom;

        Entry(String field, int type) {
            this.field = field.intern();
            this.type = type;
            this.custom = null;
        }

        Entry(String field, Object custom) {
            this.field = field.intern();
            this.type = 9;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field == this.field && other.type == this.type && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.type ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }
}

