/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class BooleanQuery
extends Query {
    public static int maxClauseCount = Integer.parseInt(System.getProperty("org.apache.lucene.maxClauseCount", "1024"));
    private Vector clauses = new Vector();

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public void add(Query query, boolean required, boolean prohibited) {
        this.add(new BooleanClause(query, required, prohibited));
    }

    public void add(BooleanClause clause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.addElement(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[0]);
    }

    protected Weight createWeight(Searcher searcher) {
        return new BooleanWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.clauses.size() == 1) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(0);
            if (!c.prohibited) {
                Query query = c.query.rewrite(reader);
                if (this.getBoost() != 1.0f) {
                    if (query == c.query) {
                        query = (Query)query.clone();
                    }
                    query.setBoost(this.getBoost() * query.getBoost());
                }
                return query;
            }
        }
        BooleanQuery clone = null;
        int i = 0;
        while (i < this.clauses.size()) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(i);
            Query query = c.query.rewrite(reader);
            if (query != c.query) {
                if (clone == null) {
                    clone = (BooleanQuery)this.clone();
                }
                clone.clauses.setElementAt(new BooleanClause(query, c.required, c.prohibited), i);
            }
            ++i;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public Object clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = (Vector)this.clauses.clone();
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if ((double)this.getBoost() != 1.0) {
            buffer.append("(");
        }
        int i = 0;
        while (i < this.clauses.size()) {
            BooleanClause c = (BooleanClause)this.clauses.elementAt(i);
            if (c.prohibited) {
                buffer.append("-");
            } else if (c.required) {
                buffer.append("+");
            }
            Query subQuery = c.query;
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(c.query.toString(field));
                buffer.append(")");
            } else {
                buffer.append(c.query.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append(")^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return this.getBoost() == other.getBoost() && this.clauses.equals(other.clauses);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode();
    }

    public static class TooManyClauses
    extends RuntimeException {
    }

    private class BooleanWeight
    implements Weight {
        private Searcher searcher;
        private Vector weights = new Vector();

        public BooleanWeight(Searcher searcher) {
            this.searcher = searcher;
            int i = 0;
            while (i < BooleanQuery.this.clauses.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                this.weights.add(c.query.createWeight(searcher));
                ++i;
            }
        }

        public Query getQuery() {
            return BooleanQuery.this;
        }

        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum = 0.0f;
            int i = 0;
            while (i < this.weights.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (!c.prohibited) {
                    sum += w.sumOfSquaredWeights();
                }
                ++i;
            }
            return sum *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        public void normalize(float norm) {
            norm *= BooleanQuery.this.getBoost();
            int i = 0;
            while (i < this.weights.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                if (!c.prohibited) {
                    w.normalize(norm);
                }
                ++i;
            }
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            boolean allRequired = true;
            boolean noneBoolean = true;
            int i = 0;
            while (i < this.weights.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                if (!c.required) {
                    allRequired = false;
                }
                if (c.query instanceof BooleanQuery) {
                    noneBoolean = false;
                }
                ++i;
            }
            if (allRequired && noneBoolean) {
                ConjunctionScorer result = new ConjunctionScorer(BooleanQuery.this.getSimilarity(this.searcher));
                int i2 = 0;
                while (i2 < this.weights.size()) {
                    Weight w = (Weight)this.weights.elementAt(i2);
                    Scorer subScorer = w.scorer(reader);
                    if (subScorer == null) {
                        return null;
                    }
                    result.add(subScorer);
                    ++i2;
                }
                return result;
            }
            BooleanScorer result = new BooleanScorer(BooleanQuery.this.getSimilarity(this.searcher));
            int i3 = 0;
            while (i3 < this.weights.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i3);
                Weight w = (Weight)this.weights.elementAt(i3);
                Scorer subScorer = w.scorer(reader);
                if (subScorer != null) {
                    result.add(subScorer, c.required, c.prohibited);
                } else if (c.required) {
                    return null;
                }
                ++i3;
            }
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            float coordFactor;
            Explanation sumExpl = new Explanation();
            sumExpl.setDescription("sum of:");
            int coord = 0;
            int maxCoord = 0;
            float sum = 0.0f;
            int i = 0;
            while (i < this.weights.size()) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.elementAt(i);
                Weight w = (Weight)this.weights.elementAt(i);
                Explanation e = w.explain(reader, doc);
                if (!c.prohibited) {
                    ++maxCoord;
                }
                if (e.getValue() > 0.0f) {
                    if (c.prohibited) return new Explanation(0.0f, "match prohibited");
                    sumExpl.addDetail(e);
                    sum += e.getValue();
                    ++coord;
                } else if (c.required) {
                    return new Explanation(0.0f, "match required");
                }
                ++i;
            }
            sumExpl.setValue(sum);
            if (coord == 1) {
                sumExpl = sumExpl.getDetails()[0];
            }
            if ((coordFactor = BooleanQuery.this.getSimilarity(this.searcher).coord(coord, maxCoord)) == 1.0f) {
                return sumExpl;
            }
            Explanation result = new Explanation();
            result.setDescription("product of:");
            result.addDetail(sumExpl);
            result.addDetail(new Explanation(coordFactor, "coord(" + coord + "/" + maxCoord + ")"));
            result.setValue(sum * coordFactor);
            return result;
        }
    }
}

