/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.FastCharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParserConstants;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.queryParser.Token;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class QueryParser
implements QueryParserConstants {
    private static final int CONJ_NONE = 0;
    private static final int CONJ_AND = 1;
    private static final int CONJ_OR = 2;
    private static final int MOD_NONE = 0;
    private static final int MOD_NOT = 10;
    private static final int MOD_REQ = 11;
    public static final int DEFAULT_OPERATOR_OR = 0;
    public static final int DEFAULT_OPERATOR_AND = 1;
    private int operator = 0;
    boolean lowercaseWildcardTerms = true;
    Analyzer analyzer;
    String field;
    int phraseSlop = 0;
    float fuzzyMinSim = 0.5f;
    Locale locale = Locale.getDefault();
    public QueryParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[22];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        QueryParser.jj_la1_0();
    }

    public static Query parse(String query, String field, Analyzer analyzer) throws ParseException {
        QueryParser parser = new QueryParser(field, analyzer);
        return parser.parse(query);
    }

    public QueryParser(String f, Analyzer a) {
        this(new FastCharStream(new StringReader("")));
        this.analyzer = a;
        this.field = f;
    }

    public Query parse(String query) throws ParseException {
        this.ReInit(new FastCharStream(new StringReader(query)));
        try {
            return this.Query(this.field);
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme.getMessage());
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            throw new ParseException("Too many boolean clauses");
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String getField() {
        return this.field;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        this.fuzzyMinSim = fuzzyMinSim;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setLowercaseWildcardTerms(boolean lowercaseWildcardTerms) {
        this.lowercaseWildcardTerms = lowercaseWildcardTerms;
    }

    public boolean getLowercaseWildcardTerms() {
        return this.lowercaseWildcardTerms;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void addClause(Vector clauses, int conj, int mods, Query q) {
        boolean required;
        boolean prohibited;
        BooleanClause c;
        if (clauses.size() > 0 && conj == 1) {
            c = (BooleanClause)clauses.elementAt(clauses.size() - 1);
            if (!c.prohibited) {
                c.required = true;
            }
        }
        if (clauses.size() > 0 && this.operator == 1 && conj == 2) {
            c = (BooleanClause)clauses.elementAt(clauses.size() - 1);
            if (!c.prohibited) {
                c.required = false;
            }
        }
        if (q == null) {
            return;
        }
        if (this.operator == 0) {
            prohibited = mods == 10;
            boolean bl = required = mods == 11;
            if (conj == 1 && !prohibited) {
                required = true;
            }
        } else {
            prohibited = mods == 10;
            required = !prohibited && conj != 2;
        }
        clauses.addElement(new BooleanClause(q, required, prohibited));
    }

    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        TokenStream source = this.analyzer.tokenStream(field, new StringReader(queryText));
        Vector<String> v = new Vector<String>();
        while (true) {
            org.apache.lucene.analysis.Token t;
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t.termText());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return new TermQuery(new Term(field, (String)v.elementAt(0)));
        }
        PhraseQuery q = new PhraseQuery();
        q.setSlop(this.phraseSlop);
        int i = 0;
        while (i < v.size()) {
            q.add(new Term(field, (String)v.elementAt(i)));
            ++i;
        }
        return q;
    }

    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText, int slop) throws ParseException {
        return this.getFieldQuery(field, queryText, slop);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getFieldQuery(field, queryText);
        if (query instanceof PhraseQuery) {
            ((PhraseQuery)query).setSlop(slop);
        }
        return query;
    }

    protected Query getRangeQuery(String field, Analyzer analyzer, String part1, String part2, boolean inclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, inclusive);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        try {
            DateFormat df = DateFormat.getDateInstance(3, this.locale);
            df.setLenient(true);
            Date d1 = df.parse(part1);
            Date d2 = df.parse(part2);
            part1 = DateField.dateToString(d1);
            part2 = DateField.dateToString(d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RangeQuery(new Term(field, part1), new Term(field, part2), inclusive);
    }

    protected Query getBooleanQuery(Vector clauses) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        int i = 0;
        while (i < clauses.size()) {
            query.add((BooleanClause)clauses.elementAt(i));
            ++i;
        }
        return query;
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseWildcardTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new WildcardQuery(t);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (this.lowercaseWildcardTerms) {
            termStr = termStr.toLowerCase();
        }
        Term t = new Term(field, termStr);
        return new PrefixQuery(t);
    }

    protected Query getFuzzyQuery(String field, String termStr) throws ParseException {
        return this.getFuzzyQuery(field, termStr, this.fuzzyMinSim);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        Term t = new Term(field, termStr);
        return new FuzzyQuery(t, minSimilarity);
    }

    private String discardEscapeChar(String input) {
        char[] caSource = input.toCharArray();
        char[] caDest = new char[caSource.length];
        int j = 0;
        int i = 0;
        while (i < caSource.length) {
            if (caSource[i] != '\\' || i > 0 && caSource[i - 1] == '\\') {
                caDest[j++] = caSource[i];
            }
            ++i;
        }
        return new String(caDest, 0, j);
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        QueryParser qp = new QueryParser("field", new SimpleAnalyzer());
        Query q = qp.parse(args[0]);
        System.out.println(q.toString("field"));
    }

    public final int Conjunction() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        ret = 1;
                        break block0;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        ret = 2;
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        return ret;
    }

    public final int Modifiers() throws ParseException {
        int ret = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.jj_consume_token(10);
                        ret = 11;
                        break block0;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        ret = 10;
                        break block0;
                    }
                    case 9: {
                        this.jj_consume_token(9);
                        ret = 10;
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return ret;
    }

    public final Query Query(String field) throws ParseException {
        Vector clauses = new Vector();
        Query firstQuery = null;
        int mods = this.Modifiers();
        Query q = this.Clause(field);
        this.addClause(clauses, 0, mods, q);
        if (mods == 0) {
            firstQuery = q;
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            int conj = this.Conjunction();
            mods = this.Modifiers();
            q = this.Clause(field);
            this.addClause(clauses, conj, mods, q);
        }
        if (clauses.size() == 1 && firstQuery != null) {
            return firstQuery;
        }
        return this.getBooleanQuery(clauses);
    }

    public final Query Clause(String field) throws ParseException {
        Query q;
        Token fieldToken = null;
        Token boost = null;
        if (this.jj_2_1(2)) {
            fieldToken = this.jj_consume_token(17);
            this.jj_consume_token(14);
            field = this.discardEscapeChar(fieldToken.image);
        }
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                q = this.Term(field);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                q = this.Query(field);
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break block1;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
                q.setBoost(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return q;
    }

    public final Query Term(String field) throws ParseException {
        Query q;
        Token boost = null;
        Token fuzzySlop = null;
        boolean prefix = false;
        boolean wildcard = false;
        boolean fuzzy = false;
        boolean rangein = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 19: 
            case 20: 
            case 23: {
                Token term;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        term = this.jj_consume_token(17);
                        break;
                    }
                    case 19: {
                        term = this.jj_consume_token(19);
                        prefix = true;
                        break;
                    }
                    case 20: {
                        term = this.jj_consume_token(20);
                        wildcard = true;
                        break;
                    }
                    case 23: {
                        term = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        fuzzySlop = this.jj_consume_token(18);
                        fuzzy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                block18 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 18: {
                                fuzzySlop = this.jj_consume_token(18);
                                fuzzy = true;
                                break block18;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                String termImage = this.discardEscapeChar(term.image);
                if (wildcard) {
                    q = this.getWildcardQuery(field, termImage);
                    break;
                }
                if (prefix) {
                    q = this.getPrefixQuery(field, this.discardEscapeChar(term.image.substring(0, term.image.length() - 1)));
                    break;
                }
                if (fuzzy) {
                    float fms = this.fuzzyMinSim;
                    try {
                        fms = Float.valueOf(fuzzySlop.image.substring(1)).floatValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fms < 0.0f || fms > 1.0f) {
                        throw new ParseException("Minimum similarity for a FuzzyQuery has to be between 0.0f and 1.0f !");
                    }
                    if (fms == this.fuzzyMinSim) {
                        q = this.getFuzzyQuery(field, termImage);
                        break;
                    }
                    q = this.getFuzzyQuery(field, termImage, fms);
                    break;
                }
                q = this.getFieldQuery(field, this.analyzer, termImage);
                break;
            }
            case 21: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        goop1 = this.jj_consume_token(27);
                        break;
                    }
                    case 26: {
                        goop1 = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        goop2 = this.jj_consume_token(27);
                        break;
                    }
                    case 26: {
                        goop2 = this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(25);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                goop1.image = goop1.kind == 26 ? goop1.image.substring(1, goop1.image.length() - 1) : this.discardEscapeChar(goop1.image);
                goop2.image = goop2.kind == 26 ? goop2.image.substring(1, goop2.image.length() - 1) : this.discardEscapeChar(goop2.image);
                q = this.getRangeQuery(field, this.analyzer, goop1.image, goop2.image, true);
                break;
            }
            case 22: {
                Token goop2;
                Token goop1;
                this.jj_consume_token(22);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        goop1 = this.jj_consume_token(31);
                        break;
                    }
                    case 30: {
                        goop1 = this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.jj_consume_token(28);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        goop2 = this.jj_consume_token(31);
                        break;
                    }
                    case 30: {
                        goop2 = this.jj_consume_token(30);
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(29);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                goop1.image = goop1.kind == 30 ? goop1.image.substring(1, goop1.image.length() - 1) : this.discardEscapeChar(goop1.image);
                goop2.image = goop2.kind == 30 ? goop2.image.substring(1, goop2.image.length() - 1) : this.discardEscapeChar(goop2.image);
                q = this.getRangeQuery(field, this.analyzer, goop1.image, goop2.image, false);
                break;
            }
            case 16: {
                Token term = this.jj_consume_token(16);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        fuzzySlop = this.jj_consume_token(18);
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        boost = this.jj_consume_token(23);
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                    }
                }
                int s = this.phraseSlop;
                if (fuzzySlop != null) {
                    try {
                        s = Float.valueOf(fuzzySlop.image.substring(1)).intValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                q = this.getFieldQuery(field, this.analyzer, term.image.substring(1, term.image.length() - 1), s);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (boost != null) {
            float f = 1.0f;
            try {
                f = Float.valueOf(boost.image).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (q != null) {
                q.setBoost(f);
            }
        }
        return q;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{384, 384, 3584, 3584, 16457600, 32768, 16453632, 0x9A0000, 262144, 262144, 32768, 0xC000000, 0x1000000, 0xC000000, 32768, -1073741824, 0x10000000, -1073741824, 32768, 262144, 32768, 0xFB0000};
    }

    public QueryParser(CharStream stream) {
        this.token_source = new QueryParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public QueryParser(QueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 22) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[32];
        int i = 0;
        while (i < 32) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 22) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

