/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    public static final int NORMAL_FIELD = 0;
    public static final int REQUIRED_FIELD = 1;
    public static final int PROHIBITED_FIELD = 2;

    public MultiFieldQueryParser(QueryParserTokenManager tm) {
        super(tm);
    }

    public MultiFieldQueryParser(CharStream stream) {
        super(stream);
    }

    public MultiFieldQueryParser(String f, Analyzer a) {
        super(f, a);
    }

    public static Query parse(String query, String[] fields, Analyzer analyzer) throws ParseException {
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query q = MultiFieldQueryParser.parse(query, fields[i], analyzer);
            bQuery.add(q, false, false);
            ++i;
        }
        return bQuery;
    }

    public static Query parse(String query, String[] fields, int[] flags, Analyzer analyzer) throws ParseException {
        BooleanQuery bQuery = new BooleanQuery();
        int i = 0;
        while (i < fields.length) {
            Query q = MultiFieldQueryParser.parse(query, fields[i], analyzer);
            int flag = flags[i];
            switch (flag) {
                case 1: {
                    bQuery.add(q, true, false);
                    break;
                }
                case 2: {
                    bQuery.add(q, false, true);
                    break;
                }
                default: {
                    bQuery.add(q, false, false);
                }
            }
            ++i;
        }
        return bQuery;
    }
}

