/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.StringHelper;

final class TermVectorsWriter {
    public static final int FORMAT_VERSION = 1;
    public static final int FORMAT_SIZE = 4;
    public static final String TVX_EXTENSION = ".tvx";
    public static final String TVD_EXTENSION = ".tvd";
    public static final String TVF_EXTENSION = ".tvf";
    private OutputStream tvx = null;
    private OutputStream tvd = null;
    private OutputStream tvf = null;
    private Vector fields = null;
    private Vector terms = null;
    private FieldInfos fieldInfos;
    private TVField currentField = null;
    private long currentDocPointer = -1L;

    public TermVectorsWriter(Directory directory, String segment, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createFile(String.valueOf(segment) + TVX_EXTENSION);
        this.tvx.writeInt(1);
        this.tvd = directory.createFile(String.valueOf(segment) + TVD_EXTENSION);
        this.tvd.writeInt(1);
        this.tvf = directory.createFile(String.valueOf(segment) + TVF_EXTENSION);
        this.tvf.writeInt(1);
        this.fieldInfos = fieldInfos;
        this.fields = new Vector(fieldInfos.size());
        this.terms = new Vector();
    }

    public final void openDocument() throws IOException {
        this.closeDocument();
        this.currentDocPointer = this.tvd.getFilePointer();
    }

    public final void closeDocument() throws IOException {
        if (this.isDocumentOpen()) {
            this.closeField();
            this.writeDoc();
            this.fields.clear();
            this.currentDocPointer = -1L;
        }
    }

    public final boolean isDocumentOpen() {
        return this.currentDocPointer != -1L;
    }

    public final void openField(String field) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot open field when no document is open.");
        }
        this.closeField();
        this.currentField = new TVField(this.fieldInfos.fieldNumber(field));
    }

    public final void closeField() throws IOException {
        if (this.isFieldOpen()) {
            this.writeField();
            this.fields.add(this.currentField);
            this.terms.clear();
            this.currentField = null;
        }
    }

    public final boolean isFieldOpen() {
        return this.currentField != null;
    }

    public final void addTerm(String termText, int freq) {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add terms when document is not open");
        }
        if (!this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add terms when field is not open");
        }
        this.addTermInternal(termText, freq);
    }

    private final void addTermInternal(String termText, int freq) {
        this.currentField.length += freq;
        TVTerm term = new TVTerm();
        term.termText = termText;
        term.freq = freq;
        this.terms.add(term);
    }

    public final void addVectors(TermFreqVector[] vectors) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vectors when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vectors when field is open");
        }
        int i = 0;
        while (i < vectors.length) {
            this.addTermFreqVector(vectors[i]);
            ++i;
        }
    }

    public final void addTermFreqVector(TermFreqVector vector) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vector when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vector when field is open");
        }
        this.addTermFreqVectorInternal(vector);
    }

    private final void addTermFreqVectorInternal(TermFreqVector vector) throws IOException {
        this.openField(vector.getField());
        int i = 0;
        while (i < vector.size()) {
            this.addTermInternal(vector.getTerms()[i], vector.getTermFrequencies()[i]);
            ++i;
        }
        this.closeField();
    }

    final void close() throws IOException {
        try {
            this.closeDocument();
        }
        finally {
            IOException keep;
            block22: {
                block21: {
                    block20: {
                        keep = null;
                        if (this.tvx != null) {
                            try {
                                this.tvx.close();
                            }
                            catch (IOException e) {
                                if (keep != null) break block20;
                                keep = e;
                            }
                        }
                    }
                    if (this.tvd != null) {
                        try {
                            this.tvd.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block21;
                            keep = e;
                        }
                    }
                }
                if (this.tvf != null) {
                    try {
                        this.tvf.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block22;
                        keep = e;
                    }
                }
            }
            if (keep != null) {
                throw (IOException)keep.fillInStackTrace();
            }
        }
    }

    private void writeField() throws IOException {
        this.currentField.tvfPointer = this.tvf.getFilePointer();
        int size = this.terms.size();
        this.tvf.writeVInt(size);
        this.tvf.writeVInt(this.currentField.length - size);
        String lastTermText = "";
        int i = 0;
        while (i < size) {
            TVTerm term = (TVTerm)this.terms.elementAt(i);
            int start = StringHelper.stringDifference(lastTermText, term.termText);
            int length = term.termText.length() - start;
            this.tvf.writeVInt(start);
            this.tvf.writeVInt(length);
            this.tvf.writeChars(term.termText, start, length);
            this.tvf.writeVInt(term.freq);
            lastTermText = term.termText;
            ++i;
        }
    }

    private void writeDoc() throws IOException {
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Field is still open while writing document");
        }
        this.tvx.writeLong(this.currentDocPointer);
        int size = this.fields.size();
        this.tvd.writeVInt(size);
        int lastFieldNumber = 0;
        int i = 0;
        while (i < size) {
            TVField field = (TVField)this.fields.elementAt(i);
            this.tvd.writeVInt(field.number - lastFieldNumber);
            lastFieldNumber = field.number;
            ++i;
        }
        long lastFieldPointer = 0L;
        int i2 = 0;
        while (i2 < size) {
            TVField field = (TVField)this.fields.elementAt(i2);
            this.tvd.writeVLong(field.tvfPointer - lastFieldPointer);
            lastFieldPointer = field.tvfPointer;
            ++i2;
        }
    }

    private static class TVField {
        int number;
        long tvfPointer = 0L;
        int length = 0;

        TVField(int number) {
            this.number = number;
        }
    }

    private static class TVTerm {
        String termText;
        int freq = 0;

        private TVTerm() {
        }
    }
}

