/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;

class TermVectorsReader {
    private FieldInfos fieldInfos;
    private InputStream tvx;
    private InputStream tvd;
    private InputStream tvf;
    private int size;

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos) throws IOException {
        if (d.fileExists(String.valueOf(segment) + ".tvx")) {
            this.tvx = d.openFile(String.valueOf(segment) + ".tvx");
            this.checkValidFormat(this.tvx);
            this.tvd = d.openFile(String.valueOf(segment) + ".tvd");
            this.checkValidFormat(this.tvd);
            this.tvf = d.openFile(String.valueOf(segment) + ".tvf");
            this.checkValidFormat(this.tvf);
            this.size = (int)this.tvx.length() / 8;
        }
        this.fieldInfos = fieldInfos;
    }

    private void checkValidFormat(InputStream in) throws IOException {
        int format = in.readInt();
        if (format > 1) {
            throw new IOException("Incompatible format version: " + format + " expected " + 1 + " or less");
        }
    }

    synchronized void close() throws IOException {
        if (this.tvx != null) {
            this.tvx.close();
        }
        if (this.tvd != null) {
            this.tvd.close();
        }
        if (this.tvf != null) {
            this.tvf.close();
        }
    }

    int size() {
        return this.size;
    }

    synchronized TermFreqVector get(int docNum, String field) {
        int fieldNumber = this.fieldInfos.fieldNumber(field);
        SegmentTermVector result = null;
        if (this.tvx != null) {
            try {
                this.tvx.seek((long)docNum * 8L + 4L);
                long position = this.tvx.readLong();
                this.tvd.seek(position);
                int fieldCount = this.tvd.readVInt();
                int number = 0;
                int found = -1;
                int i = 0;
                while (i < fieldCount) {
                    if ((number += this.tvd.readVInt()) == fieldNumber) {
                        found = i;
                    }
                    ++i;
                }
                if (found != -1) {
                    position = 0L;
                    i = 0;
                    while (i <= found) {
                        position += this.tvd.readVLong();
                        ++i;
                    }
                    result = this.readTermVector(field, position);
                }
            }
            catch (Exception exception) {}
        } else {
            System.out.println("No tvx file");
        }
        return result;
    }

    synchronized TermFreqVector[] get(int docNum) {
        TermFreqVector[] result = null;
        if (this.tvx != null) {
            try {
                this.tvx.seek((long)docNum * 8L + 4L);
                long position = this.tvx.readLong();
                this.tvd.seek(position);
                int fieldCount = this.tvd.readVInt();
                if (fieldCount != 0) {
                    int number = 0;
                    String[] fields = new String[fieldCount];
                    int i = 0;
                    while (i < fieldCount) {
                        fields[i] = this.fieldInfos.fieldName(number += this.tvd.readVInt());
                        ++i;
                    }
                    position = 0L;
                    long[] tvfPointers = new long[fieldCount];
                    int i2 = 0;
                    while (i2 < fieldCount) {
                        tvfPointers[i2] = position += this.tvd.readVLong();
                        ++i2;
                    }
                    result = this.readTermVectors(fields, tvfPointers);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No tvx file");
        }
        return result;
    }

    private SegmentTermVector[] readTermVectors(String[] fields, long[] tvfPointers) throws IOException {
        SegmentTermVector[] res = new SegmentTermVector[fields.length];
        int i = 0;
        while (i < fields.length) {
            res[i] = this.readTermVector(fields[i], tvfPointers[i]);
            ++i;
        }
        return res;
    }

    private SegmentTermVector readTermVector(String field, long tvfPointer) throws IOException {
        this.tvf.seek(tvfPointer);
        int numTerms = this.tvf.readVInt();
        if (numTerms == 0) {
            return new SegmentTermVector(field, null, null);
        }
        int length = numTerms + this.tvf.readVInt();
        String[] terms = new String[numTerms];
        int[] termFreqs = new int[numTerms];
        int start = 0;
        int deltaLength = 0;
        int totalLength = 0;
        char[] buffer = new char[]{};
        String previousString = "";
        int i = 0;
        while (i < numTerms) {
            start = this.tvf.readVInt();
            totalLength = start + (deltaLength = this.tvf.readVInt());
            if (buffer.length < totalLength) {
                buffer = new char[totalLength];
                int j = 0;
                while (j < previousString.length()) {
                    buffer[j] = previousString.charAt(j);
                    ++j;
                }
            }
            this.tvf.readChars(buffer, start, deltaLength);
            terms[i] = new String(buffer, 0, totalLength);
            previousString = terms[i];
            termFreqs[i] = this.tvf.readVInt();
            ++i;
        }
        SegmentTermVector tv = new SegmentTermVector(field, terms, termFreqs);
        return tv;
    }
}

