/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMOutputStream;

final class SegmentMerger {
    private boolean useCompoundFile;
    private Directory directory;
    private String segment;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    private static final String[] VECTOR_EXTENSIONS = new String[]{"tvx", "tvd", "tvf"};
    private OutputStream freqOutput = null;
    private OutputStream proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private int skipInterval;
    private SegmentMergeQueue queue = null;
    private final TermInfo termInfo = new TermInfo();
    private RAMOutputStream skipBuffer = new RAMOutputStream();
    private int lastSkipDoc;
    private long lastSkipFreqPointer;
    private long lastSkipProxPointer;

    SegmentMerger(Directory dir, String name, boolean compoundFile) {
        this.directory = dir;
        this.segment = name;
        this.useCompoundFile = compoundFile;
    }

    final void add(IndexReader reader) {
        this.readers.addElement(reader);
    }

    final IndexReader segmentReader(int i) {
        return (IndexReader)this.readers.elementAt(i);
    }

    final int merge() throws IOException {
        int value = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        if (this.useCompoundFile) {
            this.createCompoundFile();
        }
        return value;
    }

    final void closeReaders() throws IOException {
        int i = 0;
        while (i < this.readers.size()) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            reader.close();
            ++i;
        }
    }

    private final void createCompoundFile() throws IOException {
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, String.valueOf(this.segment) + ".cfs");
        ArrayList<String> files = new ArrayList<String>(COMPOUND_EXTENSIONS.length + this.fieldInfos.size());
        int i = 0;
        while (i < COMPOUND_EXTENSIONS.length) {
            files.add(String.valueOf(this.segment) + "." + COMPOUND_EXTENSIONS[i]);
            ++i;
        }
        i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                files.add(String.valueOf(this.segment) + ".f" + i);
            }
            ++i;
        }
        if (this.fieldInfos.hasVectors()) {
            i = 0;
            while (i < VECTOR_EXTENSIONS.length) {
                files.add(String.valueOf(this.segment) + "." + VECTOR_EXTENSIONS[i]);
                ++i;
            }
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
        it = files.iterator();
        while (it.hasNext()) {
            this.directory.deleteFile((String)it.next());
        }
    }

    private final int mergeFields() throws IOException {
        this.fieldInfos = new FieldInfos();
        int docCount = 0;
        int i = 0;
        while (i < this.readers.size()) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            this.fieldInfos.addIndexed(reader.getIndexedFieldNames(true), true);
            this.fieldInfos.addIndexed(reader.getIndexedFieldNames(false), false);
            this.fieldInfos.add(reader.getFieldNames(false), false);
            ++i;
        }
        this.fieldInfos.write(this.directory, String.valueOf(this.segment) + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int i2 = 0;
            while (i2 < this.readers.size()) {
                IndexReader reader = (IndexReader)this.readers.elementAt(i2);
                int maxDoc = reader.maxDoc();
                int j = 0;
                while (j < maxDoc) {
                    if (!reader.isDeleted(j)) {
                        fieldsWriter.addDocument(reader.document(j));
                        ++docCount;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        finally {
            fieldsWriter.close();
        }
        return docCount;
    }

    private final void mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            int r = 0;
            while (r < this.readers.size()) {
                IndexReader reader = (IndexReader)this.readers.elementAt(r);
                int maxDoc = reader.maxDoc();
                int docNum = 0;
                while (docNum < maxDoc) {
                    if (!reader.isDeleted(docNum)) {
                        termVectorsWriter.openDocument();
                        TermFreqVector[] sourceTermVector = reader.getTermFreqVectors(docNum);
                        if (sourceTermVector != null) {
                            int f = 0;
                            while (f < sourceTermVector.length) {
                                TermFreqVector termVector = sourceTermVector[f];
                                termVectorsWriter.openField(termVector.getField());
                                String[] terms = termVector.getTerms();
                                int[] freqs = termVector.getTermFrequencies();
                                int t = 0;
                                while (t < terms.length) {
                                    termVectorsWriter.addTerm(terms[t], freqs[t]);
                                    ++t;
                                }
                                ++f;
                            }
                            termVectorsWriter.closeDocument();
                        }
                    }
                    ++docNum;
                }
                ++r;
            }
        }
        finally {
            termVectorsWriter.close();
        }
    }

    private final void mergeTerms() throws IOException {
        try {
            this.freqOutput = this.directory.createFile(String.valueOf(this.segment) + ".frq");
            this.proxOutput = this.directory.createFile(String.valueOf(this.segment) + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos);
            this.skipInterval = this.termInfosWriter.skipInterval;
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws IOException {
        int base = 0;
        int i = 0;
        while (i < this.readers.size()) {
            IndexReader reader = (IndexReader)this.readers.elementAt(i);
            TermEnum termEnum = reader.terms();
            SegmentMergeInfo smi = new SegmentMergeInfo(base, termEnum, reader);
            base += reader.numDocs();
            if (smi.next()) {
                this.queue.put(smi);
            } else {
                smi.close();
            }
            ++i;
        }
        SegmentMergeInfo[] match = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int matchSize = 0;
            match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
            Term term = match[0].term;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            while (top != null && term.compareTo(top.term) == 0) {
                match[matchSize++] = (SegmentMergeInfo)this.queue.pop();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo(match, matchSize);
            while (matchSize > 0) {
                SegmentMergeInfo smi;
                if ((smi = match[--matchSize]).next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] smis, int n) throws IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        int df = this.appendPostings(smis, n);
        long skipPointer = this.writeSkip();
        if (df > 0) {
            this.termInfo.set(df, freqPointer, proxPointer, (int)(skipPointer - freqPointer));
            this.termInfosWriter.add(smis[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] smis, int n) throws IOException {
        int lastDoc = 0;
        int df = 0;
        this.resetSkip();
        int i = 0;
        while (i < n) {
            SegmentMergeInfo smi = smis[i];
            TermPositions postings = smi.postings;
            int base = smi.base;
            int[] docMap = smi.docMap;
            postings.seek(smi.termEnum);
            while (postings.next()) {
                int doc = postings.doc();
                if (docMap != null) {
                    doc = docMap[doc];
                }
                if ((doc += base) < lastDoc) {
                    throw new IllegalStateException("docs out of order");
                }
                if (++df % this.skipInterval == 0) {
                    this.bufferSkip(lastDoc);
                }
                int docCode = doc - lastDoc << 1;
                lastDoc = doc;
                int freq = postings.freq();
                if (freq == 1) {
                    this.freqOutput.writeVInt(docCode | 1);
                } else {
                    this.freqOutput.writeVInt(docCode);
                    this.freqOutput.writeVInt(freq);
                }
                int lastPosition = 0;
                int j = 0;
                while (j < freq) {
                    int position = postings.nextPosition();
                    this.proxOutput.writeVInt(position - lastPosition);
                    lastPosition = position;
                    ++j;
                }
            }
            ++i;
        }
        return df;
    }

    private void resetSkip() throws IOException {
        this.skipBuffer.reset();
        this.lastSkipDoc = 0;
        this.lastSkipFreqPointer = this.freqOutput.getFilePointer();
        this.lastSkipProxPointer = this.proxOutput.getFilePointer();
    }

    private void bufferSkip(int doc) throws IOException {
        long freqPointer = this.freqOutput.getFilePointer();
        long proxPointer = this.proxOutput.getFilePointer();
        this.skipBuffer.writeVInt(doc - this.lastSkipDoc);
        this.skipBuffer.writeVInt((int)(freqPointer - this.lastSkipFreqPointer));
        this.skipBuffer.writeVInt((int)(proxPointer - this.lastSkipProxPointer));
        this.lastSkipDoc = doc;
        this.lastSkipFreqPointer = freqPointer;
        this.lastSkipProxPointer = proxPointer;
    }

    private long writeSkip() throws IOException {
        long skipPointer = this.freqOutput.getFilePointer();
        this.skipBuffer.writeTo(this.freqOutput);
        return skipPointer;
    }

    private void mergeNorms() throws IOException {
        int i = 0;
        while (i < this.fieldInfos.size()) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed) {
                OutputStream output = this.directory.createFile(String.valueOf(this.segment) + ".f" + i);
                try {
                    int j = 0;
                    while (j < this.readers.size()) {
                        IndexReader reader = (IndexReader)this.readers.elementAt(j);
                        byte[] input = reader.norms(fi.name);
                        int maxDoc = reader.maxDoc();
                        int k = 0;
                        while (k < maxDoc) {
                            byte norm;
                            byte by = norm = input != null ? input[k] : (byte)0;
                            if (!reader.isDeleted(k)) {
                                output.writeByte(norm);
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                finally {
                    output.close();
                }
            }
            ++i;
        }
    }
}

