/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public int counter = 0;
    private long version = 0L;

    SegmentInfos() {
    }

    public final SegmentInfo info(int i) {
        return (SegmentInfo)this.elementAt(i);
    }

    public final void read(Directory directory) throws IOException {
        InputStream input = directory.openFile("segments");
        try {
            int format = input.readInt();
            if (format < 0) {
                if (format < -1) {
                    throw new IOException("Unknown format version: " + format);
                }
                this.version = input.readLong();
                this.counter = input.readInt();
            } else {
                this.counter = format;
            }
            int i = input.readInt();
            while (i > 0) {
                SegmentInfo si = new SegmentInfo(input.readString(), input.readInt(), directory);
                this.addElement(si);
                --i;
            }
            if (format >= 0) {
                this.version = input.getFilePointer() >= input.length() ? 0L : input.readLong();
            }
        }
        finally {
            input.close();
        }
    }

    public final void write(Directory directory) throws IOException {
        OutputStream output = directory.createFile("segments.new");
        try {
            output.writeInt(-1);
            output.writeLong(++this.version);
            output.writeInt(this.counter);
            output.writeInt(this.size());
            int i = 0;
            while (i < this.size()) {
                SegmentInfo si = this.info(i);
                output.writeString(si.name);
                output.writeInt(si.docCount);
                ++i;
            }
        }
        finally {
            output.close();
        }
        directory.renameFile("segments.new", "segments");
    }

    public long getVersion() {
        return this.version;
    }

    public static long readCurrentVersion(Directory directory) throws IOException {
        InputStream input = directory.openFile("segments");
        int format = 0;
        long version = 0L;
        try {
            format = input.readInt();
            if (format < 0) {
                if (format < -1) {
                    throw new IOException("Unknown format version: " + format);
                }
                version = input.readLong();
            }
        }
        finally {
            input.close();
        }
        if (format < 0) {
            return version;
        }
        SegmentInfos sis = new SegmentInfos();
        sis.read(directory);
        return sis.getVersion();
    }
}

