/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;

final class FieldsReader {
    private FieldInfos fieldInfos;
    private InputStream fieldsStream;
    private InputStream indexStream;
    private int size;

    FieldsReader(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.openFile(String.valueOf(segment) + ".fdt");
        this.indexStream = d.openFile(String.valueOf(segment) + ".fdx");
        this.size = (int)(this.indexStream.length() / 8L);
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n) throws IOException {
        this.indexStream.seek((long)n * 8L);
        long position = this.indexStream.readLong();
        this.fieldsStream.seek(position);
        Document doc = new Document();
        int numFields = this.fieldsStream.readVInt();
        int i = 0;
        while (i < numFields) {
            int fieldNumber = this.fieldsStream.readVInt();
            FieldInfo fi = this.fieldInfos.fieldInfo(fieldNumber);
            byte bits = this.fieldsStream.readByte();
            doc.add(new Field(fi.name, this.fieldsStream.readString(), true, fi.isIndexed, (bits & 1) != 0, fi.storeTermVector));
            ++i;
        }
        return doc;
    }
}

