/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class WordlistLoader {
    public static HashSet getWordSet(File wordfile) throws IOException {
        HashSet<String> result = new HashSet<String>();
        FileReader freader = null;
        BufferedReader lnr = null;
        try {
            freader = new FileReader(wordfile);
            lnr = new LineNumberReader(freader);
            String word = null;
            while ((word = ((LineNumberReader)lnr).readLine()) != null) {
                result.add(word.trim());
            }
        }
        finally {
            if (lnr != null) {
                lnr.close();
            }
            if (freader != null) {
                freader.close();
            }
        }
        return result;
    }

    public static Hashtable getWordtable(String path, String wordfile) throws IOException {
        return WordlistLoader.getWordtable(new File(path, wordfile));
    }

    public static Hashtable getWordtable(String wordfile) throws IOException {
        return WordlistLoader.getWordtable(new File(wordfile));
    }

    public static Hashtable getWordtable(File wordfile) throws IOException {
        HashSet wordSet = WordlistLoader.getWordSet(wordfile);
        Hashtable result = WordlistLoader.makeWordTable(wordSet);
        return result;
    }

    private static Hashtable makeWordTable(HashSet wordSet) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = wordSet.iterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            table.put(word, word);
        }
        return table;
    }
}

