/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaDefaults;
import org.gjt.sp.jedit.textarea.TextAreaHighlight;

public class Gutter
extends JComponent
implements SwingConstants {
    private JEditTextArea textArea;
    private JPopupMenu context;
    private TextAreaHighlight highlights;
    private int baseline = 0;
    private int ileft = 0;
    private Dimension gutterSize = new Dimension(0, 0);
    private Dimension collapsedSize = new Dimension(0, 0);
    private Color intervalHighlight;
    private FontMetrics fm;
    private int alignment;
    private int interval = 0;
    private boolean lineNumberingEnabled = true;
    private boolean collapsed = false;

    public Gutter(JEditTextArea textArea, TextAreaDefaults defaults) {
        this.textArea = textArea;
        this.setBackground(defaults.gutterBgColor);
        this.setForeground(defaults.gutterFgColor);
        this.setHighlightedForeground(defaults.gutterHighlightColor);
        this.setFont(defaults.gutterFont);
        this.setBorder(defaults.gutterBorderWidth, defaults.gutterBorderColor);
        this.setLineNumberAlignment(defaults.gutterNumberAlignment);
        this.setGutterWidth(defaults.gutterWidth);
        this.setCollapsed(defaults.gutterCollapsed);
        GutterMouseListener ml = new GutterMouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void paintComponent(Graphics gfx) {
        if (!this.collapsed) {
            Rectangle r = gfx.getClipBounds();
            gfx.setColor(this.getBackground());
            gfx.fillRect(r.x, r.y, r.width, r.height);
            if (this.highlights != null) {
                this.paintCustomHighlights(gfx);
            }
            if (this.lineNumberingEnabled) {
                this.paintLineNumbers(gfx);
            }
        }
    }

    protected void paintLineNumbers(Graphics gfx) {
        FontMetrics pfm = this.textArea.getPainter().getFontMetrics();
        int lineHeight = pfm.getHeight();
        int baseline = (int)Math.round((double)(this.baseline + lineHeight - pfm.getMaxDescent()) / 2.0);
        int firstLine = this.textArea.getFirstLine() + 1;
        int lastLine = firstLine + this.getHeight() / lineHeight;
        int firstValidLine = Math.max(1, firstLine);
        int lastValidLine = Math.min(this.textArea.getLineCount(), lastLine);
        gfx.setFont(this.getFont());
        gfx.setColor(this.getForeground());
        int line = firstLine;
        while (line <= lastLine) {
            if (line >= firstValidLine && line <= lastValidLine) {
                int offset;
                String number = Integer.toString(line);
                switch (this.alignment) {
                    case 4: {
                        offset = this.gutterSize.width - this.collapsedSize.width - (this.fm.stringWidth(number) + 1);
                        break;
                    }
                    case 0: {
                        offset = (this.gutterSize.width - this.collapsedSize.width - this.fm.stringWidth(number)) / 2;
                        break;
                    }
                    default: {
                        offset = 1;
                    }
                }
                if (this.interval > 1 && line % this.interval == 0) {
                    gfx.setColor(this.getHighlightedForeground());
                    gfx.drawString(number, this.ileft + offset, baseline);
                    gfx.setColor(this.getForeground());
                } else {
                    gfx.drawString(number, this.ileft + offset, baseline);
                }
            }
            ++line;
            baseline += lineHeight;
        }
    }

    protected void paintCustomHighlights(Graphics gfx) {
        int lineHeight = this.textArea.getPainter().getFontMetrics().getHeight();
        int firstLine = this.textArea.getFirstLine();
        int lastLine = firstLine + this.getHeight() / lineHeight;
        int y = 0;
        int line = firstLine;
        while (line < lastLine) {
            this.highlights.paintHighlight(gfx, line, y);
            ++line;
            y += lineHeight;
        }
    }

    public void addCustomHighlight(TextAreaHighlight highlight) {
        highlight.init(this.textArea, this.highlights);
        this.highlights = highlight;
    }

    public void setBorder(int width, Color color) {
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, width, color));
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        if (border == null) {
            this.ileft = 0;
            this.collapsedSize.width = 0;
            this.collapsedSize.height = 0;
        } else {
            Insets insets = border.getBorderInsets(this);
            this.ileft = insets.left;
            this.collapsedSize.width = insets.left + insets.right;
            this.collapsedSize.height = insets.top + insets.bottom;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.baseline = this.fm.getHeight() - this.fm.getMaxDescent();
    }

    public void setHighlightedForeground(Color highlight) {
        this.intervalHighlight = highlight;
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setGutterWidth(int width) {
        if (width < this.collapsedSize.width) {
            width = this.collapsedSize.width;
        }
        this.gutterSize.width = width;
        if (!this.collapsed) {
            this.textArea.revalidate();
        }
    }

    public int getGutterWidth() {
        return this.gutterSize.width;
    }

    public Dimension getPreferredSize() {
        if (this.collapsed) {
            return this.collapsedSize;
        }
        return this.gutterSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getToolTipText(MouseEvent evt) {
        return this.highlights == null ? null : this.highlights.getToolTipText(evt);
    }

    public boolean isLineNumberingEnabled() {
        return this.lineNumberingEnabled;
    }

    public void setLineNumberingEnabled(boolean enabled) {
        if (this.lineNumberingEnabled == enabled) {
            return;
        }
        this.lineNumberingEnabled = enabled;
        this.repaint();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.repaint();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        this.textArea.revalidate();
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.collapsed);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int interval) {
        if (interval <= 1) {
            interval = 0;
        }
        this.interval = interval;
        this.repaint();
    }

    public JPopupMenu getContextMenu() {
        return this.context;
    }

    public void setContextMenu(JPopupMenu context) {
        this.context = context;
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point dragStart = null;
        private int startWidth = 0;

        GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int count = e.getClickCount();
            if (count == 1) {
                if (Gutter.this.context == null || Gutter.this.context.isVisible()) {
                    return;
                }
                if ((e.getModifiers() & 4) != 0) {
                    Gutter.this.textArea.requestFocus();
                    Gutter.this.context.show(Gutter.this, e.getX(), e.getY());
                }
            } else if (count >= 2) {
                Gutter.this.toggleCollapsed();
            }
        }

        public void mousePressed(MouseEvent e) {
            this.dragStart = e.getPoint();
            this.startWidth = ((Gutter)Gutter.this).gutterSize.width;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragStart == null) {
                return;
            }
            if (Gutter.this.isCollapsed()) {
                Gutter.this.setCollapsed(false);
            }
            Point p = e.getPoint();
            ((Gutter)Gutter.this).gutterSize.width = this.startWidth + p.x - this.dragStart.x;
            if (((Gutter)Gutter.this).gutterSize.width < ((Gutter)Gutter.this).collapsedSize.width) {
                ((Gutter)Gutter.this).gutterSize.width = this.startWidth;
                Gutter.this.setCollapsed(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Gutter.this.textArea.revalidate();
                }
            });
        }

        public void mouseExited(MouseEvent e) {
            if (this.dragStart != null && this.dragStart.x > e.getPoint().x) {
                Gutter.this.setCollapsed(true);
                ((Gutter)Gutter.this).gutterSize.width = this.startWidth;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Gutter.this.textArea.revalidate();
                    }
                });
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.dragStart = null;
        }
    }
}

