/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class PostScriptTokenMarker
extends TokenMarker {
    private static KeywordMap psKeywords;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public PostScriptTokenMarker() {
        this(PostScriptTokenMarker.getKeywords());
    }

    public PostScriptTokenMarker(KeywordMap keywords) {
        this.keywords = keywords;
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int braceCount = lineIndex == 0 ? 0 : (Integer)this.lineInfo[lineIndex - 1].obj;
        int i = offset;
        block19: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            char c1 = i1 < array.length ? array[i1] : (char)' ';
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        backslash = false;
                        switch (c) {
                            case '(': {
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)3;
                                this.lastOffset = this.lastKeyword = i;
                                braceCount = 1;
                                break;
                            }
                            case '<': {
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)4;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '/': {
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, token);
                                token = (byte)5;
                                this.lastOffset = this.lastKeyword = i;
                                break;
                            }
                            case '%': {
                                this.doKeyword(line, i, c);
                                if (length - i <= 1) break block0;
                                switch (array[i1]) {
                                    case '!': 
                                    case '%': 
                                    case '?': {
                                        this.addToken(i - this.lastOffset, token);
                                        this.addToken(length - i, (byte)2);
                                        this.lastOffset = this.lastKeyword = length;
                                        break;
                                    }
                                    default: {
                                        this.addToken(i - this.lastOffset, token);
                                        this.addToken(length - i, (byte)1);
                                        this.lastOffset = this.lastKeyword = length;
                                        break;
                                    }
                                }
                                break block19;
                            }
                            default: {
                                if (!Character.isWhitespace(c) && c1 != '[' && c1 != ']' && c1 != '{' && c1 != 125) break block0;
                                this.doKeyword(line, i, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        switch (c) {
                            case ')': {
                                if (--braceCount > 0) break block0;
                                this.addToken(i1 - this.lastOffset, token);
                                token = 0;
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            case '(': {
                                ++braceCount;
                            }
                        }
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '>') break;
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    case 5: {
                        if (!Character.isWhitespace(c1) && c1 != '[' && c1 != ']' && c1 != '{' && c1 != 125) break;
                        this.addToken(i1 - this.lastOffset, token);
                        token = 0;
                        this.lastOffset = this.lastKeyword = i1;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        this.addToken(length - this.lastOffset, token);
        this.lineInfo[lineIndex].obj = new Integer(braceCount);
        return token;
    }

    public static KeywordMap getKeywords() {
        if (psKeywords == null) {
            psKeywords = new KeywordMap(false);
            psKeywords.add("pop", (byte)6);
            psKeywords.add("exch", (byte)6);
            psKeywords.add("dup", (byte)6);
            psKeywords.add("copy", (byte)6);
            psKeywords.add("roll", (byte)6);
            psKeywords.add("clear", (byte)6);
            psKeywords.add("count", (byte)6);
            psKeywords.add("mark", (byte)6);
            psKeywords.add("cleartomark", (byte)6);
            psKeywords.add("counttomark", (byte)6);
            psKeywords.add("exec", (byte)6);
            psKeywords.add("if", (byte)6);
            psKeywords.add("ifelse", (byte)6);
            psKeywords.add("for", (byte)6);
            psKeywords.add("repeat", (byte)6);
            psKeywords.add("loop", (byte)6);
            psKeywords.add("exit", (byte)6);
            psKeywords.add("stop", (byte)6);
            psKeywords.add("stopped", (byte)6);
            psKeywords.add("countexecstack", (byte)6);
            psKeywords.add("execstack", (byte)6);
            psKeywords.add("quit", (byte)6);
            psKeywords.add("start", (byte)6);
            psKeywords.add("add", (byte)9);
            psKeywords.add("div", (byte)9);
            psKeywords.add("idiv", (byte)9);
            psKeywords.add("mod", (byte)9);
            psKeywords.add("mul", (byte)9);
            psKeywords.add("sub", (byte)9);
            psKeywords.add("abs", (byte)9);
            psKeywords.add("ned", (byte)9);
            psKeywords.add("ceiling", (byte)9);
            psKeywords.add("floor", (byte)9);
            psKeywords.add("round", (byte)9);
            psKeywords.add("truncate", (byte)9);
            psKeywords.add("sqrt", (byte)9);
            psKeywords.add("atan", (byte)9);
            psKeywords.add("cos", (byte)9);
            psKeywords.add("sin", (byte)9);
            psKeywords.add("exp", (byte)9);
            psKeywords.add("ln", (byte)9);
            psKeywords.add("log", (byte)9);
            psKeywords.add("rand", (byte)9);
            psKeywords.add("srand", (byte)9);
            psKeywords.add("rrand", (byte)9);
            psKeywords.add("true", (byte)4);
            psKeywords.add("false", (byte)4);
            psKeywords.add("NULL", (byte)4);
        }
        return psKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

