/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.AllBufferSet;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.RESearchMatcher;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.InputHandler;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class SearchAndReplace {
    private static String search;
    private static String replace;
    private static boolean regexp;
    private static boolean ignoreCase;
    private static SearchMatcher matcher;
    private static SearchFileSet fileset;

    public static void setSearchString(String search) {
        SearchAndReplace.search = search;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getSearchString() {
        return search;
    }

    public static void setReplaceString(String replace) {
        SearchAndReplace.replace = replace;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getReplaceString() {
        return replace;
    }

    public static void setIgnoreCase(boolean ignoreCase) {
        SearchAndReplace.ignoreCase = ignoreCase;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setRegexp(boolean regexp2) {
        regexp = regexp2;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getRegexp() {
        return regexp;
    }

    public static void setSearchMatcher(SearchMatcher matcher) {
        SearchAndReplace.matcher = matcher;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchMatcher getSearchMatcher() throws IllegalArgumentException {
        if (matcher != null) {
            return matcher;
        }
        if (search == null || "".equals(search)) {
            return null;
        }
        matcher = regexp ? new RESearchMatcher(search, replace, ignoreCase) : new BoyerMooreSearchMatcher(search, replace, ignoreCase);
        return matcher;
    }

    public static void setSearchFileSet(SearchFileSet fileset) {
        SearchAndReplace.fileset = fileset;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchFileSet getSearchFileSet() {
        return fileset;
    }

    public static boolean find(View view) {
        block14: {
            boolean repeat2 = false;
            Buffer buffer = fileset.getNextBuffer(view, null);
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                view.getToolkit().beep();
                return false;
            }
            SearchAndReplace.record(view, "find-next");
            view.showWaitCursor();
            while (true) {
                while (buffer != null) {
                    int start = view.getBuffer() == buffer && !repeat2 ? view.getTextArea().getSelectionEnd() : 0;
                    if (SearchAndReplace.find(view, buffer, start)) {
                        return true;
                    }
                    buffer = fileset.getNextBuffer(view, buffer);
                }
                if (repeat2) {
                    view.getToolkit().beep();
                    return false;
                }
                try {
                    int result = JOptionPane.showConfirmDialog(view, jEdit.getProperty("keepsearching.message"), jEdit.getProperty("keepsearching.title"), 0, 3);
                    if (result == 0) {
                        buffer = fileset.getFirstBuffer(view);
                        repeat2 = true;
                        continue;
                    }
                    break block14;
                }
                catch (Exception e) {
                    Log.log(9, SearchAndReplace.class, e);
                    Object[] args = new Object[]{e.getMessage()};
                    if (args[0] == null) {
                        args[0] = e.toString();
                    }
                    GUIUtilities.error(view, "searcherror", args);
                    break block14;
                }
            }
            finally {
                view.hideWaitCursor();
            }
        }
        return false;
    }

    public static boolean find(View view, Buffer buffer, int start) throws BadLocationException, IllegalArgumentException {
        SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
        buffer.loadIfNecessary(view);
        String text = buffer.getText(start, buffer.getLength() - start);
        int[] match = matcher.nextMatch(text);
        if (match != null) {
            fileset.matchFound(buffer);
            view.setBuffer(buffer);
            view.getTextArea().select(start + match[0], start + match[1]);
            return true;
        }
        return false;
    }

    public static boolean replace(View view) {
        String replacement;
        boolean rect;
        int selStart;
        JEditTextArea textArea;
        block7: {
            SearchMatcher matcher;
            block6: {
                textArea = view.getTextArea();
                selStart = textArea.getSelectionStart();
                rect = textArea.isSelectionRectangular();
                if (selStart == textArea.getSelectionEnd()) {
                    view.getToolkit().beep();
                    return false;
                }
                SearchAndReplace.record(view, "replace-in-selection");
                try {
                    matcher = SearchAndReplace.getSearchMatcher();
                    if (matcher != null) break block6;
                    view.getToolkit().beep();
                    return false;
                }
                catch (Exception e) {
                    Log.log(9, SearchAndReplace.class, e);
                    Object[] args = new Object[]{e.getMessage()};
                    if (args[0] == null) {
                        args[0] = e.toString();
                    }
                    GUIUtilities.error(view, "searcherror", args);
                    return false;
                }
            }
            replacement = matcher.substitute(textArea.getSelectedText());
            if (replacement != null) break block7;
            return false;
        }
        textArea.setSelectedText(replacement);
        textArea.setSelectionStart(selStart);
        textArea.setSelectionRectangular(rect);
        return true;
    }

    public static boolean replaceAll(View view) {
        int fileCount;
        int lineCount;
        block12: {
            lineCount = 0;
            fileCount = 0;
            SearchAndReplace.record(view, "replace-all");
            view.showWaitCursor();
            try {
                try {
                    Buffer buffer = fileset.getFirstBuffer(view);
                    do {
                        try {
                            buffer.beginCompoundEdit();
                            int retVal = SearchAndReplace.replaceAll(view, buffer);
                            if (retVal == 0) continue;
                            ++fileCount;
                            lineCount += retVal;
                            fileset.matchFound(buffer);
                        }
                        finally {
                            buffer.endCompoundEdit();
                        }
                    } while ((buffer = fileset.getNextBuffer(view, buffer)) != null);
                }
                catch (Exception e) {
                    Log.log(9, SearchAndReplace.class, e);
                    Object[] args = new Object[]{e.getMessage()};
                    if (args[0] == null) {
                        args[0] = e.toString();
                    }
                    GUIUtilities.error(view, "searcherror", args);
                    view.hideWaitCursor();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                view.hideWaitCursor();
                throw throwable;
            }
            view.hideWaitCursor();
        }
        if (fileCount == 0) {
            view.getToolkit().beep();
        } else {
            Object[] args = new Object[]{new Integer(lineCount), new Integer(fileCount)};
            GUIUtilities.message(view, "replace-results", args);
        }
        return fileCount != 0;
    }

    public static int replaceAll(View view, Buffer buffer) throws BadLocationException {
        if (!view.getTextArea().isEditable()) {
            return 0;
        }
        SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
        if (matcher == null) {
            return 0;
        }
        buffer.loadIfNecessary(view);
        int lineCount = 0;
        Element map = buffer.getDefaultRootElement();
        int i = 0;
        while (i < map.getElementCount()) {
            int lineEnd;
            Element lineElement = map.getElement(i);
            int lineStart = lineElement.getStartOffset();
            String line = buffer.getText(lineStart, lineEnd = lineElement.getEndOffset() - lineStart - 1);
            String newLine = matcher.substitute(line);
            if (newLine != null) {
                buffer.remove(lineStart, lineEnd);
                buffer.insertString(lineStart, newLine, null);
                ++lineCount;
            }
            ++i;
        }
        return lineCount;
    }

    public static void load() {
        fileset = new CurrentBufferSet();
        search = jEdit.getProperty("search.find.value");
        replace = jEdit.getProperty("search.replace.value");
        regexp = "on".equals(jEdit.getProperty("search.regexp.toggle"));
        ignoreCase = "on".equals(jEdit.getProperty("search.ignoreCase.toggle"));
    }

    public static void save() {
        jEdit.setProperty("search.find.value", search);
        jEdit.setProperty("search.replace.value", replace);
        jEdit.setProperty("search.ignoreCase.toggle", ignoreCase ? "on" : "off");
        jEdit.setProperty("search.regexp.toggle", regexp ? "on" : "off");
    }

    private static void record(View view, String action) {
        InputHandler.MacroRecorder recorder = view.getTextArea().getInputHandler().getMacroRecorder();
        if (recorder != null) {
            recorder.actionPerformed(jEdit.getAction("set-search-string"), search);
            recorder.actionPerformed(jEdit.getAction("set-replace-string"), replace);
            StringBuffer buf = new StringBuffer();
            if (regexp) {
                buf.append("regexp ");
            } else {
                buf.append("literal ");
            }
            if (ignoreCase) {
                buf.append("icase");
            } else {
                buf.append("case");
            }
            if (fileset instanceof CurrentBufferSet) {
                buf.append(" current");
            } else if (fileset instanceof AllBufferSet) {
                buf.append(" all");
            }
            recorder.actionPerformed(jEdit.getAction("set-search-parameters"), buf.toString());
            recorder.actionPerformed(jEdit.getAction(action), null);
        }
    }
}

