/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.io.File;
import java.util.Vector;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.REFileFilter;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;

public class DirectoryListSet
extends BufferListSet {
    public DirectoryListSet(String directory, String glob, boolean recurse) {
        super(DirectoryListSet.listFiles(directory, glob, recurse));
    }

    private static Vector listFiles(String directory, String glob, boolean recurse) {
        REFileFilter filter;
        Log.log(1, DirectoryListSet.class, "Searching in " + directory);
        Vector files = new Vector(50);
        try {
            filter = new REFileFilter(MiscUtilities.globToRE(glob));
        }
        catch (Exception e) {
            Log.log(9, DirectoryListSet.class, e);
            filter = null;
        }
        DirectoryListSet.listFiles(new Vector(), files, new File(directory), filter, recurse);
        return files;
    }

    private static void listFiles(Vector stack, Vector files, File directory, REFileFilter filter, boolean recurse) {
        if (stack.contains(directory)) {
            Log.log(9, DirectoryListSet.class, "Recursion in DirectoryListSet: " + directory.getPath());
            return;
        }
        stack.addElement(directory);
        String[] _files = directory.list(filter);
        if (_files == null) {
            return;
        }
        int i = 0;
        while (i < _files.length) {
            File file = new File(directory, _files[i]);
            if (file.isDirectory()) {
                if (recurse) {
                    DirectoryListSet.listFiles(stack, files, file, filter, recurse);
                }
            } else {
                Log.log(1, DirectoryListSet.class, file.getPath());
                files.addElement(MiscUtilities.constructPath(null, file.getPath()));
            }
            ++i;
        }
    }
}

