/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.proto.jeditresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.gjt.sp.jedit.JARClassLoader;

public class PluginResURLConnection
extends URLConnection {
    private InputStream in;

    public PluginResURLConnection(URL url) throws IOException {
        super(url);
        String file = url.getFile();
        int index = file.indexOf(47, 1);
        if (index == -1) {
            throw new IOException("Invalid plugin resource URL");
        }
        int start = file.charAt(0) == '/' ? 1 : 0;
        int pluginIndex = Integer.parseInt(file.substring(start, index));
        this.in = JARClassLoader.getClassLoader(pluginIndex).getResourceAsStream(file.substring(index + 1));
    }

    public void connect() {
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getHeaderField(String name) {
        if (name.equals("content-type")) {
            String filename = this.getURL().getFile().toLowerCase();
            if (filename.endsWith(".html")) {
                return "text/html";
            }
            if (filename.endsWith(".txt")) {
                return "text/plain";
            }
            if (filename.endsWith(".rtf")) {
                return "text/rtf";
            }
            if (filename.endsWith(".gif")) {
                return "image/gif";
            }
            if (filename.endsWith(".jpg") || filename.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            return null;
        }
        return null;
    }
}

