/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.StyleOptionPane;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

class StyleTableModel
extends AbstractTableModel {
    private Vector styleChoices = new Vector(10);

    StyleTableModel() {
        this.addStyleChoice("options.styles.comment1Style", "view.style.comment1");
        this.addStyleChoice("options.styles.comment2Style", "view.style.comment2");
        this.addStyleChoice("options.styles.literal1Style", "view.style.literal1");
        this.addStyleChoice("options.styles.literal2Style", "view.style.literal2");
        this.addStyleChoice("options.styles.labelStyle", "view.style.label");
        this.addStyleChoice("options.styles.keyword1Style", "view.style.keyword1");
        this.addStyleChoice("options.styles.keyword2Style", "view.style.keyword2");
        this.addStyleChoice("options.styles.keyword3Style", "view.style.keyword3");
        this.addStyleChoice("options.styles.operatorStyle", "view.style.operator");
        this.addStyleChoice("options.styles.invalidStyle", "view.style.invalid");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.styleChoices.size();
    }

    public Object getValueAt(int row, int col) {
        StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(row);
        switch (col) {
            case 0: {
                return ch.label;
            }
            case 1: {
                return ch.style;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(row);
        if (col == 1) {
            ch.style = (SyntaxStyle)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.styles.object");
            }
            case 1: {
                return jEdit.getProperty("options.styles.style");
            }
        }
        return null;
    }

    public void save() {
        int i = 0;
        while (i < this.styleChoices.size()) {
            StyleChoice ch = (StyleChoice)this.styleChoices.elementAt(i);
            jEdit.setProperty(ch.property, GUIUtilities.getStyleString(ch.style));
            ++i;
        }
    }

    private void addStyleChoice(String label, String property) {
        this.styleChoices.addElement(new StyleChoice(jEdit.getProperty(label), property, GUIUtilities.parseStyle(jEdit.getProperty(property))));
    }

    static class StyleChoice {
        String label;
        String property;
        SyntaxStyle style;

        StyleChoice(String label, String property, SyntaxStyle style) {
            this.label = label;
            this.property = property;
            this.style = style;
        }
    }

    static class StyleRenderer
    extends JLabel
    implements TableCellRenderer {
        public StyleRenderer() {
            this.setOpaque(true);
            this.setBorder(StyleOptionPane.noFocusBorder);
            this.setText("Hello World");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                SyntaxStyle style = (SyntaxStyle)value;
                this.setForeground(style.getColor());
                this.setFont(style.getStyledFont(this.getFont()));
            }
            this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : StyleOptionPane.noFocusBorder);
            return this;
        }
    }
}

