/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ColorTableModel;
import org.gjt.sp.jedit.options.StyleEditor;
import org.gjt.sp.jedit.options.StyleTableModel;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

public class StyleOptionPane
extends AbstractOptionPane {
    public static final EmptyBorder noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private ColorTableModel colorModel;
    private JTable colorTable;
    private StyleTableModel styleModel;
    private JTable styleTable;

    public StyleOptionPane() {
        super("styles");
        this.setLayout(new GridLayout(2, 1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("North", new JLabel(jEdit.getProperty("options.styles.colors")));
        panel.add("Center", this.createColorTableScroller());
        this.add(panel);
        this.setLayout(new GridLayout(2, 1));
        panel = new JPanel(new BorderLayout());
        panel.add("North", new JLabel(jEdit.getProperty("options.styles.styles")));
        panel.add("Center", this.createStyleTableScroller());
        this.add(panel);
    }

    public void save() {
        this.colorModel.save();
        this.styleModel.save();
    }

    private JScrollPane createColorTableScroller() {
        this.colorModel = this.createColorTableModel();
        this.colorTable = new JTable(this.colorModel);
        this.colorTable.getTableHeader().setReorderingAllowed(false);
        this.colorTable.getSelectionModel().addListSelectionListener(new ListHandler(this.colorTable));
        TableColumnModel tcm = this.colorTable.getColumnModel();
        TableColumn colorColumn = tcm.getColumn(1);
        colorColumn.setCellRenderer(new ColorTableModel.ColorRenderer());
        Dimension d = this.colorTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.colorTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private ColorTableModel createColorTableModel() {
        return new ColorTableModel();
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = this.createStyleTableModel();
        this.styleTable = new JTable(this.styleModel);
        this.styleTable.getTableHeader().setReorderingAllowed(false);
        this.styleTable.getSelectionModel().addListSelectionListener(new ListHandler(this.styleTable));
        TableColumnModel tcm = this.styleTable.getColumnModel();
        TableColumn styleColumn = tcm.getColumn(1);
        styleColumn.setCellRenderer(new StyleTableModel.StyleRenderer());
        Dimension d = this.styleTable.getPreferredSize();
        d.height = Math.min(d.height, 100);
        JScrollPane scroller = new JScrollPane(this.styleTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private StyleTableModel createStyleTableModel() {
        return new StyleTableModel();
    }

    class ListHandler
    implements ListSelectionListener {
        JTable table;

        ListHandler(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent evt) {
            SyntaxStyle style;
            if (evt.getValueIsAdjusting()) {
                return;
            }
            if (this.table == StyleOptionPane.this.colorTable) {
                Color color = JColorChooser.showDialog(StyleOptionPane.this, jEdit.getProperty("colorChooser.title"), (Color)StyleOptionPane.this.colorModel.getValueAt(this.table.getSelectedRow(), 1));
                if (color != null) {
                    StyleOptionPane.this.colorModel.setValueAt(color, this.table.getSelectedRow(), 1);
                }
            } else if (this.table == StyleOptionPane.this.styleTable && (style = new StyleEditor(StyleOptionPane.this, (SyntaxStyle)StyleOptionPane.this.styleModel.getValueAt(this.table.getSelectedRow(), 1)).getStyle()) != null) {
                StyleOptionPane.this.styleModel.setValueAt(style, this.table.getSelectedRow(), 1);
            }
        }
    }
}

