/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;

class StyleEditor
extends JDialog
implements ActionListener,
KeyListener {
    private JCheckBox italics;
    private JCheckBox bold;
    private JButton color;
    private JButton ok;
    private JButton cancel;
    private boolean okClicked;

    StyleEditor(Component comp, SyntaxStyle style) {
        super(JOptionPane.getFrameForComponent(comp), jEdit.getProperty("styleEditor.title"), true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.italics = new JCheckBox(jEdit.getProperty("styleEditor.italics"));
        panel.add(this.italics);
        this.italics.getModel().setSelected(style.isItalic());
        this.bold = new JCheckBox(jEdit.getProperty("styleEditor.bold"));
        panel.add(this.bold);
        this.bold.getModel().setSelected(style.isBold());
        panel.add(new JLabel(jEdit.getProperty("styleEditor.color")));
        this.color = new JButton("    ");
        panel.add(this.color);
        this.color.setBackground(style.getColor());
        this.color.setRequestFocusEnabled(false);
        this.color.addActionListener(this);
        this.getContentPane().add("Center", panel);
        panel = new JPanel();
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        panel.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        panel.add(this.cancel);
        this.cancel.addActionListener(this);
        this.getContentPane().add("South", panel);
        this.addKeyListener(this);
        this.setDefaultCloseOperation(2);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(0);
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        Color c;
        Object source = evt.getSource();
        if (source == this.ok) {
            this.okClicked = true;
            this.dispose();
        } else if (source == this.cancel) {
            this.dispose();
        } else if (source == this.color && (c = JColorChooser.showDialog(this, jEdit.getProperty("colorChooser.title"), this.color.getBackground())) != null) {
            this.color.setBackground(c);
        }
    }

    public void keyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                this.okClicked = true;
                this.dispose();
                evt.consume();
                break;
            }
            case 27: {
                this.dispose();
                evt.consume();
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public SyntaxStyle getStyle() {
        if (!this.okClicked) {
            return null;
        }
        return new SyntaxStyle(this.color.getBackground(), this.italics.getModel().isSelected(), this.bold.getModel().isSelected());
    }
}

