/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class GeneralOptionPane
extends AbstractOptionPane {
    private UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
    private JComboBox lookAndFeel;
    private JTextField recent;
    private JTextField history;
    private JComboBox encoding;
    private JTextField autosave;
    private JTextField backups;
    private JTextField backupDirectory;
    private JTextField backupPrefix;
    private JTextField backupSuffix;
    private JComboBox lineSeparator;
    private JCheckBox saveDesktop;
    private JCheckBox showToolbar;
    private JCheckBox showBufferTabs;
    private JComboBox bufferTabsPos;
    private JCheckBox showFullPath;
    private JCheckBox sortBuffers;
    private JCheckBox sortByName;

    public GeneralOptionPane() {
        super("general");
        String[] names = new String[this.lfs.length];
        String lf = UIManager.getLookAndFeel().getClass().getName();
        int index = 0;
        int i = 0;
        while (i < names.length) {
            names[i] = this.lfs[i].getName();
            if (lf.equals(this.lfs[i].getClassName())) {
                index = i;
            }
            ++i;
        }
        this.lookAndFeel = new JComboBox<String>(names);
        this.lookAndFeel.setSelectedIndex(index);
        this.addComponent(jEdit.getProperty("options.general.lf"), this.lookAndFeel);
        this.recent = new JTextField(jEdit.getProperty("recent"));
        this.addComponent(jEdit.getProperty("options.general.recent"), this.recent);
        this.history = new JTextField(jEdit.getProperty("history"));
        this.addComponent(jEdit.getProperty("options.general.history"), this.history);
        String[] encodings = new String[]{"UTF8"};
        this.encoding = new JComboBox<String>(encodings);
        this.encoding.setEditable(true);
        this.encoding.setSelectedItem("UTF-8");
        this.addComponent(jEdit.getProperty("options.general.encoding"), this.encoding);
        this.autosave = new JTextField(jEdit.getProperty("autosave"));
        this.addComponent(jEdit.getProperty("options.general.autosave"), this.autosave);
        this.backups = new JTextField(jEdit.getProperty("backups"));
        this.addComponent(jEdit.getProperty("options.general.backups"), this.backups);
        this.backupDirectory = new JTextField(jEdit.getProperty("backup.directory"));
        this.addComponent(jEdit.getProperty("options.general.backupDirectory"), this.backupDirectory);
        this.backupPrefix = new JTextField(jEdit.getProperty("backup.prefix"));
        this.addComponent(jEdit.getProperty("options.general.backupPrefix"), this.backupPrefix);
        this.backupSuffix = new JTextField(jEdit.getProperty("backup.suffix"));
        this.addComponent(jEdit.getProperty("options.general.backupSuffix"), this.backupSuffix);
        String[] lineSeps = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(lineSeps);
        String lineSep = jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator"));
        if ("\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        this.addComponent(jEdit.getProperty("options.general.lineSeparator"), this.lineSeparator);
        this.saveDesktop = new JCheckBox(jEdit.getProperty("options.general.saveDesktop"));
        this.saveDesktop.getModel().setSelected("on".equals(jEdit.getProperty("saveDesktop")));
        this.addComponent(this.saveDesktop);
        this.showToolbar = new JCheckBox(jEdit.getProperty("options.general.showToolbar"));
        this.showToolbar.getModel().setSelected("on".equals(jEdit.getProperty("view.showToolbar")));
        this.addComponent(this.showToolbar);
        this.showBufferTabs = new JCheckBox(jEdit.getProperty("options.general.showBufferTabs"));
        this.showBufferTabs.getModel().setSelected("on".equals(jEdit.getProperty("view.showBufferTabs")));
        this.addComponent(this.showBufferTabs);
        String[] positions = new String[]{"top", "left", "bottom", "right"};
        this.bufferTabsPos = new JComboBox<String>(positions);
        this.bufferTabsPos.setSelectedIndex(Integer.parseInt(jEdit.getProperty("view.bufferTabsPos")) - 1);
        this.addComponent(jEdit.getProperty("options.general.bufferTabsPos"), this.bufferTabsPos);
        this.showFullPath = new JCheckBox(jEdit.getProperty("options.general.showFullPath"));
        this.showFullPath.getModel().setSelected("on".equals(jEdit.getProperty("view.showFullPath")));
        this.addComponent(this.showFullPath);
        this.sortBuffers = new JCheckBox(jEdit.getProperty("options.general.sortBuffers"));
        this.sortBuffers.getModel().setSelected("on".equals(jEdit.getProperty("sortBuffers")));
        this.addComponent(this.sortBuffers);
        this.sortByName = new JCheckBox(jEdit.getProperty("options.general.sortByName"));
        this.sortByName.getModel().setSelected("on".equals(jEdit.getProperty("sortByName")));
        this.addComponent(this.sortByName);
    }

    public void save() {
        String lf = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
        jEdit.setProperty("lookAndFeel", lf);
        jEdit.setProperty("saveDesktop", this.saveDesktop.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("buffer.encoding", (String)this.encoding.getSelectedItem());
        jEdit.setProperty("autosave", this.autosave.getText());
        jEdit.setProperty("recent", this.recent.getText());
        jEdit.setProperty("history", this.history.getText());
        jEdit.setProperty("backups", this.backups.getText());
        jEdit.setProperty("backup.directory", this.backupDirectory.getText());
        jEdit.setProperty("backup.prefix", this.backupPrefix.getText());
        jEdit.setProperty("backup.suffix", this.backupSuffix.getText());
        String lineSep = null;
        switch (this.lineSeparator.getSelectedIndex()) {
            case 0: {
                lineSep = "\n";
                break;
            }
            case 1: {
                lineSep = "\r\n";
                break;
            }
            case 2: {
                lineSep = "\r";
            }
        }
        jEdit.setProperty("buffer.lineSeparator", lineSep);
        jEdit.setProperty("view.showToolbar", this.showToolbar.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.showBufferTabs", this.showBufferTabs.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.bufferTabsPos", String.valueOf(this.bufferTabsPos.getSelectedIndex() + 1));
        jEdit.setProperty("view.showFullPath", this.showFullPath.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("sortBuffers", this.sortBuffers.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("sortByName", this.sortByName.getModel().isSelected() ? "on" : "off");
    }
}

