/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.jEdit;

class FileFilterTableModel
extends AbstractTableModel {
    private Vector filters = new Vector();

    FileFilterTableModel() {
        String name;
        int i = 0;
        while ((name = jEdit.getProperty("filefilter." + i + ".name")) != null && name.length() != 0) {
            this.filters.addElement(new FilterEntry(name, jEdit.getProperty("filefilter." + i + ".re")));
            ++i;
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.filters.size() + 1;
    }

    public Object getValueAt(int row, int col) {
        if (row == this.filters.size()) {
            return "";
        }
        FilterEntry filter = (FilterEntry)this.filters.elementAt(row);
        switch (col) {
            case 0: {
                return filter.name;
            }
            case 1: {
                return filter.re;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        if (row == this.filters.size()) {
            String name = col == 0 ? (String)value : null;
            String re = col == 1 ? (String)value : null;
            this.filters.addElement(new FilterEntry(name, re));
            this.fireTableRowsUpdated(row, row + 1);
        } else {
            FilterEntry filter = (FilterEntry)this.filters.elementAt(row);
            switch (col) {
                case 0: {
                    filter.name = (String)value;
                    break;
                }
                case 1: {
                    filter.re = (String)value;
                }
            }
            this.fireTableRowsUpdated(row, row);
        }
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.filters.name");
            }
            case 1: {
                return jEdit.getProperty("options.filters.re");
            }
        }
        return null;
    }

    public void save() {
        int j = 0;
        int i = 0;
        while (i < this.filters.size()) {
            FilterEntry filter = (FilterEntry)this.filters.elementAt(i);
            if (filter.name != null && filter.name.length() != 0 && filter.re != null && filter.re.length() != 0) {
                jEdit.setProperty("filefilter." + j + ".name", filter.name);
                jEdit.setProperty("filefilter." + j + ".re", filter.re);
                ++j;
            }
            ++i;
        }
        jEdit.unsetProperty("filefilter." + j + ".name");
        jEdit.unsetProperty("filefilter." + j + ".re");
    }

    class FilterEntry {
        String name;
        String re;

        FilterEntry(String name, String re) {
            this.name = name;
            this.re = re;
        }
    }
}

