/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.gui.FontComboBox;
import org.gjt.sp.jedit.jEdit;

public class EditorOptionPane
extends AbstractOptionPane {
    private Mode[] modes = jEdit.getModes();
    private JComboBox defaultMode;
    private JComboBox font;
    private JComboBox style;
    private JComboBox size;
    private JComboBox tabSize;
    private JCheckBox lineHighlight;
    private JCheckBox bracketHighlight;
    private JCheckBox eolMarkers;
    private JCheckBox paintInvalid;
    private JCheckBox syntax;
    private JCheckBox indentOnTab;
    private JCheckBox indentOnEnter;
    private JCheckBox blinkCaret;
    private JCheckBox blockCaret;
    private JCheckBox electricBorders;
    private JCheckBox noTabs;
    private JCheckBox homeEnd;

    public EditorOptionPane() {
        super("editor");
        String[] modeNames = new String[this.modes.length];
        int i = 0;
        while (i < this.modes.length) {
            modeNames[i] = this.modes[i].getName();
            ++i;
        }
        this.defaultMode = new JComboBox<String>(modeNames);
        this.defaultMode.setSelectedItem(jEdit.getProperty("buffer.defaultMode"));
        this.addComponent(jEdit.getProperty("options.editor.defaultMode"), this.defaultMode);
        this.font = new FontComboBox();
        this.font.setSelectedItem(jEdit.getProperty("view.font"));
        this.addComponent(jEdit.getProperty("options.editor.font"), this.font);
        String[] styles = new String[]{jEdit.getProperty("options.editor.plain"), jEdit.getProperty("options.editor.bold"), jEdit.getProperty("options.editor.italic"), jEdit.getProperty("options.editor.boldItalic")};
        this.style = new JComboBox<String>(styles);
        try {
            this.style.setSelectedIndex(Integer.parseInt(jEdit.getProperty("view.fontstyle")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addComponent(jEdit.getProperty("options.editor.fontstyle"), this.style);
        String[] sizes = new String[]{"9", "10", "12", "14", "18", "24"};
        this.size = new JComboBox<String>(sizes);
        this.size.setEditable(true);
        this.size.setSelectedItem(jEdit.getProperty("view.fontsize"));
        this.addComponent(jEdit.getProperty("options.editor.fontsize"), this.size);
        String[] tabSizes = new String[]{"8", "4"};
        this.tabSize = new JComboBox<String>(tabSizes);
        this.tabSize.setEditable(true);
        this.tabSize.setSelectedItem(jEdit.getProperty("buffer.tabSize"));
        this.addComponent(jEdit.getProperty("options.editor.tabSize"), this.tabSize);
        this.lineHighlight = new JCheckBox(jEdit.getProperty("options.editor.lineHighlight"));
        this.lineHighlight.getModel().setSelected("on".equals(jEdit.getProperty("view.lineHighlight")));
        this.addComponent(this.lineHighlight);
        this.bracketHighlight = new JCheckBox(jEdit.getProperty("options.editor.bracketHighlight"));
        this.bracketHighlight.getModel().setSelected("on".equals(jEdit.getProperty("view.bracketHighlight")));
        this.addComponent(this.bracketHighlight);
        this.eolMarkers = new JCheckBox(jEdit.getProperty("options.editor.eolMarkers"));
        this.eolMarkers.getModel().setSelected("on".equals(jEdit.getProperty("view.eolMarkers")));
        this.addComponent(this.eolMarkers);
        this.paintInvalid = new JCheckBox(jEdit.getProperty("options.editor.paintInvalid"));
        this.paintInvalid.getModel().setSelected("on".equals(jEdit.getProperty("view.paintInvalid")));
        this.addComponent(this.paintInvalid);
        this.syntax = new JCheckBox(jEdit.getProperty("options.editor.syntax"));
        this.syntax.getModel().setSelected("on".equals(jEdit.getProperty("buffer.syntax")));
        this.addComponent(this.syntax);
        this.indentOnTab = new JCheckBox(jEdit.getProperty("options.editor.indentOnTab"));
        this.indentOnTab.getModel().setSelected("on".equals(jEdit.getProperty("buffer.indentOnTab")));
        this.addComponent(this.indentOnTab);
        this.indentOnEnter = new JCheckBox(jEdit.getProperty("options.editor.indentOnEnter"));
        this.indentOnEnter.getModel().setSelected("on".equals(jEdit.getProperty("buffer.indentOnEnter")));
        this.addComponent(this.indentOnEnter);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editor.noTabs"));
        this.noTabs.getModel().setSelected("yes".equals(jEdit.getProperty("buffer.noTabs")));
        this.addComponent(this.noTabs);
        this.blinkCaret = new JCheckBox(jEdit.getProperty("options.editor.blinkCaret"));
        this.blinkCaret.getModel().setSelected("on".equals(jEdit.getProperty("view.caretBlink")));
        this.addComponent(this.blinkCaret);
        this.blockCaret = new JCheckBox(jEdit.getProperty("options.editor.blockCaret"));
        this.blockCaret.getModel().setSelected("on".equals(jEdit.getProperty("view.blockCaret")));
        this.addComponent(this.blockCaret);
        this.electricBorders = new JCheckBox(jEdit.getProperty("options.editor.electricBorders"));
        this.electricBorders.getModel().setSelected(!"0".equals(jEdit.getProperty("view.electricBorders")));
        this.addComponent(this.electricBorders);
        this.homeEnd = new JCheckBox(jEdit.getProperty("options.editor.homeEnd"));
        this.homeEnd.getModel().setSelected("yes".equals(jEdit.getProperty("view.homeEnd")));
        this.addComponent(this.homeEnd);
    }

    public void save() {
        jEdit.setProperty("buffer.defaultMode", this.modes[this.defaultMode.getSelectedIndex()].getName());
        jEdit.setProperty("view.font", (String)this.font.getSelectedItem());
        jEdit.setProperty("view.fontsize", (String)this.size.getSelectedItem());
        jEdit.setProperty("view.fontstyle", String.valueOf(this.style.getSelectedIndex()));
        jEdit.setProperty("buffer.tabSize", (String)this.tabSize.getSelectedItem());
        jEdit.setProperty("view.lineHighlight", this.lineHighlight.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.bracketHighlight", this.bracketHighlight.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.eolMarkers", this.eolMarkers.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.paintInvalid", this.paintInvalid.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("buffer.syntax", this.syntax.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("buffer.indentOnTab", this.indentOnTab.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("buffer.indentOnEnter", this.indentOnEnter.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.caretBlink", this.blinkCaret.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.blockCaret", this.blockCaret.getModel().isSelected() ? "on" : "off");
        jEdit.setProperty("view.electricBorders", this.electricBorders.getModel().isSelected() ? "3" : "0");
        jEdit.setProperty("buffer.noTabs", this.noTabs.getModel().isSelected() ? "yes" : "no");
        jEdit.setProperty("view.homeEnd", this.homeEnd.getModel().isSelected() ? "yes" : "no");
    }
}

