/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.AbbrevsModel;

public class AbbrevsOptionPane
extends AbstractOptionPane {
    private JComboBox setsComboBox;
    private JCheckBox expandOnInput;
    private JTable abbrevsTable;
    private JButton abbrev;
    private JButton expand;
    private AbbrevsModel globalAbbrevs;
    private Hashtable modeAbbrevs;

    public AbbrevsOptionPane() {
        super("abbrevs");
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel();
        this.expandOnInput = new JCheckBox(jEdit.getProperty("options.abbrevs.expandOnInput"), Abbrevs.getExpandOnInput());
        panel2.add(this.expandOnInput);
        panel.add((Component)panel2, "North");
        JPanel panel3 = new JPanel();
        panel3.add(new JLabel(jEdit.getProperty("options.abbrevs.set")));
        panel.add((Component)panel3, "South");
        Hashtable _modeAbbrevs = Abbrevs.getModeAbbrevs();
        this.modeAbbrevs = new Hashtable();
        Mode[] modes = jEdit.getModes();
        String[] sets = new String[modes.length + 1];
        sets[0] = "global";
        int i = 0;
        while (i < modes.length) {
            String name;
            sets[i + 1] = name = modes[i].getName();
            this.modeAbbrevs.put(name, new AbbrevsModel((Hashtable)_modeAbbrevs.get(name)));
            ++i;
        }
        this.setsComboBox = new JComboBox<String>(sets);
        this.setsComboBox.addActionListener(new ActionHandler());
        panel3.add(this.setsComboBox);
        this.add("North", panel);
        this.add("Center", this.createAbbrevsScroller());
        panel = new JPanel();
        this.abbrev = new JButton(jEdit.getProperty("options.abbrevs.sort.abbrev"));
        this.abbrev.addActionListener(new ActionHandler());
        panel.add(this.abbrev);
        this.expand = new JButton(jEdit.getProperty("options.abbrevs.sort.expand"));
        this.expand.addActionListener(new ActionHandler());
        panel.add(this.expand);
        this.add("South", panel);
    }

    public void save() {
        Abbrevs.setExpandOnInput(this.expandOnInput.getModel().isSelected());
        Abbrevs.setGlobalAbbrevs(this.globalAbbrevs.toHashtable());
        Hashtable modeHash = new Hashtable();
        Enumeration keys = this.modeAbbrevs.keys();
        Enumeration values = this.modeAbbrevs.elements();
        while (keys.hasMoreElements()) {
            modeHash.put(keys.nextElement(), ((AbbrevsModel)values.nextElement()).toHashtable());
        }
        Abbrevs.setModeAbbrevs(modeHash);
    }

    private JScrollPane createAbbrevsScroller() {
        this.globalAbbrevs = new AbbrevsModel(Abbrevs.getGlobalAbbrevs());
        this.abbrevsTable = new JTable(this.globalAbbrevs);
        this.abbrevsTable.getTableHeader().setReorderingAllowed(false);
        Dimension d = this.abbrevsTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.abbrevsTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == AbbrevsOptionPane.this.setsComboBox) {
                String selected = (String)AbbrevsOptionPane.this.setsComboBox.getSelectedItem();
                if (selected.equals("global")) {
                    AbbrevsOptionPane.this.abbrevsTable.setModel(AbbrevsOptionPane.this.globalAbbrevs);
                } else {
                    AbbrevsOptionPane.this.abbrevsTable.setModel((AbbrevsModel)AbbrevsOptionPane.this.modeAbbrevs.get(selected));
                }
            } else {
                ((AbbrevsModel)AbbrevsOptionPane.this.abbrevsTable.getModel()).sort(source == AbbrevsOptionPane.this.abbrev ? 0 : 1);
            }
        }
    }
}

